/*
 * SendinBlue API
 * SendinBlue provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/sendinblue  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  | 
 *
 * OpenAPI spec version: 3.0.0
 * Contact: contact@sendinblue.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package sibApi;

import sendinblue.ApiCallback;
import sendinblue.ApiClient;
import sendinblue.ApiException;
import sendinblue.ApiResponse;
import sendinblue.Configuration;
import sendinblue.Pair;
import sendinblue.ProgressRequestBody;
import sendinblue.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import sibModel.CreateModel;
import sibModel.CreateSubAccount;
import sibModel.ErrorModel;
import sibModel.GetSsoToken;
import sibModel.MasterDetailsResponse;
import sibModel.SsoTokenRequest;
import sibModel.SubAccountDetailsResponse;
import sibModel.SubAccountUpdatePlanRequest;
import sibModel.SubAccountsResponse;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MasterAccountApi {
    private ApiClient apiClient;

    public MasterAccountApi() {
        this(Configuration.getDefaultApiClient());
    }

    public MasterAccountApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for corporateMasterAccountGet
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call corporateMasterAccountGetCall(final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/corporate/masterAccount";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "api-key", "partner-key" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call corporateMasterAccountGetValidateBeforeCall(final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        

        com.squareup.okhttp.Call call = corporateMasterAccountGetCall(progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get the details of requested master account
     * This endpoint will provide the details of the master account.
     * @return MasterDetailsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public MasterDetailsResponse corporateMasterAccountGet() throws ApiException {
        ApiResponse<MasterDetailsResponse> resp = corporateMasterAccountGetWithHttpInfo();
        return resp.getData();
    }

    /**
     * Get the details of requested master account
     * This endpoint will provide the details of the master account.
     * @return ApiResponse&lt;MasterDetailsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<MasterDetailsResponse> corporateMasterAccountGetWithHttpInfo() throws ApiException {
        com.squareup.okhttp.Call call = corporateMasterAccountGetValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<MasterDetailsResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get the details of requested master account (asynchronously)
     * This endpoint will provide the details of the master account.
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call corporateMasterAccountGetAsync(final ApiCallback<MasterDetailsResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = corporateMasterAccountGetValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<MasterDetailsResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for corporateSubAccountGet
     * @param offset Page number of sub-accounts listing (required)
     * @param limit Number of sub-accounts to be displayed on each page (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call corporateSubAccountGetCall(Integer offset, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/corporate/subAccount";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (offset != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("offset", offset));
        if (limit != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "api-key", "partner-key" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call corporateSubAccountGetValidateBeforeCall(Integer offset, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'offset' is set
        if (offset == null) {
            throw new ApiException("Missing the required parameter 'offset' when calling corporateSubAccountGet(Async)");
        }
        
        // verify the required parameter 'limit' is set
        if (limit == null) {
            throw new ApiException("Missing the required parameter 'limit' when calling corporateSubAccountGet(Async)");
        }
        

        com.squareup.okhttp.Call call = corporateSubAccountGetCall(offset, limit, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get the list of all the sub-accounts of the master account.
     * This endpoint will provide the list all the sub-accounts of the master account.
     * @param offset Page number of sub-accounts listing (required)
     * @param limit Number of sub-accounts to be displayed on each page (required)
     * @return SubAccountsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public SubAccountsResponse corporateSubAccountGet(Integer offset, Integer limit) throws ApiException {
        ApiResponse<SubAccountsResponse> resp = corporateSubAccountGetWithHttpInfo(offset, limit);
        return resp.getData();
    }

    /**
     * Get the list of all the sub-accounts of the master account.
     * This endpoint will provide the list all the sub-accounts of the master account.
     * @param offset Page number of sub-accounts listing (required)
     * @param limit Number of sub-accounts to be displayed on each page (required)
     * @return ApiResponse&lt;SubAccountsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<SubAccountsResponse> corporateSubAccountGetWithHttpInfo(Integer offset, Integer limit) throws ApiException {
        com.squareup.okhttp.Call call = corporateSubAccountGetValidateBeforeCall(offset, limit, null, null);
        Type localVarReturnType = new TypeToken<SubAccountsResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get the list of all the sub-accounts of the master account. (asynchronously)
     * This endpoint will provide the list all the sub-accounts of the master account.
     * @param offset Page number of sub-accounts listing (required)
     * @param limit Number of sub-accounts to be displayed on each page (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call corporateSubAccountGetAsync(Integer offset, Integer limit, final ApiCallback<SubAccountsResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = corporateSubAccountGetValidateBeforeCall(offset, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SubAccountsResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for corporateSubAccountIdDelete
     * @param id Id of the sub-account organization to be deleted (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call corporateSubAccountIdDeleteCall(Long id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/corporate/subAccount/{id}"
            .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "api-key", "partner-key" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call corporateSubAccountIdDeleteValidateBeforeCall(Long id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling corporateSubAccountIdDelete(Async)");
        }
        

        com.squareup.okhttp.Call call = corporateSubAccountIdDeleteCall(id, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Delete a sub-account
     * 
     * @param id Id of the sub-account organization to be deleted (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void corporateSubAccountIdDelete(Long id) throws ApiException {
        corporateSubAccountIdDeleteWithHttpInfo(id);
    }

    /**
     * Delete a sub-account
     * 
     * @param id Id of the sub-account organization to be deleted (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> corporateSubAccountIdDeleteWithHttpInfo(Long id) throws ApiException {
        com.squareup.okhttp.Call call = corporateSubAccountIdDeleteValidateBeforeCall(id, null, null);
        return apiClient.execute(call);
    }

    /**
     * Delete a sub-account (asynchronously)
     * 
     * @param id Id of the sub-account organization to be deleted (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call corporateSubAccountIdDeleteAsync(Long id, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = corporateSubAccountIdDeleteValidateBeforeCall(id, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for corporateSubAccountIdGet
     * @param id Id of the sub-account organization (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call corporateSubAccountIdGetCall(Long id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/corporate/subAccount/{id}"
            .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "api-key", "partner-key" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call corporateSubAccountIdGetValidateBeforeCall(Long id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling corporateSubAccountIdGet(Async)");
        }
        

        com.squareup.okhttp.Call call = corporateSubAccountIdGetCall(id, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get sub-account details
     * This endpoint will provide the details of specified sub-account organization
     * @param id Id of the sub-account organization (required)
     * @return SubAccountDetailsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public SubAccountDetailsResponse corporateSubAccountIdGet(Long id) throws ApiException {
        ApiResponse<SubAccountDetailsResponse> resp = corporateSubAccountIdGetWithHttpInfo(id);
        return resp.getData();
    }

    /**
     * Get sub-account details
     * This endpoint will provide the details of specified sub-account organization
     * @param id Id of the sub-account organization (required)
     * @return ApiResponse&lt;SubAccountDetailsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<SubAccountDetailsResponse> corporateSubAccountIdGetWithHttpInfo(Long id) throws ApiException {
        com.squareup.okhttp.Call call = corporateSubAccountIdGetValidateBeforeCall(id, null, null);
        Type localVarReturnType = new TypeToken<SubAccountDetailsResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get sub-account details (asynchronously)
     * This endpoint will provide the details of specified sub-account organization
     * @param id Id of the sub-account organization (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call corporateSubAccountIdGetAsync(Long id, final ApiCallback<SubAccountDetailsResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = corporateSubAccountIdGetValidateBeforeCall(id, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SubAccountDetailsResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for corporateSubAccountIdPlanPut
     * @param id Id of the sub-account organization (required)
     * @param updatePlanDetails Values to update a sub-account plan (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call corporateSubAccountIdPlanPutCall(Long id, SubAccountUpdatePlanRequest updatePlanDetails, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = updatePlanDetails;

        // create path and map variables
        String localVarPath = "/corporate/subAccount/{id}/plan"
            .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "api-key", "partner-key" };
        return apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call corporateSubAccountIdPlanPutValidateBeforeCall(Long id, SubAccountUpdatePlanRequest updatePlanDetails, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling corporateSubAccountIdPlanPut(Async)");
        }
        
        // verify the required parameter 'updatePlanDetails' is set
        if (updatePlanDetails == null) {
            throw new ApiException("Missing the required parameter 'updatePlanDetails' when calling corporateSubAccountIdPlanPut(Async)");
        }
        

        com.squareup.okhttp.Call call = corporateSubAccountIdPlanPutCall(id, updatePlanDetails, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Update sub-account plan
     * This endpoint will update the sub-account plan
     * @param id Id of the sub-account organization (required)
     * @param updatePlanDetails Values to update a sub-account plan (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void corporateSubAccountIdPlanPut(Long id, SubAccountUpdatePlanRequest updatePlanDetails) throws ApiException {
        corporateSubAccountIdPlanPutWithHttpInfo(id, updatePlanDetails);
    }

    /**
     * Update sub-account plan
     * This endpoint will update the sub-account plan
     * @param id Id of the sub-account organization (required)
     * @param updatePlanDetails Values to update a sub-account plan (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> corporateSubAccountIdPlanPutWithHttpInfo(Long id, SubAccountUpdatePlanRequest updatePlanDetails) throws ApiException {
        com.squareup.okhttp.Call call = corporateSubAccountIdPlanPutValidateBeforeCall(id, updatePlanDetails, null, null);
        return apiClient.execute(call);
    }

    /**
     * Update sub-account plan (asynchronously)
     * This endpoint will update the sub-account plan
     * @param id Id of the sub-account organization (required)
     * @param updatePlanDetails Values to update a sub-account plan (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call corporateSubAccountIdPlanPutAsync(Long id, SubAccountUpdatePlanRequest updatePlanDetails, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = corporateSubAccountIdPlanPutValidateBeforeCall(id, updatePlanDetails, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for corporateSubAccountPost
     * @param subAccountCreate values to create new sub-account (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call corporateSubAccountPostCall(CreateSubAccount subAccountCreate, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = subAccountCreate;

        // create path and map variables
        String localVarPath = "/corporate/subAccount";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "api-key", "partner-key" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call corporateSubAccountPostValidateBeforeCall(CreateSubAccount subAccountCreate, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'subAccountCreate' is set
        if (subAccountCreate == null) {
            throw new ApiException("Missing the required parameter 'subAccountCreate' when calling corporateSubAccountPost(Async)");
        }
        

        com.squareup.okhttp.Call call = corporateSubAccountPostCall(subAccountCreate, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Create a new sub-account under a master account.
     * This endpoint will create a new sub-account under a master account
     * @param subAccountCreate values to create new sub-account (required)
     * @return CreateModel
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CreateModel corporateSubAccountPost(CreateSubAccount subAccountCreate) throws ApiException {
        ApiResponse<CreateModel> resp = corporateSubAccountPostWithHttpInfo(subAccountCreate);
        return resp.getData();
    }

    /**
     * Create a new sub-account under a master account.
     * This endpoint will create a new sub-account under a master account
     * @param subAccountCreate values to create new sub-account (required)
     * @return ApiResponse&lt;CreateModel&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CreateModel> corporateSubAccountPostWithHttpInfo(CreateSubAccount subAccountCreate) throws ApiException {
        com.squareup.okhttp.Call call = corporateSubAccountPostValidateBeforeCall(subAccountCreate, null, null);
        Type localVarReturnType = new TypeToken<CreateModel>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Create a new sub-account under a master account. (asynchronously)
     * This endpoint will create a new sub-account under a master account
     * @param subAccountCreate values to create new sub-account (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call corporateSubAccountPostAsync(CreateSubAccount subAccountCreate, final ApiCallback<CreateModel> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = corporateSubAccountPostValidateBeforeCall(subAccountCreate, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CreateModel>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for corporateSubAccountSsoTokenPost
     * @param ssoTokenRequest Values to generate SSO token for sub-account (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call corporateSubAccountSsoTokenPostCall(SsoTokenRequest ssoTokenRequest, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = ssoTokenRequest;

        // create path and map variables
        String localVarPath = "/corporate/subAccount/ssoToken";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "api-key", "partner-key" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call corporateSubAccountSsoTokenPostValidateBeforeCall(SsoTokenRequest ssoTokenRequest, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'ssoTokenRequest' is set
        if (ssoTokenRequest == null) {
            throw new ApiException("Missing the required parameter 'ssoTokenRequest' when calling corporateSubAccountSsoTokenPost(Async)");
        }
        

        com.squareup.okhttp.Call call = corporateSubAccountSsoTokenPostCall(ssoTokenRequest, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Generate SSO token to access Sendinblue
     * This endpoint generates an sso token to authenticate and access a sub-account of the master using the account endpoint https://app.sendinblue.com/account/login/sub-account/sso/[token], where [token] will be replaced with actual token.
     * @param ssoTokenRequest Values to generate SSO token for sub-account (required)
     * @return GetSsoToken
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public GetSsoToken corporateSubAccountSsoTokenPost(SsoTokenRequest ssoTokenRequest) throws ApiException {
        ApiResponse<GetSsoToken> resp = corporateSubAccountSsoTokenPostWithHttpInfo(ssoTokenRequest);
        return resp.getData();
    }

    /**
     * Generate SSO token to access Sendinblue
     * This endpoint generates an sso token to authenticate and access a sub-account of the master using the account endpoint https://app.sendinblue.com/account/login/sub-account/sso/[token], where [token] will be replaced with actual token.
     * @param ssoTokenRequest Values to generate SSO token for sub-account (required)
     * @return ApiResponse&lt;GetSsoToken&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<GetSsoToken> corporateSubAccountSsoTokenPostWithHttpInfo(SsoTokenRequest ssoTokenRequest) throws ApiException {
        com.squareup.okhttp.Call call = corporateSubAccountSsoTokenPostValidateBeforeCall(ssoTokenRequest, null, null);
        Type localVarReturnType = new TypeToken<GetSsoToken>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Generate SSO token to access Sendinblue (asynchronously)
     * This endpoint generates an sso token to authenticate and access a sub-account of the master using the account endpoint https://app.sendinblue.com/account/login/sub-account/sso/[token], where [token] will be replaced with actual token.
     * @param ssoTokenRequest Values to generate SSO token for sub-account (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call corporateSubAccountSsoTokenPostAsync(SsoTokenRequest ssoTokenRequest, final ApiCallback<GetSsoToken> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = corporateSubAccountSsoTokenPostValidateBeforeCall(ssoTokenRequest, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetSsoToken>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}
