/*
 * SendinBlue API
 * SendinBlue provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/sendinblue  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  | 
 *
 * OpenAPI spec version: 3.0.0
 * Contact: contact@sendinblue.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package sibApi;

import sendinblue.ApiCallback;
import sendinblue.ApiClient;
import sendinblue.ApiException;
import sendinblue.ApiResponse;
import sendinblue.Configuration;
import sendinblue.Pair;
import sendinblue.ProgressRequestBody;
import sendinblue.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import sibModel.ErrorModel;
import sibModel.GetInboundEmailEvents;
import sibModel.GetInboundEmailEventsByUuid;
import org.threeten.bp.LocalDate;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InboundParsingApi {
    private ApiClient apiClient;

    public InboundParsingApi() {
        this(Configuration.getDefaultApiClient());
    }

    public InboundParsingApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for getInboundEmailEvents
     * @param sender Email address of the sender. (optional)
     * @param startDate Mandatory if endDate is used. Starting date (YYYY-MM-DD) from which you want to fetch the list. Maximum time period that can be selected is one month. (optional)
     * @param endDate Mandatory if startDate is used. Ending date (YYYY-MM-DD) till which you want to fetch the list. Maximum time period that can be selected is one month. (optional)
     * @param limit Number of documents returned per page (optional, default to 100)
     * @param offset Index of the first document on the page (optional, default to 0)
     * @param sort Sort the results in the ascending/descending order of record creation (optional, default to desc)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getInboundEmailEventsCall(String sender, LocalDate startDate, LocalDate endDate, Long limit, Long offset, String sort, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/inbound/events";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (sender != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("sender", sender));
        if (startDate != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("startDate", startDate));
        if (endDate != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("endDate", endDate));
        if (limit != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
        if (offset != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("offset", offset));
        if (sort != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("sort", sort));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "api-key", "partner-key" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getInboundEmailEventsValidateBeforeCall(String sender, LocalDate startDate, LocalDate endDate, Long limit, Long offset, String sort, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        

        com.squareup.okhttp.Call call = getInboundEmailEventsCall(sender, startDate, endDate, limit, offset, sort, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get the list of all the events for the received emails.
     * This endpoint will show the list of all the events for the received emails.
     * @param sender Email address of the sender. (optional)
     * @param startDate Mandatory if endDate is used. Starting date (YYYY-MM-DD) from which you want to fetch the list. Maximum time period that can be selected is one month. (optional)
     * @param endDate Mandatory if startDate is used. Ending date (YYYY-MM-DD) till which you want to fetch the list. Maximum time period that can be selected is one month. (optional)
     * @param limit Number of documents returned per page (optional, default to 100)
     * @param offset Index of the first document on the page (optional, default to 0)
     * @param sort Sort the results in the ascending/descending order of record creation (optional, default to desc)
     * @return GetInboundEmailEvents
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public GetInboundEmailEvents getInboundEmailEvents(String sender, LocalDate startDate, LocalDate endDate, Long limit, Long offset, String sort) throws ApiException {
        ApiResponse<GetInboundEmailEvents> resp = getInboundEmailEventsWithHttpInfo(sender, startDate, endDate, limit, offset, sort);
        return resp.getData();
    }

    /**
     * Get the list of all the events for the received emails.
     * This endpoint will show the list of all the events for the received emails.
     * @param sender Email address of the sender. (optional)
     * @param startDate Mandatory if endDate is used. Starting date (YYYY-MM-DD) from which you want to fetch the list. Maximum time period that can be selected is one month. (optional)
     * @param endDate Mandatory if startDate is used. Ending date (YYYY-MM-DD) till which you want to fetch the list. Maximum time period that can be selected is one month. (optional)
     * @param limit Number of documents returned per page (optional, default to 100)
     * @param offset Index of the first document on the page (optional, default to 0)
     * @param sort Sort the results in the ascending/descending order of record creation (optional, default to desc)
     * @return ApiResponse&lt;GetInboundEmailEvents&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<GetInboundEmailEvents> getInboundEmailEventsWithHttpInfo(String sender, LocalDate startDate, LocalDate endDate, Long limit, Long offset, String sort) throws ApiException {
        com.squareup.okhttp.Call call = getInboundEmailEventsValidateBeforeCall(sender, startDate, endDate, limit, offset, sort, null, null);
        Type localVarReturnType = new TypeToken<GetInboundEmailEvents>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get the list of all the events for the received emails. (asynchronously)
     * This endpoint will show the list of all the events for the received emails.
     * @param sender Email address of the sender. (optional)
     * @param startDate Mandatory if endDate is used. Starting date (YYYY-MM-DD) from which you want to fetch the list. Maximum time period that can be selected is one month. (optional)
     * @param endDate Mandatory if startDate is used. Ending date (YYYY-MM-DD) till which you want to fetch the list. Maximum time period that can be selected is one month. (optional)
     * @param limit Number of documents returned per page (optional, default to 100)
     * @param offset Index of the first document on the page (optional, default to 0)
     * @param sort Sort the results in the ascending/descending order of record creation (optional, default to desc)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getInboundEmailEventsAsync(String sender, LocalDate startDate, LocalDate endDate, Long limit, Long offset, String sort, final ApiCallback<GetInboundEmailEvents> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getInboundEmailEventsValidateBeforeCall(sender, startDate, endDate, limit, offset, sort, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetInboundEmailEvents>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getInboundEmailEventsByUuid
     * @param uuid UUID to fetch events specific to recieved email (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getInboundEmailEventsByUuidCall(String uuid, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/inbound/events/{uuid}"
            .replaceAll("\\{" + "uuid" + "\\}", apiClient.escapeString(uuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "api-key", "partner-key" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getInboundEmailEventsByUuidValidateBeforeCall(String uuid, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'uuid' is set
        if (uuid == null) {
            throw new ApiException("Missing the required parameter 'uuid' when calling getInboundEmailEventsByUuid(Async)");
        }
        

        com.squareup.okhttp.Call call = getInboundEmailEventsByUuidCall(uuid, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Fetch all events history for one particular received email.
     * This endpoint will show the list of all events history for one particular received email.
     * @param uuid UUID to fetch events specific to recieved email (required)
     * @return GetInboundEmailEventsByUuid
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public GetInboundEmailEventsByUuid getInboundEmailEventsByUuid(String uuid) throws ApiException {
        ApiResponse<GetInboundEmailEventsByUuid> resp = getInboundEmailEventsByUuidWithHttpInfo(uuid);
        return resp.getData();
    }

    /**
     * Fetch all events history for one particular received email.
     * This endpoint will show the list of all events history for one particular received email.
     * @param uuid UUID to fetch events specific to recieved email (required)
     * @return ApiResponse&lt;GetInboundEmailEventsByUuid&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<GetInboundEmailEventsByUuid> getInboundEmailEventsByUuidWithHttpInfo(String uuid) throws ApiException {
        com.squareup.okhttp.Call call = getInboundEmailEventsByUuidValidateBeforeCall(uuid, null, null);
        Type localVarReturnType = new TypeToken<GetInboundEmailEventsByUuid>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Fetch all events history for one particular received email. (asynchronously)
     * This endpoint will show the list of all events history for one particular received email.
     * @param uuid UUID to fetch events specific to recieved email (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getInboundEmailEventsByUuidAsync(String uuid, final ApiCallback<GetInboundEmailEventsByUuid> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getInboundEmailEventsByUuidValidateBeforeCall(uuid, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetInboundEmailEventsByUuid>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}
