/*
 * Decompiled with CFR 0.152.
 */
package sibModel;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import sibModel.SendEmailAttachment;

public class SendEmail {
    @SerializedName(value="emailTo")
    private List<String> emailTo = new ArrayList<String>();
    @SerializedName(value="emailBcc")
    private List<String> emailBcc = null;
    @SerializedName(value="emailCc")
    private List<String> emailCc = null;
    @SerializedName(value="replyTo")
    private String replyTo = null;
    @SerializedName(value="attachmentUrl")
    private String attachmentUrl = null;
    @SerializedName(value="attachment")
    private List<SendEmailAttachment> attachment = null;
    @SerializedName(value="headers")
    private Object headers = null;
    @SerializedName(value="attributes")
    private Object attributes = null;
    @SerializedName(value="tags")
    private List<String> tags = null;

    public SendEmail emailTo(List<String> emailTo) {
        this.emailTo = emailTo;
        return this;
    }

    public SendEmail addEmailToItem(String emailToItem) {
        this.emailTo.add(emailToItem);
        return this;
    }

    @ApiModelProperty(required=true, value="List of the email addresses of the recipients. For example, ['abc@example.com', 'asd@example.com'].")
    public List<String> getEmailTo() {
        return this.emailTo;
    }

    public void setEmailTo(List<String> emailTo) {
        this.emailTo = emailTo;
    }

    public SendEmail emailBcc(List<String> emailBcc) {
        this.emailBcc = emailBcc;
        return this;
    }

    public SendEmail addEmailBccItem(String emailBccItem) {
        if (this.emailBcc == null) {
            this.emailBcc = new ArrayList<String>();
        }
        this.emailBcc.add(emailBccItem);
        return this;
    }

    @ApiModelProperty(value="List of the email addresses of the recipients in bcc")
    public List<String> getEmailBcc() {
        return this.emailBcc;
    }

    public void setEmailBcc(List<String> emailBcc) {
        this.emailBcc = emailBcc;
    }

    public SendEmail emailCc(List<String> emailCc) {
        this.emailCc = emailCc;
        return this;
    }

    public SendEmail addEmailCcItem(String emailCcItem) {
        if (this.emailCc == null) {
            this.emailCc = new ArrayList<String>();
        }
        this.emailCc.add(emailCcItem);
        return this;
    }

    @ApiModelProperty(value="List of the email addresses of the recipients in cc")
    public List<String> getEmailCc() {
        return this.emailCc;
    }

    public void setEmailCc(List<String> emailCc) {
        this.emailCc = emailCc;
    }

    public SendEmail replyTo(String replyTo) {
        this.replyTo = replyTo;
        return this;
    }

    @ApiModelProperty(example="support@myshop.com", value="Email address which shall be used by campaign recipients to reply back")
    public String getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(String replyTo) {
        this.replyTo = replyTo;
    }

    public SendEmail attachmentUrl(String attachmentUrl) {
        this.attachmentUrl = attachmentUrl;
        return this;
    }

    @ApiModelProperty(example="https://attachment.domain.com", value="Absolute url of the attachment (no local file). Extension allowed: xlsx, xls, ods, docx, docm, doc, csv, pdf, txt, gif, jpg, jpeg, png, tif, tiff, rtf, bmp, cgm, css, shtml, html, htm, zip, xml, ppt, pptx, tar, ez, ics, mobi, msg, pub and eps")
    public String getAttachmentUrl() {
        return this.attachmentUrl;
    }

    public void setAttachmentUrl(String attachmentUrl) {
        this.attachmentUrl = attachmentUrl;
    }

    public SendEmail attachment(List<SendEmailAttachment> attachment) {
        this.attachment = attachment;
        return this;
    }

    public SendEmail addAttachmentItem(SendEmailAttachment attachmentItem) {
        if (this.attachment == null) {
            this.attachment = new ArrayList<SendEmailAttachment>();
        }
        this.attachment.add(attachmentItem);
        return this;
    }

    @ApiModelProperty(value="Pass the list of content ( byte array which is encoded to base64 chunk data at our end ) and name of the attachment. For example, [{'content':'byte array content 1', 'name':'attcahment1'}, {'content':'byte array content 2', 'name':'attcahment2'}].")
    public List<SendEmailAttachment> getAttachment() {
        return this.attachment;
    }

    public void setAttachment(List<SendEmailAttachment> attachment) {
        this.attachment = attachment;
    }

    public SendEmail headers(Object headers) {
        this.headers = headers;
        return this;
    }

    @ApiModelProperty(example="{\"Content-Type\":\"text/html\",\"charset\":\"iso-8859-1\",\"X-Mailin-IP\":\"1.2.3.4\"}", value="Pass the set of headers that shall be sent along the mail headers in the original email. 'X-Mailin-IP' header can be set (only for dedicated ip users) to mention the IP to be used for sending transactional emails. For example, {'Content-Type':'text/html', 'charset':'iso-8859-1', 'X-Mailin-IP':'1.2.3.4'}")
    public Object getHeaders() {
        return this.headers;
    }

    public void setHeaders(Object headers) {
        this.headers = headers;
    }

    public SendEmail attributes(Object attributes) {
        this.attributes = attributes;
        return this;
    }

    @ApiModelProperty(example="{\"FNAME\":\"Joe\",\"LNAME\":\"Doe\"}", value="Pass the set of attributes to customize the template. For example, {'FNAME':'Joe', 'LNAME':'Doe'}")
    public Object getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Object attributes) {
        this.attributes = attributes;
    }

    public SendEmail tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public SendEmail addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @ApiModelProperty(value="Tag your emails to find them more easily")
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SendEmail sendEmail = (SendEmail)o;
        return ObjectUtils.equals(this.emailTo, sendEmail.emailTo) && ObjectUtils.equals(this.emailBcc, sendEmail.emailBcc) && ObjectUtils.equals(this.emailCc, sendEmail.emailCc) && ObjectUtils.equals((Object)this.replyTo, (Object)sendEmail.replyTo) && ObjectUtils.equals((Object)this.attachmentUrl, (Object)sendEmail.attachmentUrl) && ObjectUtils.equals(this.attachment, sendEmail.attachment) && ObjectUtils.equals((Object)this.headers, (Object)sendEmail.headers) && ObjectUtils.equals((Object)this.attributes, (Object)sendEmail.attributes) && ObjectUtils.equals(this.tags, sendEmail.tags);
    }

    public int hashCode() {
        return ObjectUtils.hashCodeMulti((Object[])new Object[]{this.emailTo, this.emailBcc, this.emailCc, this.replyTo, this.attachmentUrl, this.attachment, this.headers, this.attributes, this.tags});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SendEmail {\n");
        sb.append("    emailTo: ").append(this.toIndentedString(this.emailTo)).append("\n");
        sb.append("    emailBcc: ").append(this.toIndentedString(this.emailBcc)).append("\n");
        sb.append("    emailCc: ").append(this.toIndentedString(this.emailCc)).append("\n");
        sb.append("    replyTo: ").append(this.toIndentedString(this.replyTo)).append("\n");
        sb.append("    attachmentUrl: ").append(this.toIndentedString(this.attachmentUrl)).append("\n");
        sb.append("    attachment: ").append(this.toIndentedString(this.attachment)).append("\n");
        sb.append("    headers: ").append(this.toIndentedString(this.headers)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

