/*
 * Decompiled with CFR 0.152.
 */
package sibModel;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;

public class CreateWebhook {
    @SerializedName(value="url")
    private String url = null;
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="events")
    private List<EventsEnum> events = null;
    @SerializedName(value="type")
    private TypeEnum type = TypeEnum.TRANSACTIONAL;

    public CreateWebhook url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(example="http://requestb.in/173lyyx1", required=true, value="URL of the webhook")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public CreateWebhook description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="Webhook triggered on unsubscription", value="Description of the webhook")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CreateWebhook events(List<EventsEnum> events) {
        this.events = events;
        return this;
    }

    public CreateWebhook addEventsItem(EventsEnum eventsItem) {
        if (this.events == null) {
            this.events = new ArrayList<EventsEnum>();
        }
        this.events.add(eventsItem);
        return this;
    }

    @ApiModelProperty(value="Events triggering the webhook. Possible values for Transactional type webhook \u2013 request, delivered, hardBounce, softBounce, blocked, spam, invalid, deferred, click, opened, uniqueOpened and unsubscribed and possible values for Marketing type webhook \u2013 spam, opened, click, hardBounce, softBounce, unsubscribed, listAddition & delivered")
    public List<EventsEnum> getEvents() {
        return this.events;
    }

    public void setEvents(List<EventsEnum> events) {
        this.events = events;
    }

    public CreateWebhook type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="marketing", value="Type of the webhook")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateWebhook createWebhook = (CreateWebhook)o;
        return ObjectUtils.equals((Object)this.url, (Object)createWebhook.url) && ObjectUtils.equals((Object)this.description, (Object)createWebhook.description) && ObjectUtils.equals(this.events, createWebhook.events) && ObjectUtils.equals((Object)((Object)this.type), (Object)((Object)createWebhook.type));
    }

    public int hashCode() {
        return ObjectUtils.hashCodeMulti((Object[])new Object[]{this.url, this.description, this.events, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateWebhook {\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    events: ").append(this.toIndentedString(this.events)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        TRANSACTIONAL("transactional"),
        MARKETING("marketing");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum EventsEnum {
        HARDBOUNCE("hardBounce"),
        SOFTBOUNCE("softBounce"),
        BLOCKED("blocked"),
        SPAM("spam"),
        DELIVERED("delivered"),
        REQUEST("request"),
        CLICK("click"),
        INVALID("invalid"),
        DEFERRED("deferred"),
        OPENED("opened"),
        UNIQUEOPENED("uniqueOpened"),
        UNSUBSCRIBED("unsubscribed"),
        LISTADDITION("listAddition");

        private String value;

        private EventsEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static EventsEnum fromValue(String text) {
            for (EventsEnum b : EventsEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<EventsEnum> {
            public void write(JsonWriter jsonWriter, EventsEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public EventsEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return EventsEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

