/*
 * Decompiled with CFR 0.152.
 */
package sibApi;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import sendinblue.ApiCallback;
import sendinblue.ApiClient;
import sendinblue.ApiException;
import sendinblue.ApiResponse;
import sendinblue.Configuration;
import sendinblue.Pair;
import sendinblue.ProgressRequestBody;
import sendinblue.ProgressResponseBody;
import sibModel.AddCredits;
import sibModel.CreateChild;
import sibModel.CreateReseller;
import sibModel.GetChildInfo;
import sibModel.GetChildrenList;
import sibModel.ManageIp;
import sibModel.RemainingCreditModel;
import sibModel.RemoveCredits;
import sibModel.UpdateChild;

public class ResellerApi {
    private ApiClient apiClient;

    public ResellerApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ResellerApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call addCreditsCall(String childAuthKey, AddCredits addCredits, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        AddCredits localVarPostBody = addCredits;
        String localVarPath = "/reseller/children/{childAuthKey}/credits/add".replaceAll("\\{childAuthKey\\}", this.apiClient.escapeString(childAuthKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call addCreditsValidateBeforeCall(String childAuthKey, AddCredits addCredits, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (childAuthKey == null) {
            throw new ApiException("Missing the required parameter 'childAuthKey' when calling addCredits(Async)");
        }
        if (addCredits == null) {
            throw new ApiException("Missing the required parameter 'addCredits' when calling addCredits(Async)");
        }
        Call call = this.addCreditsCall(childAuthKey, addCredits, progressListener, progressRequestListener);
        return call;
    }

    public RemainingCreditModel addCredits(String childAuthKey, AddCredits addCredits) throws ApiException {
        ApiResponse<RemainingCreditModel> resp = this.addCreditsWithHttpInfo(childAuthKey, addCredits);
        return resp.getData();
    }

    public ApiResponse<RemainingCreditModel> addCreditsWithHttpInfo(String childAuthKey, AddCredits addCredits) throws ApiException {
        Call call = this.addCreditsValidateBeforeCall(childAuthKey, addCredits, null, null);
        Type localVarReturnType = new TypeToken<RemainingCreditModel>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call addCreditsAsync(String childAuthKey, AddCredits addCredits, final ApiCallback<RemainingCreditModel> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.addCreditsValidateBeforeCall(childAuthKey, addCredits, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<RemainingCreditModel>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call associateIpToChildCall(String childAuthKey, ManageIp ip, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ManageIp localVarPostBody = ip;
        String localVarPath = "/reseller/children/{childAuthKey}/ips/associate".replaceAll("\\{childAuthKey\\}", this.apiClient.escapeString(childAuthKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call associateIpToChildValidateBeforeCall(String childAuthKey, ManageIp ip, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (childAuthKey == null) {
            throw new ApiException("Missing the required parameter 'childAuthKey' when calling associateIpToChild(Async)");
        }
        if (ip == null) {
            throw new ApiException("Missing the required parameter 'ip' when calling associateIpToChild(Async)");
        }
        Call call = this.associateIpToChildCall(childAuthKey, ip, progressListener, progressRequestListener);
        return call;
    }

    public void associateIpToChild(String childAuthKey, ManageIp ip) throws ApiException {
        this.associateIpToChildWithHttpInfo(childAuthKey, ip);
    }

    public ApiResponse<Void> associateIpToChildWithHttpInfo(String childAuthKey, ManageIp ip) throws ApiException {
        Call call = this.associateIpToChildValidateBeforeCall(childAuthKey, ip, null, null);
        return this.apiClient.execute(call);
    }

    public Call associateIpToChildAsync(String childAuthKey, ManageIp ip, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.associateIpToChildValidateBeforeCall(childAuthKey, ip, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call createResellerChildCall(CreateChild resellerChild, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CreateChild localVarPostBody = resellerChild;
        String localVarPath = "/reseller/children";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createResellerChildValidateBeforeCall(CreateChild resellerChild, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.createResellerChildCall(resellerChild, progressListener, progressRequestListener);
        return call;
    }

    public CreateReseller createResellerChild(CreateChild resellerChild) throws ApiException {
        ApiResponse<CreateReseller> resp = this.createResellerChildWithHttpInfo(resellerChild);
        return resp.getData();
    }

    public ApiResponse<CreateReseller> createResellerChildWithHttpInfo(CreateChild resellerChild) throws ApiException {
        Call call = this.createResellerChildValidateBeforeCall(resellerChild, null, null);
        Type localVarReturnType = new TypeToken<CreateReseller>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createResellerChildAsync(CreateChild resellerChild, final ApiCallback<CreateReseller> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createResellerChildValidateBeforeCall(resellerChild, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CreateReseller>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteResellerChildCall(String childAuthKey, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/reseller/children/{childAuthKey}".replaceAll("\\{childAuthKey\\}", this.apiClient.escapeString(childAuthKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteResellerChildValidateBeforeCall(String childAuthKey, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (childAuthKey == null) {
            throw new ApiException("Missing the required parameter 'childAuthKey' when calling deleteResellerChild(Async)");
        }
        Call call = this.deleteResellerChildCall(childAuthKey, progressListener, progressRequestListener);
        return call;
    }

    public void deleteResellerChild(String childAuthKey) throws ApiException {
        this.deleteResellerChildWithHttpInfo(childAuthKey);
    }

    public ApiResponse<Void> deleteResellerChildWithHttpInfo(String childAuthKey) throws ApiException {
        Call call = this.deleteResellerChildValidateBeforeCall(childAuthKey, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteResellerChildAsync(String childAuthKey, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteResellerChildValidateBeforeCall(childAuthKey, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call dissociateIpFromChildCall(String childAuthKey, ManageIp ip, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ManageIp localVarPostBody = ip;
        String localVarPath = "/reseller/children/{childAuthKey}/ips/dissociate".replaceAll("\\{childAuthKey\\}", this.apiClient.escapeString(childAuthKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call dissociateIpFromChildValidateBeforeCall(String childAuthKey, ManageIp ip, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (childAuthKey == null) {
            throw new ApiException("Missing the required parameter 'childAuthKey' when calling dissociateIpFromChild(Async)");
        }
        if (ip == null) {
            throw new ApiException("Missing the required parameter 'ip' when calling dissociateIpFromChild(Async)");
        }
        Call call = this.dissociateIpFromChildCall(childAuthKey, ip, progressListener, progressRequestListener);
        return call;
    }

    public void dissociateIpFromChild(String childAuthKey, ManageIp ip) throws ApiException {
        this.dissociateIpFromChildWithHttpInfo(childAuthKey, ip);
    }

    public ApiResponse<Void> dissociateIpFromChildWithHttpInfo(String childAuthKey, ManageIp ip) throws ApiException {
        Call call = this.dissociateIpFromChildValidateBeforeCall(childAuthKey, ip, null, null);
        return this.apiClient.execute(call);
    }

    public Call dissociateIpFromChildAsync(String childAuthKey, ManageIp ip, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.dissociateIpFromChildValidateBeforeCall(childAuthKey, ip, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call getChildInfoCall(String childAuthKey, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/reseller/children/{childAuthKey}".replaceAll("\\{childAuthKey\\}", this.apiClient.escapeString(childAuthKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getChildInfoValidateBeforeCall(String childAuthKey, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (childAuthKey == null) {
            throw new ApiException("Missing the required parameter 'childAuthKey' when calling getChildInfo(Async)");
        }
        Call call = this.getChildInfoCall(childAuthKey, progressListener, progressRequestListener);
        return call;
    }

    public GetChildInfo getChildInfo(String childAuthKey) throws ApiException {
        ApiResponse<GetChildInfo> resp = this.getChildInfoWithHttpInfo(childAuthKey);
        return resp.getData();
    }

    public ApiResponse<GetChildInfo> getChildInfoWithHttpInfo(String childAuthKey) throws ApiException {
        Call call = this.getChildInfoValidateBeforeCall(childAuthKey, null, null);
        Type localVarReturnType = new TypeToken<GetChildInfo>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getChildInfoAsync(String childAuthKey, final ApiCallback<GetChildInfo> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getChildInfoValidateBeforeCall(childAuthKey, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetChildInfo>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getResellerChildsCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/reseller/children";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getResellerChildsValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getResellerChildsCall(progressListener, progressRequestListener);
        return call;
    }

    public GetChildrenList getResellerChilds() throws ApiException {
        ApiResponse<GetChildrenList> resp = this.getResellerChildsWithHttpInfo();
        return resp.getData();
    }

    public ApiResponse<GetChildrenList> getResellerChildsWithHttpInfo() throws ApiException {
        Call call = this.getResellerChildsValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<GetChildrenList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getResellerChildsAsync(final ApiCallback<GetChildrenList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getResellerChildsValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetChildrenList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call removeCreditsCall(String childAuthKey, RemoveCredits removeCredits, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        RemoveCredits localVarPostBody = removeCredits;
        String localVarPath = "/reseller/children/{childAuthKey}/credits/remove".replaceAll("\\{childAuthKey\\}", this.apiClient.escapeString(childAuthKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call removeCreditsValidateBeforeCall(String childAuthKey, RemoveCredits removeCredits, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (childAuthKey == null) {
            throw new ApiException("Missing the required parameter 'childAuthKey' when calling removeCredits(Async)");
        }
        if (removeCredits == null) {
            throw new ApiException("Missing the required parameter 'removeCredits' when calling removeCredits(Async)");
        }
        Call call = this.removeCreditsCall(childAuthKey, removeCredits, progressListener, progressRequestListener);
        return call;
    }

    public RemainingCreditModel removeCredits(String childAuthKey, RemoveCredits removeCredits) throws ApiException {
        ApiResponse<RemainingCreditModel> resp = this.removeCreditsWithHttpInfo(childAuthKey, removeCredits);
        return resp.getData();
    }

    public ApiResponse<RemainingCreditModel> removeCreditsWithHttpInfo(String childAuthKey, RemoveCredits removeCredits) throws ApiException {
        Call call = this.removeCreditsValidateBeforeCall(childAuthKey, removeCredits, null, null);
        Type localVarReturnType = new TypeToken<RemainingCreditModel>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call removeCreditsAsync(String childAuthKey, RemoveCredits removeCredits, final ApiCallback<RemainingCreditModel> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.removeCreditsValidateBeforeCall(childAuthKey, removeCredits, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<RemainingCreditModel>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateResellerChildCall(String childAuthKey, UpdateChild resellerChild, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        UpdateChild localVarPostBody = resellerChild;
        String localVarPath = "/reseller/children/{childAuthKey}".replaceAll("\\{childAuthKey\\}", this.apiClient.escapeString(childAuthKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateResellerChildValidateBeforeCall(String childAuthKey, UpdateChild resellerChild, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (childAuthKey == null) {
            throw new ApiException("Missing the required parameter 'childAuthKey' when calling updateResellerChild(Async)");
        }
        if (resellerChild == null) {
            throw new ApiException("Missing the required parameter 'resellerChild' when calling updateResellerChild(Async)");
        }
        Call call = this.updateResellerChildCall(childAuthKey, resellerChild, progressListener, progressRequestListener);
        return call;
    }

    public void updateResellerChild(String childAuthKey, UpdateChild resellerChild) throws ApiException {
        this.updateResellerChildWithHttpInfo(childAuthKey, resellerChild);
    }

    public ApiResponse<Void> updateResellerChildWithHttpInfo(String childAuthKey, UpdateChild resellerChild) throws ApiException {
        Call call = this.updateResellerChildValidateBeforeCall(childAuthKey, resellerChild, null, null);
        return this.apiClient.execute(call);
    }

    public Call updateResellerChildAsync(String childAuthKey, UpdateChild resellerChild, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateResellerChildValidateBeforeCall(childAuthKey, resellerChild, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }
}

