/*
 * SendinBlue API
 * SendinBlue provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/sendinblue  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  | 
 *
 * OpenAPI spec version: 3.0.0
 * Contact: contact@sendinblue.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package sibModel;

import org.apache.commons.lang3.ObjectUtils;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import org.threeten.bp.OffsetDateTime;
import sibModel.UpdateEmailCampaignRecipients;
import sibModel.UpdateEmailCampaignSender;

/**
 * UpdateEmailCampaign
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2018-05-24T12:07:09.251+05:30")
public class UpdateEmailCampaign {
  @SerializedName("tag")
  private String tag = null;

  @SerializedName("sender")
  private UpdateEmailCampaignSender sender = null;

  @SerializedName("name")
  private String name = null;

  @SerializedName("htmlContent")
  private String htmlContent = null;

  @SerializedName("htmlUrl")
  private String htmlUrl = null;

  @SerializedName("scheduledAt")
  private OffsetDateTime scheduledAt = null;

  @SerializedName("subject")
  private String subject = null;

  @SerializedName("replyTo")
  private String replyTo = null;

  @SerializedName("toField")
  private String toField = null;

  @SerializedName("recipients")
  private UpdateEmailCampaignRecipients recipients = null;

  @SerializedName("attachmentUrl")
  private String attachmentUrl = null;

  @SerializedName("inlineImageActivation")
  private Boolean inlineImageActivation = false;

  @SerializedName("mirrorActive")
  private Boolean mirrorActive = null;

  @SerializedName("recurring")
  private Boolean recurring = false;

  @SerializedName("footer")
  private String footer = null;

  @SerializedName("header")
  private String header = null;

  @SerializedName("utmCampaign")
  private String utmCampaign = null;

  public UpdateEmailCampaign tag(String tag) {
    this.tag = tag;
    return this;
  }

   /**
   * Tag of the campaign
   * @return tag
  **/
  @ApiModelProperty(example = "Newsletter", value = "Tag of the campaign")
  public String getTag() {
    return tag;
  }

  public void setTag(String tag) {
    this.tag = tag;
  }

  public UpdateEmailCampaign sender(UpdateEmailCampaignSender sender) {
    this.sender = sender;
    return this;
  }

   /**
   * Get sender
   * @return sender
  **/
  @ApiModelProperty(value = "")
  public UpdateEmailCampaignSender getSender() {
    return sender;
  }

  public void setSender(UpdateEmailCampaignSender sender) {
    this.sender = sender;
  }

  public UpdateEmailCampaign name(String name) {
    this.name = name;
    return this;
  }

   /**
   * Name of the campaign
   * @return name
  **/
  @ApiModelProperty(example = "Newsletter - May 2017", value = "Name of the campaign")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public UpdateEmailCampaign htmlContent(String htmlContent) {
    this.htmlContent = htmlContent;
    return this;
  }

   /**
   * Body of the message (HTML version). REQUIRED if htmlUrl is empty
   * @return htmlContent
  **/
  @ApiModelProperty(example = "Spring is here, discover my new collection", value = "Body of the message (HTML version). REQUIRED if htmlUrl is empty")
  public String getHtmlContent() {
    return htmlContent;
  }

  public void setHtmlContent(String htmlContent) {
    this.htmlContent = htmlContent;
  }

  public UpdateEmailCampaign htmlUrl(String htmlUrl) {
    this.htmlUrl = htmlUrl;
    return this;
  }

   /**
   * Url which contents the body of the email message. REQUIRED if htmlContent is empty
   * @return htmlUrl
  **/
  @ApiModelProperty(example = "https://html.domain.com", value = "Url which contents the body of the email message. REQUIRED if htmlContent is empty")
  public String getHtmlUrl() {
    return htmlUrl;
  }

  public void setHtmlUrl(String htmlUrl) {
    this.htmlUrl = htmlUrl;
  }

  public UpdateEmailCampaign scheduledAt(OffsetDateTime scheduledAt) {
    this.scheduledAt = scheduledAt;
    return this;
  }

   /**
   * UTC date-time on which the campaign has to run (YYYY-MM-DDTHH:mm:ss.SSSZ). Prefer to pass your timezone in date-time format for accurate result.
   * @return scheduledAt
  **/
  @ApiModelProperty(example = "2017-06-01T12:30:00+02:00", value = "UTC date-time on which the campaign has to run (YYYY-MM-DDTHH:mm:ss.SSSZ). Prefer to pass your timezone in date-time format for accurate result.")
  public OffsetDateTime getScheduledAt() {
    return scheduledAt;
  }

  public void setScheduledAt(OffsetDateTime scheduledAt) {
    this.scheduledAt = scheduledAt;
  }

  public UpdateEmailCampaign subject(String subject) {
    this.subject = subject;
    return this;
  }

   /**
   * Subject of the campaign
   * @return subject
  **/
  @ApiModelProperty(example = "Discover the New Collection !", value = "Subject of the campaign")
  public String getSubject() {
    return subject;
  }

  public void setSubject(String subject) {
    this.subject = subject;
  }

  public UpdateEmailCampaign replyTo(String replyTo) {
    this.replyTo = replyTo;
    return this;
  }

   /**
   * Email on which campaign recipients will be able to reply to
   * @return replyTo
  **/
  @ApiModelProperty(example = "support@myshop.com", value = "Email on which campaign recipients will be able to reply to")
  public String getReplyTo() {
    return replyTo;
  }

  public void setReplyTo(String replyTo) {
    this.replyTo = replyTo;
  }

  public UpdateEmailCampaign toField(String toField) {
    this.toField = toField;
    return this;
  }

   /**
   * This is to personalize the «To» Field. If you want to include the first name and last name of your recipient, add {FNAME} {LNAME}. To use the contact attributes here, these must already exist in SendinBlue account
   * @return toField
  **/
  @ApiModelProperty(example = "{FNAME} {LNAME}", value = "This is to personalize the «To» Field. If you want to include the first name and last name of your recipient, add {FNAME} {LNAME}. To use the contact attributes here, these must already exist in SendinBlue account")
  public String getToField() {
    return toField;
  }

  public void setToField(String toField) {
    this.toField = toField;
  }

  public UpdateEmailCampaign recipients(UpdateEmailCampaignRecipients recipients) {
    this.recipients = recipients;
    return this;
  }

   /**
   * Get recipients
   * @return recipients
  **/
  @ApiModelProperty(value = "")
  public UpdateEmailCampaignRecipients getRecipients() {
    return recipients;
  }

  public void setRecipients(UpdateEmailCampaignRecipients recipients) {
    this.recipients = recipients;
  }

  public UpdateEmailCampaign attachmentUrl(String attachmentUrl) {
    this.attachmentUrl = attachmentUrl;
    return this;
  }

   /**
   * Absolute url of the attachment (no local file). Extension allowed: xlsx, xls, ods, docx, docm, doc, csv, pdf, txt, gif, jpg, jpeg, png, tif, tiff, rtf, bmp, cgm, css, shtml, html, htm, zip, xml, ppt, pptx, tar, ez, ics, mobi, msg, pub and eps
   * @return attachmentUrl
  **/
  @ApiModelProperty(example = "https://attachment.domain.com", value = "Absolute url of the attachment (no local file). Extension allowed: xlsx, xls, ods, docx, docm, doc, csv, pdf, txt, gif, jpg, jpeg, png, tif, tiff, rtf, bmp, cgm, css, shtml, html, htm, zip, xml, ppt, pptx, tar, ez, ics, mobi, msg, pub and eps")
  public String getAttachmentUrl() {
    return attachmentUrl;
  }

  public void setAttachmentUrl(String attachmentUrl) {
    this.attachmentUrl = attachmentUrl;
  }

  public UpdateEmailCampaign inlineImageActivation(Boolean inlineImageActivation) {
    this.inlineImageActivation = inlineImageActivation;
    return this;
  }

   /**
   * Status of inline image. inlineImageActivation &#x3D; false means image can’t be embedded, &amp; inlineImageActivation &#x3D; true means image can be embedded, in the email. You cannot send a campaign of more than 4MB with images embedded in the email. Campaigns with the images embedded in the email must be sent to less than 5000 contacts.
   * @return inlineImageActivation
  **/
  @ApiModelProperty(example = "true", value = "Status of inline image. inlineImageActivation = false means image can’t be embedded, & inlineImageActivation = true means image can be embedded, in the email. You cannot send a campaign of more than 4MB with images embedded in the email. Campaigns with the images embedded in the email must be sent to less than 5000 contacts.")
  public Boolean isInlineImageActivation() {
    return inlineImageActivation;
  }

  public void setInlineImageActivation(Boolean inlineImageActivation) {
    this.inlineImageActivation = inlineImageActivation;
  }

  public UpdateEmailCampaign mirrorActive(Boolean mirrorActive) {
    this.mirrorActive = mirrorActive;
    return this;
  }

   /**
   * Status of mirror links in campaign. mirrorActive &#x3D; false means mirror links are deactivated, &amp; mirrorActive &#x3D; true means mirror links are activated, in the campaign
   * @return mirrorActive
  **/
  @ApiModelProperty(example = "true", value = "Status of mirror links in campaign. mirrorActive = false means mirror links are deactivated, & mirrorActive = true means mirror links are activated, in the campaign")
  public Boolean isMirrorActive() {
    return mirrorActive;
  }

  public void setMirrorActive(Boolean mirrorActive) {
    this.mirrorActive = mirrorActive;
  }

  public UpdateEmailCampaign recurring(Boolean recurring) {
    this.recurring = recurring;
    return this;
  }

   /**
   * FOR TRIGGER ONLY ! Type of trigger campaign.recurring &#x3D; false means contact can receive the same Trigger campaign only once, &amp; recurring &#x3D; true means contact can receive the same Trigger campaign several times
   * @return recurring
  **/
  @ApiModelProperty(example = "false", value = "FOR TRIGGER ONLY ! Type of trigger campaign.recurring = false means contact can receive the same Trigger campaign only once, & recurring = true means contact can receive the same Trigger campaign several times")
  public Boolean isRecurring() {
    return recurring;
  }

  public void setRecurring(Boolean recurring) {
    this.recurring = recurring;
  }

  public UpdateEmailCampaign footer(String footer) {
    this.footer = footer;
    return this;
  }

   /**
   * Footer of the email campaign
   * @return footer
  **/
  @ApiModelProperty(example = "[DEFAULT_FOOTER]", value = "Footer of the email campaign")
  public String getFooter() {
    return footer;
  }

  public void setFooter(String footer) {
    this.footer = footer;
  }

  public UpdateEmailCampaign header(String header) {
    this.header = header;
    return this;
  }

   /**
   * Header of the email campaign
   * @return header
  **/
  @ApiModelProperty(example = "[DEFAULT_HEADER]", value = "Header of the email campaign")
  public String getHeader() {
    return header;
  }

  public void setHeader(String header) {
    this.header = header;
  }

  public UpdateEmailCampaign utmCampaign(String utmCampaign) {
    this.utmCampaign = utmCampaign;
    return this;
  }

   /**
   * Customize the utm_campaign value. If this field is empty, the campaign name will be used. Only alphanumeric characters and spaces are allowed
   * @return utmCampaign
  **/
  @ApiModelProperty(example = "NL_05_2017", value = "Customize the utm_campaign value. If this field is empty, the campaign name will be used. Only alphanumeric characters and spaces are allowed")
  public String getUtmCampaign() {
    return utmCampaign;
  }

  public void setUtmCampaign(String utmCampaign) {
    this.utmCampaign = utmCampaign;
  }


  @Override
  public boolean equals(java.lang.Object o) {
  if (this == o) {
    return true;
  }
  if (o == null || getClass() != o.getClass()) {
    return false;
  }
    UpdateEmailCampaign updateEmailCampaign = (UpdateEmailCampaign) o;
    return ObjectUtils.equals(this.tag, updateEmailCampaign.tag) &&
    ObjectUtils.equals(this.sender, updateEmailCampaign.sender) &&
    ObjectUtils.equals(this.name, updateEmailCampaign.name) &&
    ObjectUtils.equals(this.htmlContent, updateEmailCampaign.htmlContent) &&
    ObjectUtils.equals(this.htmlUrl, updateEmailCampaign.htmlUrl) &&
    ObjectUtils.equals(this.scheduledAt, updateEmailCampaign.scheduledAt) &&
    ObjectUtils.equals(this.subject, updateEmailCampaign.subject) &&
    ObjectUtils.equals(this.replyTo, updateEmailCampaign.replyTo) &&
    ObjectUtils.equals(this.toField, updateEmailCampaign.toField) &&
    ObjectUtils.equals(this.recipients, updateEmailCampaign.recipients) &&
    ObjectUtils.equals(this.attachmentUrl, updateEmailCampaign.attachmentUrl) &&
    ObjectUtils.equals(this.inlineImageActivation, updateEmailCampaign.inlineImageActivation) &&
    ObjectUtils.equals(this.mirrorActive, updateEmailCampaign.mirrorActive) &&
    ObjectUtils.equals(this.recurring, updateEmailCampaign.recurring) &&
    ObjectUtils.equals(this.footer, updateEmailCampaign.footer) &&
    ObjectUtils.equals(this.header, updateEmailCampaign.header) &&
    ObjectUtils.equals(this.utmCampaign, updateEmailCampaign.utmCampaign);
  }

  @Override
  public int hashCode() {
    return ObjectUtils.hashCodeMulti(tag, sender, name, htmlContent, htmlUrl, scheduledAt, subject, replyTo, toField, recipients, attachmentUrl, inlineImageActivation, mirrorActive, recurring, footer, header, utmCampaign);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UpdateEmailCampaign {\n");
    
    sb.append("    tag: ").append(toIndentedString(tag)).append("\n");
    sb.append("    sender: ").append(toIndentedString(sender)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    htmlContent: ").append(toIndentedString(htmlContent)).append("\n");
    sb.append("    htmlUrl: ").append(toIndentedString(htmlUrl)).append("\n");
    sb.append("    scheduledAt: ").append(toIndentedString(scheduledAt)).append("\n");
    sb.append("    subject: ").append(toIndentedString(subject)).append("\n");
    sb.append("    replyTo: ").append(toIndentedString(replyTo)).append("\n");
    sb.append("    toField: ").append(toIndentedString(toField)).append("\n");
    sb.append("    recipients: ").append(toIndentedString(recipients)).append("\n");
    sb.append("    attachmentUrl: ").append(toIndentedString(attachmentUrl)).append("\n");
    sb.append("    inlineImageActivation: ").append(toIndentedString(inlineImageActivation)).append("\n");
    sb.append("    mirrorActive: ").append(toIndentedString(mirrorActive)).append("\n");
    sb.append("    recurring: ").append(toIndentedString(recurring)).append("\n");
    sb.append("    footer: ").append(toIndentedString(footer)).append("\n");
    sb.append("    header: ").append(toIndentedString(header)).append("\n");
    sb.append("    utmCampaign: ").append(toIndentedString(utmCampaign)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

