/*
 * SendinBlue API
 * SendinBlue provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/sendinblue  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  | 
 *
 * OpenAPI spec version: 3.0.0
 * Contact: contact@sendinblue.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package sibModel;

import org.apache.commons.lang3.ObjectUtils;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import org.threeten.bp.OffsetDateTime;
import sibModel.CreateEmailCampaignRecipients;
import sibModel.CreateEmailCampaignSender;

/**
 * CreateEmailCampaign
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2018-05-24T12:07:09.251+05:30")
public class CreateEmailCampaign {
  @SerializedName("tag")
  private String tag = null;

  @SerializedName("sender")
  private CreateEmailCampaignSender sender = null;

  @SerializedName("name")
  private String name = null;

  @SerializedName("htmlContent")
  private String htmlContent = null;

  @SerializedName("htmlUrl")
  private String htmlUrl = null;

  @SerializedName("scheduledAt")
  private OffsetDateTime scheduledAt = null;

  @SerializedName("subject")
  private String subject = null;

  @SerializedName("replyTo")
  private String replyTo = null;

  @SerializedName("toField")
  private String toField = null;

  @SerializedName("recipients")
  private CreateEmailCampaignRecipients recipients = null;

  @SerializedName("attachmentUrl")
  private String attachmentUrl = null;

  @SerializedName("inlineImageActivation")
  private Boolean inlineImageActivation = false;

  @SerializedName("mirrorActive")
  private Boolean mirrorActive = null;

  @SerializedName("recurring")
  private Boolean recurring = false;

  /**
   * Type of the campaign
   */
  @JsonAdapter(TypeEnum.Adapter.class)
  public enum TypeEnum {
    CLASSIC("classic"),
    
    TRIGGER("trigger");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static TypeEnum fromValue(String text) {
      for (TypeEnum b : TypeEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<TypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final TypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public TypeEnum read(final JsonReader jsonReader) throws IOException {
        String value = jsonReader.nextString();
        return TypeEnum.fromValue(String.valueOf(value));
      }
    }
  }

  @SerializedName("type")
  private TypeEnum type = null;

  @SerializedName("footer")
  private String footer = null;

  @SerializedName("header")
  private String header = null;

  @SerializedName("utmCampaign")
  private String utmCampaign = null;

  public CreateEmailCampaign tag(String tag) {
    this.tag = tag;
    return this;
  }

   /**
   * Tag of the campaign
   * @return tag
  **/
  @ApiModelProperty(example = "Newsletter", value = "Tag of the campaign")
  public String getTag() {
    return tag;
  }

  public void setTag(String tag) {
    this.tag = tag;
  }

  public CreateEmailCampaign sender(CreateEmailCampaignSender sender) {
    this.sender = sender;
    return this;
  }

   /**
   * Get sender
   * @return sender
  **/
  @ApiModelProperty(required = true, value = "")
  public CreateEmailCampaignSender getSender() {
    return sender;
  }

  public void setSender(CreateEmailCampaignSender sender) {
    this.sender = sender;
  }

  public CreateEmailCampaign name(String name) {
    this.name = name;
    return this;
  }

   /**
   * Name of the campaign
   * @return name
  **/
  @ApiModelProperty(example = "Newsletter - May 2017", required = true, value = "Name of the campaign")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public CreateEmailCampaign htmlContent(String htmlContent) {
    this.htmlContent = htmlContent;
    return this;
  }

   /**
   * Mandatory if htmlUrl is empty. Body of the message (HTML)
   * @return htmlContent
  **/
  @ApiModelProperty(example = "Spring is here, discover my new collection", value = "Mandatory if htmlUrl is empty. Body of the message (HTML)")
  public String getHtmlContent() {
    return htmlContent;
  }

  public void setHtmlContent(String htmlContent) {
    this.htmlContent = htmlContent;
  }

  public CreateEmailCampaign htmlUrl(String htmlUrl) {
    this.htmlUrl = htmlUrl;
    return this;
  }

   /**
   * Mandatory if htmlContent is empty. Url to the message (HTML)
   * @return htmlUrl
  **/
  @ApiModelProperty(example = "https://html.domain.com", value = "Mandatory if htmlContent is empty. Url to the message (HTML)")
  public String getHtmlUrl() {
    return htmlUrl;
  }

  public void setHtmlUrl(String htmlUrl) {
    this.htmlUrl = htmlUrl;
  }

  public CreateEmailCampaign scheduledAt(OffsetDateTime scheduledAt) {
    this.scheduledAt = scheduledAt;
    return this;
  }

   /**
   * Sending UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ). Prefer to pass your timezone in date-time format for accurate result.
   * @return scheduledAt
  **/
  @ApiModelProperty(example = "2017-06-01T12:30:00+02:00", value = "Sending UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ). Prefer to pass your timezone in date-time format for accurate result.")
  public OffsetDateTime getScheduledAt() {
    return scheduledAt;
  }

  public void setScheduledAt(OffsetDateTime scheduledAt) {
    this.scheduledAt = scheduledAt;
  }

  public CreateEmailCampaign subject(String subject) {
    this.subject = subject;
    return this;
  }

   /**
   * Subject of the campaign
   * @return subject
  **/
  @ApiModelProperty(example = "Discover the New Collection !", required = true, value = "Subject of the campaign")
  public String getSubject() {
    return subject;
  }

  public void setSubject(String subject) {
    this.subject = subject;
  }

  public CreateEmailCampaign replyTo(String replyTo) {
    this.replyTo = replyTo;
    return this;
  }

   /**
   * Email on which the campaign recipients will be able to reply to
   * @return replyTo
  **/
  @ApiModelProperty(example = "support@myshop.com", value = "Email on which the campaign recipients will be able to reply to")
  public String getReplyTo() {
    return replyTo;
  }

  public void setReplyTo(String replyTo) {
    this.replyTo = replyTo;
  }

  public CreateEmailCampaign toField(String toField) {
    this.toField = toField;
    return this;
  }

   /**
   * To personalize the «To» Field, e.g. if you want to include the first name and last name of your recipient, use {FNAME} {LNAME}. These attributes must already exist in your contact database
   * @return toField
  **/
  @ApiModelProperty(example = "{FNAME} {LNAME}", value = "To personalize the «To» Field, e.g. if you want to include the first name and last name of your recipient, use {FNAME} {LNAME}. These attributes must already exist in your contact database")
  public String getToField() {
    return toField;
  }

  public void setToField(String toField) {
    this.toField = toField;
  }

  public CreateEmailCampaign recipients(CreateEmailCampaignRecipients recipients) {
    this.recipients = recipients;
    return this;
  }

   /**
   * Get recipients
   * @return recipients
  **/
  @ApiModelProperty(value = "")
  public CreateEmailCampaignRecipients getRecipients() {
    return recipients;
  }

  public void setRecipients(CreateEmailCampaignRecipients recipients) {
    this.recipients = recipients;
  }

  public CreateEmailCampaign attachmentUrl(String attachmentUrl) {
    this.attachmentUrl = attachmentUrl;
    return this;
  }

   /**
   * Absolute url of the attachment (no local file). Extension allowed: xlsx, xls, ods, docx, docm, doc, csv, pdf, txt, gif, jpg, jpeg, png, tif, tiff, rtf, bmp, cgm, css, shtml, html, htm, zip, xml, ppt, pptx, tar, ez, ics, mobi, msg, pub and eps
   * @return attachmentUrl
  **/
  @ApiModelProperty(example = "https://attachment.domain.com", value = "Absolute url of the attachment (no local file). Extension allowed: xlsx, xls, ods, docx, docm, doc, csv, pdf, txt, gif, jpg, jpeg, png, tif, tiff, rtf, bmp, cgm, css, shtml, html, htm, zip, xml, ppt, pptx, tar, ez, ics, mobi, msg, pub and eps")
  public String getAttachmentUrl() {
    return attachmentUrl;
  }

  public void setAttachmentUrl(String attachmentUrl) {
    this.attachmentUrl = attachmentUrl;
  }

  public CreateEmailCampaign inlineImageActivation(Boolean inlineImageActivation) {
    this.inlineImageActivation = inlineImageActivation;
    return this;
  }

   /**
   * Use true to embedded the images in your email. Final size of the email should be less than 4MB. Campaigns with embedded images can not be sent to more than 5000 contacts
   * @return inlineImageActivation
  **/
  @ApiModelProperty(example = "true", value = "Use true to embedded the images in your email. Final size of the email should be less than 4MB. Campaigns with embedded images can not be sent to more than 5000 contacts")
  public Boolean isInlineImageActivation() {
    return inlineImageActivation;
  }

  public void setInlineImageActivation(Boolean inlineImageActivation) {
    this.inlineImageActivation = inlineImageActivation;
  }

  public CreateEmailCampaign mirrorActive(Boolean mirrorActive) {
    this.mirrorActive = mirrorActive;
    return this;
  }

   /**
   * Use true to enable the mirror link
   * @return mirrorActive
  **/
  @ApiModelProperty(example = "true", value = "Use true to enable the mirror link")
  public Boolean isMirrorActive() {
    return mirrorActive;
  }

  public void setMirrorActive(Boolean mirrorActive) {
    this.mirrorActive = mirrorActive;
  }

  public CreateEmailCampaign recurring(Boolean recurring) {
    this.recurring = recurring;
    return this;
  }

   /**
   * For trigger campagins use false to make sure a contact receives the same campaign only once
   * @return recurring
  **/
  @ApiModelProperty(example = "false", value = "For trigger campagins use false to make sure a contact receives the same campaign only once")
  public Boolean isRecurring() {
    return recurring;
  }

  public void setRecurring(Boolean recurring) {
    this.recurring = recurring;
  }

  public CreateEmailCampaign type(TypeEnum type) {
    this.type = type;
    return this;
  }

   /**
   * Type of the campaign
   * @return type
  **/
  @ApiModelProperty(example = "classic", required = true, value = "Type of the campaign")
  public TypeEnum getType() {
    return type;
  }

  public void setType(TypeEnum type) {
    this.type = type;
  }

  public CreateEmailCampaign footer(String footer) {
    this.footer = footer;
    return this;
  }

   /**
   * Footer of the email campaign
   * @return footer
  **/
  @ApiModelProperty(example = "[DEFAULT_FOOTER]", value = "Footer of the email campaign")
  public String getFooter() {
    return footer;
  }

  public void setFooter(String footer) {
    this.footer = footer;
  }

  public CreateEmailCampaign header(String header) {
    this.header = header;
    return this;
  }

   /**
   * Header of the email campaign
   * @return header
  **/
  @ApiModelProperty(example = "[DEFAULT_HEADER]", value = "Header of the email campaign")
  public String getHeader() {
    return header;
  }

  public void setHeader(String header) {
    this.header = header;
  }

  public CreateEmailCampaign utmCampaign(String utmCampaign) {
    this.utmCampaign = utmCampaign;
    return this;
  }

   /**
   * Customize the utm_campaign value. If this field is empty, the campaign name will be used. Only alphanumeric characters and spaces are allowed
   * @return utmCampaign
  **/
  @ApiModelProperty(example = "NL_05_2017", value = "Customize the utm_campaign value. If this field is empty, the campaign name will be used. Only alphanumeric characters and spaces are allowed")
  public String getUtmCampaign() {
    return utmCampaign;
  }

  public void setUtmCampaign(String utmCampaign) {
    this.utmCampaign = utmCampaign;
  }


  @Override
  public boolean equals(java.lang.Object o) {
  if (this == o) {
    return true;
  }
  if (o == null || getClass() != o.getClass()) {
    return false;
  }
    CreateEmailCampaign createEmailCampaign = (CreateEmailCampaign) o;
    return ObjectUtils.equals(this.tag, createEmailCampaign.tag) &&
    ObjectUtils.equals(this.sender, createEmailCampaign.sender) &&
    ObjectUtils.equals(this.name, createEmailCampaign.name) &&
    ObjectUtils.equals(this.htmlContent, createEmailCampaign.htmlContent) &&
    ObjectUtils.equals(this.htmlUrl, createEmailCampaign.htmlUrl) &&
    ObjectUtils.equals(this.scheduledAt, createEmailCampaign.scheduledAt) &&
    ObjectUtils.equals(this.subject, createEmailCampaign.subject) &&
    ObjectUtils.equals(this.replyTo, createEmailCampaign.replyTo) &&
    ObjectUtils.equals(this.toField, createEmailCampaign.toField) &&
    ObjectUtils.equals(this.recipients, createEmailCampaign.recipients) &&
    ObjectUtils.equals(this.attachmentUrl, createEmailCampaign.attachmentUrl) &&
    ObjectUtils.equals(this.inlineImageActivation, createEmailCampaign.inlineImageActivation) &&
    ObjectUtils.equals(this.mirrorActive, createEmailCampaign.mirrorActive) &&
    ObjectUtils.equals(this.recurring, createEmailCampaign.recurring) &&
    ObjectUtils.equals(this.type, createEmailCampaign.type) &&
    ObjectUtils.equals(this.footer, createEmailCampaign.footer) &&
    ObjectUtils.equals(this.header, createEmailCampaign.header) &&
    ObjectUtils.equals(this.utmCampaign, createEmailCampaign.utmCampaign);
  }

  @Override
  public int hashCode() {
    return ObjectUtils.hashCodeMulti(tag, sender, name, htmlContent, htmlUrl, scheduledAt, subject, replyTo, toField, recipients, attachmentUrl, inlineImageActivation, mirrorActive, recurring, type, footer, header, utmCampaign);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateEmailCampaign {\n");
    
    sb.append("    tag: ").append(toIndentedString(tag)).append("\n");
    sb.append("    sender: ").append(toIndentedString(sender)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    htmlContent: ").append(toIndentedString(htmlContent)).append("\n");
    sb.append("    htmlUrl: ").append(toIndentedString(htmlUrl)).append("\n");
    sb.append("    scheduledAt: ").append(toIndentedString(scheduledAt)).append("\n");
    sb.append("    subject: ").append(toIndentedString(subject)).append("\n");
    sb.append("    replyTo: ").append(toIndentedString(replyTo)).append("\n");
    sb.append("    toField: ").append(toIndentedString(toField)).append("\n");
    sb.append("    recipients: ").append(toIndentedString(recipients)).append("\n");
    sb.append("    attachmentUrl: ").append(toIndentedString(attachmentUrl)).append("\n");
    sb.append("    inlineImageActivation: ").append(toIndentedString(inlineImageActivation)).append("\n");
    sb.append("    mirrorActive: ").append(toIndentedString(mirrorActive)).append("\n");
    sb.append("    recurring: ").append(toIndentedString(recurring)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    footer: ").append(toIndentedString(footer)).append("\n");
    sb.append("    header: ").append(toIndentedString(header)).append("\n");
    sb.append("    utmCampaign: ").append(toIndentedString(utmCampaign)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

