/*
 * SendinBlue API
 * SendinBlue provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/sendinblue  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  | 
 *
 * OpenAPI spec version: 3.0.0
 * Contact: contact@sendinblue.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package sibApi;

import sendinblue.ApiCallback;
import sendinblue.ApiClient;
import sendinblue.ApiException;
import sendinblue.ApiResponse;
import sendinblue.Configuration;
import sendinblue.Pair;
import sendinblue.ProgressRequestBody;
import sendinblue.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import sibModel.ErrorModel;
import sibModel.GetSmsEventReport;
import sibModel.GetTransacAggregatedSmsReport;
import sibModel.GetTransacSmsReport;
import org.threeten.bp.LocalDate;
import sibModel.SendSms;
import sibModel.SendTransacSms;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TransactionalSmsApi {
    private ApiClient apiClient;

    public TransactionalSmsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TransactionalSmsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for getSmsEvents
     * @param limit Number of documents per page (optional, default to 50)
     * @param startDate Mandatory if endDate is used. Starting date (YYYY-MM-DD) of the report (optional)
     * @param endDate Mandatory if startDate is used. Ending date (YYYY-MM-DD) of the report (optional)
     * @param offset Index of the first document of the page (optional, default to 0)
     * @param days Number of days in the past including today (positive integer). Not compatible with &#39;startDate&#39; and &#39;endDate&#39; (optional)
     * @param phoneNumber Filter the report for a specific phone number (optional)
     * @param event Filter the report for specific events (optional)
     * @param tags Filter the report for specific tags passed as a serialized urlencoded array (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getSmsEventsCall(Long limit, LocalDate startDate, LocalDate endDate, Long offset, Integer days, String phoneNumber, String event, String tags, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/transactionalSMS/statistics/events";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
        if (startDate != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("startDate", startDate));
        if (endDate != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("endDate", endDate));
        if (offset != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("offset", offset));
        if (days != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("days", days));
        if (phoneNumber != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("phoneNumber", phoneNumber));
        if (event != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("event", event));
        if (tags != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("tags", tags));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "api-key" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getSmsEventsValidateBeforeCall(Long limit, LocalDate startDate, LocalDate endDate, Long offset, Integer days, String phoneNumber, String event, String tags, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        

        com.squareup.okhttp.Call call = getSmsEventsCall(limit, startDate, endDate, offset, days, phoneNumber, event, tags, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get all the SMS activity (unaggregated events)
     * 
     * @param limit Number of documents per page (optional, default to 50)
     * @param startDate Mandatory if endDate is used. Starting date (YYYY-MM-DD) of the report (optional)
     * @param endDate Mandatory if startDate is used. Ending date (YYYY-MM-DD) of the report (optional)
     * @param offset Index of the first document of the page (optional, default to 0)
     * @param days Number of days in the past including today (positive integer). Not compatible with &#39;startDate&#39; and &#39;endDate&#39; (optional)
     * @param phoneNumber Filter the report for a specific phone number (optional)
     * @param event Filter the report for specific events (optional)
     * @param tags Filter the report for specific tags passed as a serialized urlencoded array (optional)
     * @return GetSmsEventReport
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public GetSmsEventReport getSmsEvents(Long limit, LocalDate startDate, LocalDate endDate, Long offset, Integer days, String phoneNumber, String event, String tags) throws ApiException {
        ApiResponse<GetSmsEventReport> resp = getSmsEventsWithHttpInfo(limit, startDate, endDate, offset, days, phoneNumber, event, tags);
        return resp.getData();
    }

    /**
     * Get all the SMS activity (unaggregated events)
     * 
     * @param limit Number of documents per page (optional, default to 50)
     * @param startDate Mandatory if endDate is used. Starting date (YYYY-MM-DD) of the report (optional)
     * @param endDate Mandatory if startDate is used. Ending date (YYYY-MM-DD) of the report (optional)
     * @param offset Index of the first document of the page (optional, default to 0)
     * @param days Number of days in the past including today (positive integer). Not compatible with &#39;startDate&#39; and &#39;endDate&#39; (optional)
     * @param phoneNumber Filter the report for a specific phone number (optional)
     * @param event Filter the report for specific events (optional)
     * @param tags Filter the report for specific tags passed as a serialized urlencoded array (optional)
     * @return ApiResponse&lt;GetSmsEventReport&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<GetSmsEventReport> getSmsEventsWithHttpInfo(Long limit, LocalDate startDate, LocalDate endDate, Long offset, Integer days, String phoneNumber, String event, String tags) throws ApiException {
        com.squareup.okhttp.Call call = getSmsEventsValidateBeforeCall(limit, startDate, endDate, offset, days, phoneNumber, event, tags, null, null);
        Type localVarReturnType = new TypeToken<GetSmsEventReport>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get all the SMS activity (unaggregated events) (asynchronously)
     * 
     * @param limit Number of documents per page (optional, default to 50)
     * @param startDate Mandatory if endDate is used. Starting date (YYYY-MM-DD) of the report (optional)
     * @param endDate Mandatory if startDate is used. Ending date (YYYY-MM-DD) of the report (optional)
     * @param offset Index of the first document of the page (optional, default to 0)
     * @param days Number of days in the past including today (positive integer). Not compatible with &#39;startDate&#39; and &#39;endDate&#39; (optional)
     * @param phoneNumber Filter the report for a specific phone number (optional)
     * @param event Filter the report for specific events (optional)
     * @param tags Filter the report for specific tags passed as a serialized urlencoded array (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getSmsEventsAsync(Long limit, LocalDate startDate, LocalDate endDate, Long offset, Integer days, String phoneNumber, String event, String tags, final ApiCallback<GetSmsEventReport> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getSmsEventsValidateBeforeCall(limit, startDate, endDate, offset, days, phoneNumber, event, tags, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetSmsEventReport>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getTransacAggregatedSmsReport
     * @param startDate Mandatory if endDate is used. Starting date (YYYY-MM-DD) of the report (optional)
     * @param endDate Mandatory if startDate is used. Ending date (YYYY-MM-DD) of the report (optional)
     * @param days Number of days in the past including today (positive integer). Not compatible with startDate and endDate (optional)
     * @param tag Filter on a tag (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getTransacAggregatedSmsReportCall(LocalDate startDate, LocalDate endDate, Integer days, String tag, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/transactionalSMS/statistics/aggregatedReport";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (startDate != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("startDate", startDate));
        if (endDate != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("endDate", endDate));
        if (days != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("days", days));
        if (tag != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("tag", tag));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "api-key" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getTransacAggregatedSmsReportValidateBeforeCall(LocalDate startDate, LocalDate endDate, Integer days, String tag, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        

        com.squareup.okhttp.Call call = getTransacAggregatedSmsReportCall(startDate, endDate, days, tag, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get your SMS activity aggregated over a period of time
     * 
     * @param startDate Mandatory if endDate is used. Starting date (YYYY-MM-DD) of the report (optional)
     * @param endDate Mandatory if startDate is used. Ending date (YYYY-MM-DD) of the report (optional)
     * @param days Number of days in the past including today (positive integer). Not compatible with startDate and endDate (optional)
     * @param tag Filter on a tag (optional)
     * @return GetTransacAggregatedSmsReport
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public GetTransacAggregatedSmsReport getTransacAggregatedSmsReport(LocalDate startDate, LocalDate endDate, Integer days, String tag) throws ApiException {
        ApiResponse<GetTransacAggregatedSmsReport> resp = getTransacAggregatedSmsReportWithHttpInfo(startDate, endDate, days, tag);
        return resp.getData();
    }

    /**
     * Get your SMS activity aggregated over a period of time
     * 
     * @param startDate Mandatory if endDate is used. Starting date (YYYY-MM-DD) of the report (optional)
     * @param endDate Mandatory if startDate is used. Ending date (YYYY-MM-DD) of the report (optional)
     * @param days Number of days in the past including today (positive integer). Not compatible with startDate and endDate (optional)
     * @param tag Filter on a tag (optional)
     * @return ApiResponse&lt;GetTransacAggregatedSmsReport&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<GetTransacAggregatedSmsReport> getTransacAggregatedSmsReportWithHttpInfo(LocalDate startDate, LocalDate endDate, Integer days, String tag) throws ApiException {
        com.squareup.okhttp.Call call = getTransacAggregatedSmsReportValidateBeforeCall(startDate, endDate, days, tag, null, null);
        Type localVarReturnType = new TypeToken<GetTransacAggregatedSmsReport>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get your SMS activity aggregated over a period of time (asynchronously)
     * 
     * @param startDate Mandatory if endDate is used. Starting date (YYYY-MM-DD) of the report (optional)
     * @param endDate Mandatory if startDate is used. Ending date (YYYY-MM-DD) of the report (optional)
     * @param days Number of days in the past including today (positive integer). Not compatible with startDate and endDate (optional)
     * @param tag Filter on a tag (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getTransacAggregatedSmsReportAsync(LocalDate startDate, LocalDate endDate, Integer days, String tag, final ApiCallback<GetTransacAggregatedSmsReport> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getTransacAggregatedSmsReportValidateBeforeCall(startDate, endDate, days, tag, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetTransacAggregatedSmsReport>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getTransacSmsReport
     * @param startDate Mandatory if endDate is used. Starting date (YYYY-MM-DD) of the report (optional)
     * @param endDate Mandatory if startDate is used. Ending date (YYYY-MM-DD) of the report (optional)
     * @param days Number of days in the past including today (positive integer). Not compatible with &#39;startDate&#39; and &#39;endDate&#39; (optional)
     * @param tag Filter on a tag (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getTransacSmsReportCall(LocalDate startDate, LocalDate endDate, Integer days, String tag, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/transactionalSMS/statistics/reports";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (startDate != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("startDate", startDate));
        if (endDate != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("endDate", endDate));
        if (days != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("days", days));
        if (tag != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("tag", tag));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "api-key" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getTransacSmsReportValidateBeforeCall(LocalDate startDate, LocalDate endDate, Integer days, String tag, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        

        com.squareup.okhttp.Call call = getTransacSmsReportCall(startDate, endDate, days, tag, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get your SMS activity aggregated per day
     * 
     * @param startDate Mandatory if endDate is used. Starting date (YYYY-MM-DD) of the report (optional)
     * @param endDate Mandatory if startDate is used. Ending date (YYYY-MM-DD) of the report (optional)
     * @param days Number of days in the past including today (positive integer). Not compatible with &#39;startDate&#39; and &#39;endDate&#39; (optional)
     * @param tag Filter on a tag (optional)
     * @return GetTransacSmsReport
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public GetTransacSmsReport getTransacSmsReport(LocalDate startDate, LocalDate endDate, Integer days, String tag) throws ApiException {
        ApiResponse<GetTransacSmsReport> resp = getTransacSmsReportWithHttpInfo(startDate, endDate, days, tag);
        return resp.getData();
    }

    /**
     * Get your SMS activity aggregated per day
     * 
     * @param startDate Mandatory if endDate is used. Starting date (YYYY-MM-DD) of the report (optional)
     * @param endDate Mandatory if startDate is used. Ending date (YYYY-MM-DD) of the report (optional)
     * @param days Number of days in the past including today (positive integer). Not compatible with &#39;startDate&#39; and &#39;endDate&#39; (optional)
     * @param tag Filter on a tag (optional)
     * @return ApiResponse&lt;GetTransacSmsReport&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<GetTransacSmsReport> getTransacSmsReportWithHttpInfo(LocalDate startDate, LocalDate endDate, Integer days, String tag) throws ApiException {
        com.squareup.okhttp.Call call = getTransacSmsReportValidateBeforeCall(startDate, endDate, days, tag, null, null);
        Type localVarReturnType = new TypeToken<GetTransacSmsReport>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get your SMS activity aggregated per day (asynchronously)
     * 
     * @param startDate Mandatory if endDate is used. Starting date (YYYY-MM-DD) of the report (optional)
     * @param endDate Mandatory if startDate is used. Ending date (YYYY-MM-DD) of the report (optional)
     * @param days Number of days in the past including today (positive integer). Not compatible with &#39;startDate&#39; and &#39;endDate&#39; (optional)
     * @param tag Filter on a tag (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getTransacSmsReportAsync(LocalDate startDate, LocalDate endDate, Integer days, String tag, final ApiCallback<GetTransacSmsReport> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getTransacSmsReportValidateBeforeCall(startDate, endDate, days, tag, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetTransacSmsReport>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for sendTransacSms
     * @param sendTransacSms Values to send a transactional SMS (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call sendTransacSmsCall(SendTransacSms sendTransacSms, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = sendTransacSms;

        // create path and map variables
        String localVarPath = "/transactionalSMS/sms";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "api-key" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call sendTransacSmsValidateBeforeCall(SendTransacSms sendTransacSms, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'sendTransacSms' is set
        if (sendTransacSms == null) {
            throw new ApiException("Missing the required parameter 'sendTransacSms' when calling sendTransacSms(Async)");
        }
        

        com.squareup.okhttp.Call call = sendTransacSmsCall(sendTransacSms, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Send the SMS campaign to the specified mobile number
     * 
     * @param sendTransacSms Values to send a transactional SMS (required)
     * @return SendSms
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public SendSms sendTransacSms(SendTransacSms sendTransacSms) throws ApiException {
        ApiResponse<SendSms> resp = sendTransacSmsWithHttpInfo(sendTransacSms);
        return resp.getData();
    }

    /**
     * Send the SMS campaign to the specified mobile number
     * 
     * @param sendTransacSms Values to send a transactional SMS (required)
     * @return ApiResponse&lt;SendSms&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<SendSms> sendTransacSmsWithHttpInfo(SendTransacSms sendTransacSms) throws ApiException {
        com.squareup.okhttp.Call call = sendTransacSmsValidateBeforeCall(sendTransacSms, null, null);
        Type localVarReturnType = new TypeToken<SendSms>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Send the SMS campaign to the specified mobile number (asynchronously)
     * 
     * @param sendTransacSms Values to send a transactional SMS (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call sendTransacSmsAsync(SendTransacSms sendTransacSms, final ApiCallback<SendSms> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = sendTransacSmsValidateBeforeCall(sendTransacSms, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SendSms>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}
