/*
 * SendinBlue API
 * SendinBlue provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/sendinblue  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  | 
 *
 * OpenAPI spec version: 3.0.0
 * Contact: contact@sendinblue.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package sibApi;

import sendinblue.ApiCallback;
import sendinblue.ApiClient;
import sendinblue.ApiException;
import sendinblue.ApiResponse;
import sendinblue.Configuration;
import sendinblue.Pair;
import sendinblue.ProgressRequestBody;
import sendinblue.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import sibModel.AddCredits;
import sibModel.CreateChild;
import sibModel.CreateReseller;
import sibModel.ErrorModel;
import sibModel.GetChildInfo;
import sibModel.GetChildrenList;
import sibModel.ManageIp;
import sibModel.RemainingCreditModel;
import sibModel.RemoveCredits;
import sibModel.UpdateChild;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResellerApi {
    private ApiClient apiClient;

    public ResellerApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ResellerApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for addCredits
     * @param childAuthKey auth key of reseller&#39;s child (required)
     * @param addCredits Values to post to add credit to a specific child account (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call addCreditsCall(String childAuthKey, AddCredits addCredits, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = addCredits;

        // create path and map variables
        String localVarPath = "/reseller/children/{childAuthKey}/credits/add"
            .replaceAll("\\{" + "childAuthKey" + "\\}", apiClient.escapeString(childAuthKey.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "api-key" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call addCreditsValidateBeforeCall(String childAuthKey, AddCredits addCredits, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'childAuthKey' is set
        if (childAuthKey == null) {
            throw new ApiException("Missing the required parameter 'childAuthKey' when calling addCredits(Async)");
        }
        
        // verify the required parameter 'addCredits' is set
        if (addCredits == null) {
            throw new ApiException("Missing the required parameter 'addCredits' when calling addCredits(Async)");
        }
        

        com.squareup.okhttp.Call call = addCreditsCall(childAuthKey, addCredits, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Add Email and/or SMS credits to a specific child account
     * 
     * @param childAuthKey auth key of reseller&#39;s child (required)
     * @param addCredits Values to post to add credit to a specific child account (required)
     * @return RemainingCreditModel
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public RemainingCreditModel addCredits(String childAuthKey, AddCredits addCredits) throws ApiException {
        ApiResponse<RemainingCreditModel> resp = addCreditsWithHttpInfo(childAuthKey, addCredits);
        return resp.getData();
    }

    /**
     * Add Email and/or SMS credits to a specific child account
     * 
     * @param childAuthKey auth key of reseller&#39;s child (required)
     * @param addCredits Values to post to add credit to a specific child account (required)
     * @return ApiResponse&lt;RemainingCreditModel&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<RemainingCreditModel> addCreditsWithHttpInfo(String childAuthKey, AddCredits addCredits) throws ApiException {
        com.squareup.okhttp.Call call = addCreditsValidateBeforeCall(childAuthKey, addCredits, null, null);
        Type localVarReturnType = new TypeToken<RemainingCreditModel>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Add Email and/or SMS credits to a specific child account (asynchronously)
     * 
     * @param childAuthKey auth key of reseller&#39;s child (required)
     * @param addCredits Values to post to add credit to a specific child account (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call addCreditsAsync(String childAuthKey, AddCredits addCredits, final ApiCallback<RemainingCreditModel> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = addCreditsValidateBeforeCall(childAuthKey, addCredits, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<RemainingCreditModel>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for associateIpToChild
     * @param childAuthKey auth key of reseller&#39;s child (required)
     * @param ip IP to associate (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call associateIpToChildCall(String childAuthKey, ManageIp ip, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = ip;

        // create path and map variables
        String localVarPath = "/reseller/children/{childAuthKey}/ips/associate"
            .replaceAll("\\{" + "childAuthKey" + "\\}", apiClient.escapeString(childAuthKey.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "api-key" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call associateIpToChildValidateBeforeCall(String childAuthKey, ManageIp ip, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'childAuthKey' is set
        if (childAuthKey == null) {
            throw new ApiException("Missing the required parameter 'childAuthKey' when calling associateIpToChild(Async)");
        }
        
        // verify the required parameter 'ip' is set
        if (ip == null) {
            throw new ApiException("Missing the required parameter 'ip' when calling associateIpToChild(Async)");
        }
        

        com.squareup.okhttp.Call call = associateIpToChildCall(childAuthKey, ip, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Associate a dedicated IP to the child
     * 
     * @param childAuthKey auth key of reseller&#39;s child (required)
     * @param ip IP to associate (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void associateIpToChild(String childAuthKey, ManageIp ip) throws ApiException {
        associateIpToChildWithHttpInfo(childAuthKey, ip);
    }

    /**
     * Associate a dedicated IP to the child
     * 
     * @param childAuthKey auth key of reseller&#39;s child (required)
     * @param ip IP to associate (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> associateIpToChildWithHttpInfo(String childAuthKey, ManageIp ip) throws ApiException {
        com.squareup.okhttp.Call call = associateIpToChildValidateBeforeCall(childAuthKey, ip, null, null);
        return apiClient.execute(call);
    }

    /**
     * Associate a dedicated IP to the child (asynchronously)
     * 
     * @param childAuthKey auth key of reseller&#39;s child (required)
     * @param ip IP to associate (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call associateIpToChildAsync(String childAuthKey, ManageIp ip, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = associateIpToChildValidateBeforeCall(childAuthKey, ip, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for createResellerChild
     * @param resellerChild reseller child to add (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call createResellerChildCall(CreateChild resellerChild, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = resellerChild;

        // create path and map variables
        String localVarPath = "/reseller/children";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "api-key" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call createResellerChildValidateBeforeCall(CreateChild resellerChild, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        

        com.squareup.okhttp.Call call = createResellerChildCall(resellerChild, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Creates a reseller child
     * 
     * @param resellerChild reseller child to add (optional)
     * @return CreateReseller
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CreateReseller createResellerChild(CreateChild resellerChild) throws ApiException {
        ApiResponse<CreateReseller> resp = createResellerChildWithHttpInfo(resellerChild);
        return resp.getData();
    }

    /**
     * Creates a reseller child
     * 
     * @param resellerChild reseller child to add (optional)
     * @return ApiResponse&lt;CreateReseller&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CreateReseller> createResellerChildWithHttpInfo(CreateChild resellerChild) throws ApiException {
        com.squareup.okhttp.Call call = createResellerChildValidateBeforeCall(resellerChild, null, null);
        Type localVarReturnType = new TypeToken<CreateReseller>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Creates a reseller child (asynchronously)
     * 
     * @param resellerChild reseller child to add (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call createResellerChildAsync(CreateChild resellerChild, final ApiCallback<CreateReseller> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = createResellerChildValidateBeforeCall(resellerChild, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CreateReseller>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for deleteResellerChild
     * @param childAuthKey auth key of reseller&#39;s child (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteResellerChildCall(String childAuthKey, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/reseller/children/{childAuthKey}"
            .replaceAll("\\{" + "childAuthKey" + "\\}", apiClient.escapeString(childAuthKey.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "api-key" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteResellerChildValidateBeforeCall(String childAuthKey, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'childAuthKey' is set
        if (childAuthKey == null) {
            throw new ApiException("Missing the required parameter 'childAuthKey' when calling deleteResellerChild(Async)");
        }
        

        com.squareup.okhttp.Call call = deleteResellerChildCall(childAuthKey, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Deletes a single reseller child based on the childAuthKey supplied
     * 
     * @param childAuthKey auth key of reseller&#39;s child (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void deleteResellerChild(String childAuthKey) throws ApiException {
        deleteResellerChildWithHttpInfo(childAuthKey);
    }

    /**
     * Deletes a single reseller child based on the childAuthKey supplied
     * 
     * @param childAuthKey auth key of reseller&#39;s child (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> deleteResellerChildWithHttpInfo(String childAuthKey) throws ApiException {
        com.squareup.okhttp.Call call = deleteResellerChildValidateBeforeCall(childAuthKey, null, null);
        return apiClient.execute(call);
    }

    /**
     * Deletes a single reseller child based on the childAuthKey supplied (asynchronously)
     * 
     * @param childAuthKey auth key of reseller&#39;s child (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deleteResellerChildAsync(String childAuthKey, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteResellerChildValidateBeforeCall(childAuthKey, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for dissociateIpFromChild
     * @param childAuthKey auth key of reseller&#39;s child (required)
     * @param ip IP to dissociate (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call dissociateIpFromChildCall(String childAuthKey, ManageIp ip, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = ip;

        // create path and map variables
        String localVarPath = "/reseller/children/{childAuthKey}/ips/dissociate"
            .replaceAll("\\{" + "childAuthKey" + "\\}", apiClient.escapeString(childAuthKey.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "api-key" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call dissociateIpFromChildValidateBeforeCall(String childAuthKey, ManageIp ip, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'childAuthKey' is set
        if (childAuthKey == null) {
            throw new ApiException("Missing the required parameter 'childAuthKey' when calling dissociateIpFromChild(Async)");
        }
        
        // verify the required parameter 'ip' is set
        if (ip == null) {
            throw new ApiException("Missing the required parameter 'ip' when calling dissociateIpFromChild(Async)");
        }
        

        com.squareup.okhttp.Call call = dissociateIpFromChildCall(childAuthKey, ip, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Dissociate a dedicated IP to the child
     * 
     * @param childAuthKey auth key of reseller&#39;s child (required)
     * @param ip IP to dissociate (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void dissociateIpFromChild(String childAuthKey, ManageIp ip) throws ApiException {
        dissociateIpFromChildWithHttpInfo(childAuthKey, ip);
    }

    /**
     * Dissociate a dedicated IP to the child
     * 
     * @param childAuthKey auth key of reseller&#39;s child (required)
     * @param ip IP to dissociate (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> dissociateIpFromChildWithHttpInfo(String childAuthKey, ManageIp ip) throws ApiException {
        com.squareup.okhttp.Call call = dissociateIpFromChildValidateBeforeCall(childAuthKey, ip, null, null);
        return apiClient.execute(call);
    }

    /**
     * Dissociate a dedicated IP to the child (asynchronously)
     * 
     * @param childAuthKey auth key of reseller&#39;s child (required)
     * @param ip IP to dissociate (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call dissociateIpFromChildAsync(String childAuthKey, ManageIp ip, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = dissociateIpFromChildValidateBeforeCall(childAuthKey, ip, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for getChildInfo
     * @param childAuthKey auth key of reseller&#39;s child (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getChildInfoCall(String childAuthKey, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/reseller/children/{childAuthKey}"
            .replaceAll("\\{" + "childAuthKey" + "\\}", apiClient.escapeString(childAuthKey.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "api-key" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getChildInfoValidateBeforeCall(String childAuthKey, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'childAuthKey' is set
        if (childAuthKey == null) {
            throw new ApiException("Missing the required parameter 'childAuthKey' when calling getChildInfo(Async)");
        }
        

        com.squareup.okhttp.Call call = getChildInfoCall(childAuthKey, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Gets the info about a specific child account
     * 
     * @param childAuthKey auth key of reseller&#39;s child (required)
     * @return GetChildInfo
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public GetChildInfo getChildInfo(String childAuthKey) throws ApiException {
        ApiResponse<GetChildInfo> resp = getChildInfoWithHttpInfo(childAuthKey);
        return resp.getData();
    }

    /**
     * Gets the info about a specific child account
     * 
     * @param childAuthKey auth key of reseller&#39;s child (required)
     * @return ApiResponse&lt;GetChildInfo&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<GetChildInfo> getChildInfoWithHttpInfo(String childAuthKey) throws ApiException {
        com.squareup.okhttp.Call call = getChildInfoValidateBeforeCall(childAuthKey, null, null);
        Type localVarReturnType = new TypeToken<GetChildInfo>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Gets the info about a specific child account (asynchronously)
     * 
     * @param childAuthKey auth key of reseller&#39;s child (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getChildInfoAsync(String childAuthKey, final ApiCallback<GetChildInfo> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getChildInfoValidateBeforeCall(childAuthKey, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetChildInfo>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getResellerChilds
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getResellerChildsCall(final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/reseller/children";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "api-key" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getResellerChildsValidateBeforeCall(final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        

        com.squareup.okhttp.Call call = getResellerChildsCall(progressListener, progressRequestListener);
        return call;

    }

    /**
     * Gets the list of all reseller&#39;s children accounts
     * 
     * @return GetChildrenList
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public GetChildrenList getResellerChilds() throws ApiException {
        ApiResponse<GetChildrenList> resp = getResellerChildsWithHttpInfo();
        return resp.getData();
    }

    /**
     * Gets the list of all reseller&#39;s children accounts
     * 
     * @return ApiResponse&lt;GetChildrenList&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<GetChildrenList> getResellerChildsWithHttpInfo() throws ApiException {
        com.squareup.okhttp.Call call = getResellerChildsValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<GetChildrenList>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Gets the list of all reseller&#39;s children accounts (asynchronously)
     * 
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getResellerChildsAsync(final ApiCallback<GetChildrenList> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getResellerChildsValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetChildrenList>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for removeCredits
     * @param childAuthKey auth key of reseller&#39;s child (required)
     * @param removeCredits Values to post to remove email or SMS credits from a specific child account (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call removeCreditsCall(String childAuthKey, RemoveCredits removeCredits, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = removeCredits;

        // create path and map variables
        String localVarPath = "/reseller/children/{childAuthKey}/credits/remove"
            .replaceAll("\\{" + "childAuthKey" + "\\}", apiClient.escapeString(childAuthKey.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "api-key" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call removeCreditsValidateBeforeCall(String childAuthKey, RemoveCredits removeCredits, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'childAuthKey' is set
        if (childAuthKey == null) {
            throw new ApiException("Missing the required parameter 'childAuthKey' when calling removeCredits(Async)");
        }
        
        // verify the required parameter 'removeCredits' is set
        if (removeCredits == null) {
            throw new ApiException("Missing the required parameter 'removeCredits' when calling removeCredits(Async)");
        }
        

        com.squareup.okhttp.Call call = removeCreditsCall(childAuthKey, removeCredits, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Remove Email and/or SMS credits from a specific child account
     * 
     * @param childAuthKey auth key of reseller&#39;s child (required)
     * @param removeCredits Values to post to remove email or SMS credits from a specific child account (required)
     * @return RemainingCreditModel
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public RemainingCreditModel removeCredits(String childAuthKey, RemoveCredits removeCredits) throws ApiException {
        ApiResponse<RemainingCreditModel> resp = removeCreditsWithHttpInfo(childAuthKey, removeCredits);
        return resp.getData();
    }

    /**
     * Remove Email and/or SMS credits from a specific child account
     * 
     * @param childAuthKey auth key of reseller&#39;s child (required)
     * @param removeCredits Values to post to remove email or SMS credits from a specific child account (required)
     * @return ApiResponse&lt;RemainingCreditModel&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<RemainingCreditModel> removeCreditsWithHttpInfo(String childAuthKey, RemoveCredits removeCredits) throws ApiException {
        com.squareup.okhttp.Call call = removeCreditsValidateBeforeCall(childAuthKey, removeCredits, null, null);
        Type localVarReturnType = new TypeToken<RemainingCreditModel>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Remove Email and/or SMS credits from a specific child account (asynchronously)
     * 
     * @param childAuthKey auth key of reseller&#39;s child (required)
     * @param removeCredits Values to post to remove email or SMS credits from a specific child account (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call removeCreditsAsync(String childAuthKey, RemoveCredits removeCredits, final ApiCallback<RemainingCreditModel> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = removeCreditsValidateBeforeCall(childAuthKey, removeCredits, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<RemainingCreditModel>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for updateResellerChild
     * @param childAuthKey auth key of reseller&#39;s child (required)
     * @param resellerChild values to update in child profile (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call updateResellerChildCall(String childAuthKey, UpdateChild resellerChild, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = resellerChild;

        // create path and map variables
        String localVarPath = "/reseller/children/{childAuthKey}"
            .replaceAll("\\{" + "childAuthKey" + "\\}", apiClient.escapeString(childAuthKey.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "api-key" };
        return apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call updateResellerChildValidateBeforeCall(String childAuthKey, UpdateChild resellerChild, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'childAuthKey' is set
        if (childAuthKey == null) {
            throw new ApiException("Missing the required parameter 'childAuthKey' when calling updateResellerChild(Async)");
        }
        
        // verify the required parameter 'resellerChild' is set
        if (resellerChild == null) {
            throw new ApiException("Missing the required parameter 'resellerChild' when calling updateResellerChild(Async)");
        }
        

        com.squareup.okhttp.Call call = updateResellerChildCall(childAuthKey, resellerChild, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Updates infos of reseller&#39;s child based on the childAuthKey supplied
     * 
     * @param childAuthKey auth key of reseller&#39;s child (required)
     * @param resellerChild values to update in child profile (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void updateResellerChild(String childAuthKey, UpdateChild resellerChild) throws ApiException {
        updateResellerChildWithHttpInfo(childAuthKey, resellerChild);
    }

    /**
     * Updates infos of reseller&#39;s child based on the childAuthKey supplied
     * 
     * @param childAuthKey auth key of reseller&#39;s child (required)
     * @param resellerChild values to update in child profile (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> updateResellerChildWithHttpInfo(String childAuthKey, UpdateChild resellerChild) throws ApiException {
        com.squareup.okhttp.Call call = updateResellerChildValidateBeforeCall(childAuthKey, resellerChild, null, null);
        return apiClient.execute(call);
    }

    /**
     * Updates infos of reseller&#39;s child based on the childAuthKey supplied (asynchronously)
     * 
     * @param childAuthKey auth key of reseller&#39;s child (required)
     * @param resellerChild values to update in child profile (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call updateResellerChildAsync(String childAuthKey, UpdateChild resellerChild, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = updateResellerChildValidateBeforeCall(childAuthKey, resellerChild, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
}
