/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.webhooks;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.webhooks.models.EventWebhookNoDatesResponse;
import com.sendgrid.rest.api.v3.webhooks.models.GetSignedEventWebhook404Response;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;

public class GetEventWebhook
extends ApiKeyBase {
    private final String id;
    private String include;
    private String onBehalfOf;

    @Override
    public ApiResponse<EventWebhookNoDatesResponse> send(ApiKeyRestClient client) {
        String path = "/v3/user/webhooks/event/settings/{id}";
        Request request = new Request(HttpMethod.GET, path, Domains.API.toString());
        this.addPathParams(request);
        this.addQueryParams(request);
        this.addHeaderParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("GetEventWebhook creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "404")) {
                GetSignedEventWebhook404Response error = JsonUtil.fromJson(response.getStream(), GetSignedEventWebhook404Response.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<EventWebhookNoDatesResponse>(statusCode, JsonUtil.fromJson(response.getStream(), EventWebhookNoDatesResponse.class), response.getHeaders());
    }

    private void addPathParams(Request request) {
        if (this.id != null) {
            request.addPathParam("id", this.id.toString());
        }
    }

    private void addHeaderParams(Request request) {
        if (this.onBehalfOf != null) {
            request.addHeaderParam("on-behalf-of", this.onBehalfOf.toString());
        }
    }

    private void addQueryParams(Request request) {
        if (this.include != null) {
            request.addQueryParam("include", this.include.toString());
        }
    }

    public GetEventWebhook(String id) {
        this.id = id;
    }

    public void setInclude(String include) {
        this.include = include;
    }

    public void setOnBehalfOf(String onBehalfOf) {
        this.onBehalfOf = onBehalfOf;
    }
}

