/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.verifiedsenders;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.verifiedsenders.models.DeleteVerifiedSender404Response;
import com.sendgrid.rest.api.v3.verifiedsenders.models.ErrorResponse;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;

public class VerifySenderToken
extends ApiKeyBase {
    private final String token;

    @Override
    public ApiResponse<Void> send(ApiKeyRestClient client) {
        String path = "/v3/verified_senders/verify/{token}";
        Request request = new Request(HttpMethod.GET, path, Domains.API.toString());
        this.addPathParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("VerifySenderToken creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "401")) {
                ErrorResponse error = JsonUtil.fromJson(response.getStream(), ErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "403")) {
                ErrorResponse error = JsonUtil.fromJson(response.getStream(), ErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "404")) {
                DeleteVerifiedSender404Response error = JsonUtil.fromJson(response.getStream(), DeleteVerifiedSender404Response.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "500")) {
                Object error = JsonUtil.fromJson(response.getStream(), Object.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<Void>(statusCode, response.getHeaders());
    }

    private void addPathParams(Request request) {
        if (this.token != null) {
            request.addPathParam("token", this.token.toString());
        }
    }

    public VerifySenderToken(String token) {
        this.token = token;
    }
}

