/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.trackingsettings;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.trackingsettings.models.SubscriptionTrackingSettings;
import com.sendgrid.util.JsonUtil;

public class UpdateSubscriptionTrackingSetting
extends ApiKeyBase {
    private String onBehalfOf;
    private SubscriptionTrackingSettings subscriptionTrackingSettings;

    @Override
    public ApiResponse<SubscriptionTrackingSettings> send(ApiKeyRestClient client) {
        String path = "/v3/tracking_settings/subscription";
        Request request = new Request(HttpMethod.PATCH, path, Domains.API.toString());
        this.addHeaderParams(request);
        this.addBody(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("UpdateSubscriptionTrackingSetting creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<SubscriptionTrackingSettings>(statusCode, JsonUtil.fromJson(response.getStream(), SubscriptionTrackingSettings.class), response.getHeaders());
    }

    private void addHeaderParams(Request request) {
        if (this.onBehalfOf != null) {
            request.addHeaderParam("on-behalf-of", this.onBehalfOf.toString());
        }
    }

    private void addBody(Request request) {
        if (this.subscriptionTrackingSettings != null) {
            request.addBody(JsonUtil.toJson(this.subscriptionTrackingSettings));
        }
    }

    public void setOnBehalfOf(String onBehalfOf) {
        this.onBehalfOf = onBehalfOf;
    }

    public void setSubscriptionTrackingSettings(SubscriptionTrackingSettings subscriptionTrackingSettings) {
        this.subscriptionTrackingSettings = subscriptionTrackingSettings;
    }
}

