/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.suppressions;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.suppressions.models.Accept1;
import com.sendgrid.rest.api.v3.suppressions.models.Classification1;
import com.sendgrid.rest.api.v3.suppressions.models.GetSuppressionBouncesClassifications200Response;
import com.sendgrid.util.JsonUtil;

public class GetSuppressionBouncesClassifications
extends ApiKeyBase {
    private final Classification1 classification;
    private String startDate;
    private String endDate;
    private final Accept1 accept;
    private String onBehalfOf;

    @Override
    public ApiResponse<GetSuppressionBouncesClassifications200Response> send(ApiKeyRestClient client) {
        String path = "/v3/suppression/bounces/classifications/{classification}";
        Request request = new Request(HttpMethod.GET, path, Domains.API.toString());
        this.addPathParams(request);
        this.addQueryParams(request);
        this.addHeaderParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("GetSuppressionBouncesClassifications creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<GetSuppressionBouncesClassifications200Response>(statusCode, JsonUtil.fromJson(response.getStream(), GetSuppressionBouncesClassifications200Response.class), response.getHeaders());
    }

    private void addPathParams(Request request) {
        if (this.classification != null) {
            request.addPathParam("classification", this.classification.toString());
        }
    }

    private void addHeaderParams(Request request) {
        if (this.accept != null) {
            request.addHeaderParam("Accept", this.accept.toString());
        }
        if (this.onBehalfOf != null) {
            request.addHeaderParam("on-behalf-of", this.onBehalfOf.toString());
        }
    }

    private void addQueryParams(Request request) {
        if (this.startDate != null) {
            request.addQueryParam("start_date", this.startDate.toString());
        }
        if (this.endDate != null) {
            request.addQueryParam("end_date", this.endDate.toString());
        }
    }

    public GetSuppressionBouncesClassifications(Classification1 classification, Accept1 accept) {
        this.classification = classification;
        this.accept = accept;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public void setOnBehalfOf(String onBehalfOf) {
        this.onBehalfOf = onBehalfOf;
    }
}

