/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.stats;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.stats.models.ListCategory200ResponseInner;
import com.sendgrid.rest.api.v3.stats.models.ListCategory400Response;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;
import java.util.List;

public class ListCategory
extends ApiKeyBase {
    private Integer limit;
    private String category;
    private Integer offset;
    private String onBehalfOf;

    @Override
    public ApiResponse<List<ListCategory200ResponseInner>> send(ApiKeyRestClient client) {
        String path = "/v3/categories";
        Request request = new Request(HttpMethod.GET, path, Domains.API.toString());
        this.addQueryParams(request);
        this.addHeaderParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ListCategory creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "400")) {
                ListCategory400Response error = JsonUtil.fromJson(response.getStream(), ListCategory400Response.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<List<ListCategory200ResponseInner>>(statusCode, JsonUtil.fromJson(response.getStream(), List.class), response.getHeaders());
    }

    private void addHeaderParams(Request request) {
        if (this.onBehalfOf != null) {
            request.addHeaderParam("on-behalf-of", this.onBehalfOf.toString());
        }
    }

    private void addQueryParams(Request request) {
        if (this.limit != null) {
            request.addQueryParam("limit", this.limit.toString());
        }
        if (this.category != null) {
            request.addQueryParam("category", this.category.toString());
        }
        if (this.offset != null) {
            request.addQueryParam("offset", this.offset.toString());
        }
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public void setOnBehalfOf(String onBehalfOf) {
        this.onBehalfOf = onBehalfOf;
    }
}

