/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.mcstats;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.util.JsonUtil;
import java.util.List;

public class ExportSingleSendStat
extends ApiKeyBase {
    private List<String> ids;
    private String timezone;

    @Override
    public ApiResponse<String> send(ApiKeyRestClient client) {
        String path = "/v3/marketing/stats/singlesends/export";
        Request request = new Request(HttpMethod.GET, path, Domains.API.toString());
        this.addQueryParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ExportSingleSendStat creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<String>(statusCode, response.getHeaders());
    }

    private void addQueryParams(Request request) {
        if (this.ids != null) {
            request.addQueryParam("ids", this.ids.toString());
        }
        if (this.timezone != null) {
            request.addQueryParam("timezone", this.timezone.toString());
        }
    }

    public void setIds(List<String> ids) {
        this.ids = ids;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }
}

