/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.mcsinglesends;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.mcsinglesends.models.ListSingleSend500Response;
import com.sendgrid.rest.api.v3.mcsinglesends.models.SinglesendRequest;
import com.sendgrid.rest.api.v3.mcsinglesends.models.SinglesendResponse;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;

public class UpdateSingleSend
extends ApiKeyBase {
    private final String id;
    private SinglesendRequest singlesendRequest;

    @Override
    public ApiResponse<SinglesendResponse> send(ApiKeyRestClient client) {
        String path = "/v3/marketing/singlesends/{id}";
        Request request = new Request(HttpMethod.PATCH, path, Domains.API.toString());
        this.addPathParams(request);
        this.addBody(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("UpdateSingleSend creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "400")) {
                ListSingleSend500Response error = JsonUtil.fromJson(response.getStream(), ListSingleSend500Response.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "404")) {
                ListSingleSend500Response error = JsonUtil.fromJson(response.getStream(), ListSingleSend500Response.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "500")) {
                ListSingleSend500Response error = JsonUtil.fromJson(response.getStream(), ListSingleSend500Response.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<SinglesendResponse>(statusCode, JsonUtil.fromJson(response.getStream(), SinglesendResponse.class), response.getHeaders());
    }

    private void addPathParams(Request request) {
        if (this.id != null) {
            request.addPathParam("id", this.id.toString());
        }
    }

    private void addBody(Request request) {
        if (this.singlesendRequest != null) {
            request.addBody(JsonUtil.toJson(this.singlesendRequest));
        }
    }

    public UpdateSingleSend(String id) {
        this.id = id;
    }

    public void setSinglesendRequest(SinglesendRequest singlesendRequest) {
        this.singlesendRequest = singlesendRequest;
    }
}

