/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.mcsinglesends;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.mcsinglesends.models.ListSingleSend500Response;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;
import java.util.List;

public class DeleteSingleSends
extends ApiKeyBase {
    private List<String> ids;

    @Override
    public ApiResponse<Void> send(ApiKeyRestClient client) {
        String path = "/v3/marketing/singlesends";
        Request request = new Request(HttpMethod.DELETE, path, Domains.API.toString());
        this.addQueryParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("DeleteSingleSends creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "404")) {
                ListSingleSend500Response error = JsonUtil.fromJson(response.getStream(), ListSingleSend500Response.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "500")) {
                ListSingleSend500Response error = JsonUtil.fromJson(response.getStream(), ListSingleSend500Response.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<Void>(statusCode, response.getHeaders());
    }

    private void addQueryParams(Request request) {
        if (this.ids != null) {
            request.addQueryParam("ids", this.ids.toString());
        }
    }

    public void setIds(List<String> ids) {
        this.ids = ids;
    }
}

