/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.mcsegments2;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.mcsegments2.models.ErrorsSegmentV2;
import com.sendgrid.rest.api.v3.mcsegments2.models.Segment2xx;
import com.sendgrid.rest.api.v3.mcsegments2.models.SegmentUpdate;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;

public class UpdateSegment
extends ApiKeyBase {
    private final String segmentId;
    private SegmentUpdate segmentUpdate;

    @Override
    public ApiResponse<Segment2xx> send(ApiKeyRestClient client) {
        String path = "/v3/marketing/segments/2.0/{segment_id}";
        Request request = new Request(HttpMethod.PATCH, path, Domains.API.toString());
        this.addPathParams(request);
        this.addBody(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("UpdateSegment creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "400")) {
                ErrorsSegmentV2 error = JsonUtil.fromJson(response.getStream(), ErrorsSegmentV2.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "500")) {
                ErrorsSegmentV2 error = JsonUtil.fromJson(response.getStream(), ErrorsSegmentV2.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<Segment2xx>(statusCode, response.getHeaders());
    }

    private void addPathParams(Request request) {
        if (this.segmentId != null) {
            request.addPathParam("segment_id", this.segmentId.toString());
        }
    }

    private void addBody(Request request) {
        if (this.segmentUpdate != null) {
            request.addBody(JsonUtil.toJson(this.segmentUpdate));
        }
    }

    public UpdateSegment(String segmentId) {
        this.segmentId = segmentId;
    }

    public void setSegmentUpdate(SegmentUpdate segmentUpdate) {
        this.segmentUpdate = segmentUpdate;
    }
}

