/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.mccontacts;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.mccontacts.models.ErrorResponse;
import com.sendgrid.rest.api.v3.mccontacts.models.ListBatchedContact200Response;
import com.sendgrid.rest.api.v3.mccontacts.models.ListBatchedContactRequest;
import com.sendgrid.rest.api.v3.mccontacts.models.SearchContact500Response;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;

public class ListBatchedContact
extends ApiKeyBase {
    private ListBatchedContactRequest listBatchedContactRequest;

    @Override
    public ApiResponse<ListBatchedContact200Response> send(ApiKeyRestClient client) {
        String path = "/v3/marketing/contacts/batch";
        Request request = new Request(HttpMethod.POST, path, Domains.API.toString());
        this.addBody(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ListBatchedContact creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "401")) {
                ErrorResponse error = JsonUtil.fromJson(response.getStream(), ErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "403")) {
                ErrorResponse error = JsonUtil.fromJson(response.getStream(), ErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "404")) {
                Object error = JsonUtil.fromJson(response.getStream(), Object.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "500")) {
                SearchContact500Response error = JsonUtil.fromJson(response.getStream(), SearchContact500Response.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<ListBatchedContact200Response>(statusCode, JsonUtil.fromJson(response.getStream(), ListBatchedContact200Response.class), response.getHeaders());
    }

    private void addBody(Request request) {
        if (this.listBatchedContactRequest != null) {
            request.addBody(JsonUtil.toJson(this.listBatchedContactRequest));
        }
    }

    public void setListBatchedContactRequest(ListBatchedContactRequest listBatchedContactRequest) {
        this.listBatchedContactRequest = listBatchedContactRequest;
    }
}

