/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.mccontacts;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.mccontacts.models.ErrorResponse;
import com.sendgrid.rest.api.v3.mccontacts.models.ImportContact200Response;
import com.sendgrid.rest.api.v3.mccontacts.models.ImportContact400Response;
import com.sendgrid.rest.api.v3.mccontacts.models.ImportContact404Response;
import com.sendgrid.rest.api.v3.mccontacts.models.ImportContactRequest;
import com.sendgrid.rest.api.v3.mccontacts.models.SearchContact500Response;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;

public class ImportContact
extends ApiKeyBase {
    private ImportContactRequest importContactRequest;

    @Override
    public ApiResponse<ImportContact200Response> send(ApiKeyRestClient client) {
        String path = "/v3/marketing/contacts/imports";
        Request request = new Request(HttpMethod.PUT, path, Domains.API.toString());
        this.addBody(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ImportContact creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "400")) {
                ImportContact400Response error = JsonUtil.fromJson(response.getStream(), ImportContact400Response.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "401")) {
                ErrorResponse error = JsonUtil.fromJson(response.getStream(), ErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "403")) {
                ErrorResponse error = JsonUtil.fromJson(response.getStream(), ErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "404")) {
                ImportContact404Response error = JsonUtil.fromJson(response.getStream(), ImportContact404Response.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "500")) {
                SearchContact500Response error = JsonUtil.fromJson(response.getStream(), SearchContact500Response.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<ImportContact200Response>(statusCode, JsonUtil.fromJson(response.getStream(), ImportContact200Response.class), response.getHeaders());
    }

    private void addBody(Request request) {
        if (this.importContactRequest != null) {
            request.addBody(JsonUtil.toJson(this.importContactRequest));
        }
    }

    public void setImportContactRequest(ImportContactRequest importContactRequest) {
        this.importContactRequest = importContactRequest;
    }
}

