/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.mccontacts;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.mccontacts.models.ContactsError;
import com.sendgrid.rest.api.v3.mccontacts.models.ErrorResponse;
import com.sendgrid.rest.api.v3.mccontacts.models.GetContactByIdentifiers200Response;
import com.sendgrid.rest.api.v3.mccontacts.models.GetContactByIdentifiersRequest;
import com.sendgrid.rest.api.v3.mccontacts.models.IdentifierType;
import com.sendgrid.rest.api.v3.mccontacts.models.SearchContact500Response;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;

public class GetContactByIdentifiers
extends ApiKeyBase {
    private final IdentifierType identifierType;
    private GetContactByIdentifiersRequest getContactByIdentifiersRequest;

    @Override
    public ApiResponse<GetContactByIdentifiers200Response> send(ApiKeyRestClient client) {
        String path = "/v3/marketing/contacts/search/identifiers/{identifier_type}";
        Request request = new Request(HttpMethod.POST, path, Domains.API.toString());
        this.addPathParams(request);
        this.addBody(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("GetContactByIdentifiers creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "400")) {
                ContactsError error = JsonUtil.fromJson(response.getStream(), ContactsError.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "401")) {
                ErrorResponse error = JsonUtil.fromJson(response.getStream(), ErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "403")) {
                ErrorResponse error = JsonUtil.fromJson(response.getStream(), ErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "404")) {
                ContactsError error = JsonUtil.fromJson(response.getStream(), ContactsError.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "500")) {
                SearchContact500Response error = JsonUtil.fromJson(response.getStream(), SearchContact500Response.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<GetContactByIdentifiers200Response>(statusCode, JsonUtil.fromJson(response.getStream(), GetContactByIdentifiers200Response.class), response.getHeaders());
    }

    private void addPathParams(Request request) {
        if (this.identifierType != null) {
            request.addPathParam("identifier_type", this.identifierType.toString());
        }
    }

    private void addBody(Request request) {
        if (this.getContactByIdentifiersRequest != null) {
            request.addBody(JsonUtil.toJson(this.getContactByIdentifiersRequest));
        }
    }

    public GetContactByIdentifiers(IdentifierType identifierType) {
        this.identifierType = identifierType;
    }

    public void setGetContactByIdentifiersRequest(GetContactByIdentifiersRequest getContactByIdentifiersRequest) {
        this.getContactByIdentifiersRequest = getContactByIdentifiersRequest;
    }
}

