/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.ipwarmup;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.ipwarmup.models.IpWarmup200Inner;
import com.sendgrid.rest.api.v3.ipwarmup.models.WarmUpIp404Response;
import com.sendgrid.rest.api.v3.ipwarmup.models.WarmUpIpRequest;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;
import java.util.List;

public class WarmUpIp
extends ApiKeyBase {
    private WarmUpIpRequest warmUpIpRequest;

    @Override
    public ApiResponse<List<IpWarmup200Inner>> send(ApiKeyRestClient client) {
        String path = "/v3/ips/warmup";
        Request request = new Request(HttpMethod.POST, path, Domains.API.toString());
        this.addBody(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("WarmUpIp creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "404")) {
                WarmUpIp404Response error = JsonUtil.fromJson(response.getStream(), WarmUpIp404Response.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<List<IpWarmup200Inner>>(statusCode, JsonUtil.fromJson(response.getStream(), List.class), response.getHeaders());
    }

    private void addBody(Request request) {
        if (this.warmUpIpRequest != null) {
            request.addBody(JsonUtil.toJson(this.warmUpIpRequest));
        }
    }

    public void setWarmUpIpRequest(WarmUpIpRequest warmUpIpRequest) {
        this.warmUpIpRequest = warmUpIpRequest;
    }
}

