/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.integrations;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.integrations.models.DeleteIntegration400Response;
import com.sendgrid.rest.api.v3.integrations.models.DeleteIntegration404Response;
import com.sendgrid.rest.api.v3.integrations.models.GetIntegrationsByUser403Response;
import com.sendgrid.rest.api.v3.integrations.models.GetIntegrationsByUser500Response;
import com.sendgrid.rest.api.v3.integrations.models.Id;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;
import java.util.List;

public class DeleteIntegration
extends ApiKeyBase {
    private final List<Id> ids;

    @Override
    public ApiResponse<Void> send(ApiKeyRestClient client) {
        String path = "/v3/marketing/integrations";
        Request request = new Request(HttpMethod.DELETE, path, Domains.API.toString());
        this.addQueryParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("DeleteIntegration creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "400")) {
                DeleteIntegration400Response error = JsonUtil.fromJson(response.getStream(), DeleteIntegration400Response.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "403")) {
                GetIntegrationsByUser403Response error = JsonUtil.fromJson(response.getStream(), GetIntegrationsByUser403Response.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "404")) {
                DeleteIntegration404Response error = JsonUtil.fromJson(response.getStream(), DeleteIntegration404Response.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "500")) {
                GetIntegrationsByUser500Response error = JsonUtil.fromJson(response.getStream(), GetIntegrationsByUser500Response.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<Void>(statusCode, response.getHeaders());
    }

    private void addQueryParams(Request request) {
        if (this.ids != null) {
            request.addQueryParam("ids", this.ids.toString());
        }
    }

    public DeleteIntegration(List<Id> ids) {
        this.ids = ids;
    }
}

