/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.domainauthentication;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.domainauthentication.models.EmailDnsRecord400Response;
import com.sendgrid.rest.api.v3.domainauthentication.models.EmailDnsRecordRequest;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;

public class EmailDnsRecord
extends ApiKeyBase {
    private EmailDnsRecordRequest emailDnsRecordRequest;

    @Override
    public ApiResponse<Void> send(ApiKeyRestClient client) {
        String path = "/v3/whitelabel/dns/email";
        Request request = new Request(HttpMethod.POST, path, Domains.API.toString());
        this.addBody(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("EmailDnsRecord creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "400")) {
                EmailDnsRecord400Response error = JsonUtil.fromJson(response.getStream(), EmailDnsRecord400Response.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<Void>(statusCode, response.getHeaders());
    }

    private void addBody(Request request) {
        if (this.emailDnsRecordRequest != null) {
            request.addBody(JsonUtil.toJson(this.emailDnsRecordRequest));
        }
    }

    public void setEmailDnsRecordRequest(EmailDnsRecordRequest emailDnsRecordRequest) {
        this.emailDnsRecordRequest = emailDnsRecordRequest;
    }
}

