/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.domainauthentication;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.domainauthentication.models.AssociateSubuserWithDomainRequest;
import com.sendgrid.rest.api.v3.domainauthentication.models.AuthenticatedDomainSpf;
import com.sendgrid.util.JsonUtil;

public class AssociateSubuserWithDomainMultiple
extends ApiKeyBase {
    private final Integer domainId;
    private AssociateSubuserWithDomainRequest associateSubuserWithDomainRequest;

    @Override
    public ApiResponse<AuthenticatedDomainSpf> send(ApiKeyRestClient client) {
        String path = "/v3/whitelabel/domains/{domain_id}/subuser:add";
        Request request = new Request(HttpMethod.POST, path, Domains.API.toString());
        this.addPathParams(request);
        this.addBody(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("AssociateSubuserWithDomainMultiple creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<AuthenticatedDomainSpf>(statusCode, JsonUtil.fromJson(response.getStream(), AuthenticatedDomainSpf.class), response.getHeaders());
    }

    private void addPathParams(Request request) {
        if (this.domainId != null) {
            request.addPathParam("domain_id", this.domainId.toString());
        }
    }

    private void addBody(Request request) {
        if (this.associateSubuserWithDomainRequest != null) {
            request.addBody(JsonUtil.toJson(this.associateSubuserWithDomainRequest));
        }
    }

    public AssociateSubuserWithDomainMultiple(Integer domainId) {
        this.domainId = domainId;
    }

    public void setAssociateSubuserWithDomainRequest(AssociateSubuserWithDomainRequest associateSubuserWithDomainRequest) {
        this.associateSubuserWithDomainRequest = associateSubuserWithDomainRequest;
    }
}

