/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.apikeys;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.apikeys.models.ApiKeyResponse;
import com.sendgrid.rest.api.v3.apikeys.models.ErrorResponse;
import com.sendgrid.rest.api.v3.apikeys.models.UpdateApiKeyNameRequest;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;

public class UpdateApiKeyName
extends ApiKeyBase {
    private final String apiKeyId;
    private String onBehalfOf;
    private UpdateApiKeyNameRequest updateApiKeyNameRequest;

    @Override
    public ApiResponse<ApiKeyResponse> send(ApiKeyRestClient client) {
        String path = "/v3/api_keys/{api_key_id}";
        Request request = new Request(HttpMethod.PATCH, path, Domains.API.toString());
        this.addPathParams(request);
        this.addHeaderParams(request);
        this.addBody(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("UpdateApiKeyName creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "400")) {
                ErrorResponse error = JsonUtil.fromJson(response.getStream(), ErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "401")) {
                ErrorResponse error = JsonUtil.fromJson(response.getStream(), ErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "403")) {
                ErrorResponse error = JsonUtil.fromJson(response.getStream(), ErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "404")) {
                ErrorResponse error = JsonUtil.fromJson(response.getStream(), ErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "500")) {
                Object error = JsonUtil.fromJson(response.getStream(), Object.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<ApiKeyResponse>(statusCode, JsonUtil.fromJson(response.getStream(), ApiKeyResponse.class), response.getHeaders());
    }

    private void addPathParams(Request request) {
        if (this.apiKeyId != null) {
            request.addPathParam("api_key_id", this.apiKeyId.toString());
        }
    }

    private void addHeaderParams(Request request) {
        if (this.onBehalfOf != null) {
            request.addHeaderParam("on-behalf-of", this.onBehalfOf.toString());
        }
    }

    private void addBody(Request request) {
        if (this.updateApiKeyNameRequest != null) {
            request.addBody(JsonUtil.toJson(this.updateApiKeyNameRequest));
        }
    }

    public UpdateApiKeyName(String apiKeyId) {
        this.apiKeyId = apiKeyId;
    }

    public void setOnBehalfOf(String onBehalfOf) {
        this.onBehalfOf = onBehalfOf;
    }

    public void setUpdateApiKeyNameRequest(UpdateApiKeyNameRequest updateApiKeyNameRequest) {
        this.updateApiKeyNameRequest = updateApiKeyNameRequest;
    }
}

