/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.helpers.eventwebhook;

import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.ECPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;

public class EventWebhook {
    public ECPublicKey ConvertPublicKeyToECDSA(String publicKey) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException {
        byte[] publicKeyInBytes = Base64.getDecoder().decode(publicKey);
        KeyFactory factory = KeyFactory.getInstance("ECDSA", "BC");
        return (ECPublicKey)factory.generatePublic(new X509EncodedKeySpec(publicKeyInBytes));
    }

    public boolean VerifySignature(ECPublicKey publicKey, String payload, String signature, String timestamp) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException {
        String payloadWithTimestamp = timestamp + payload;
        Signature signatureObject = Signature.getInstance("SHA256withECDSA", "BC");
        signatureObject.initVerify(publicKey);
        signatureObject.update(payloadWithTimestamp.getBytes());
        byte[] signatureInBytes = Base64.getDecoder().decode(signature);
        return signatureObject.verify(signatureInBytes);
    }
}

