/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.helpers.mail.objects;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sendgrid.helpers.mail.objects.Email;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class Personalization {
    @JsonProperty(value="to")
    private List<Email> tos;
    @JsonProperty(value="cc")
    private List<Email> ccs;
    @JsonProperty(value="bcc")
    private List<Email> bccs;
    @JsonProperty(value="subject")
    private String subject;
    @JsonProperty(value="headers")
    private Map<String, String> headers;
    @JsonProperty(value="substitutions")
    private Map<String, String> substitutions;
    @JsonProperty(value="custom_args")
    private Map<String, String> customArgs;
    @JsonProperty(value="dynamic_template_data")
    private Map<String, Object> dynamicTemplateData;
    @JsonProperty(value="send_at")
    private long sendAt;

    @JsonProperty(value="to")
    public List<Email> getTos() {
        if (this.tos == null) {
            return Collections.emptyList();
        }
        return this.tos;
    }

    public void addTo(Email email) {
        Email newEmail = new Email();
        newEmail.setName(email.getName());
        newEmail.setEmail(email.getEmail());
        if (this.tos == null) {
            this.tos = new ArrayList<Email>();
            this.tos.add(newEmail);
        } else {
            this.tos.add(newEmail);
        }
    }

    @JsonProperty(value="cc")
    public List<Email> getCcs() {
        if (this.ccs == null) {
            return Collections.emptyList();
        }
        return this.ccs;
    }

    public void addCc(Email email) {
        Email newEmail = new Email();
        newEmail.setName(email.getName());
        newEmail.setEmail(email.getEmail());
        if (this.ccs == null) {
            this.ccs = new ArrayList<Email>();
            this.ccs.add(newEmail);
        } else {
            this.ccs.add(newEmail);
        }
    }

    @JsonProperty(value="bcc")
    public List<Email> getBccs() {
        if (this.bccs == null) {
            return Collections.emptyList();
        }
        return this.bccs;
    }

    public void addBcc(Email email) {
        Email newEmail = new Email();
        newEmail.setName(email.getName());
        newEmail.setEmail(email.getEmail());
        if (this.bccs == null) {
            this.bccs = new ArrayList<Email>();
            this.bccs.add(newEmail);
        } else {
            this.bccs.add(newEmail);
        }
    }

    @JsonProperty(value="subject")
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    @JsonProperty(value="headers")
    public Map<String, String> getHeaders() {
        if (this.headers == null) {
            return Collections.emptyMap();
        }
        return this.headers;
    }

    public void addHeader(String key, String value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
            this.headers.put(key, value);
        } else {
            this.headers.put(key, value);
        }
    }

    @JsonProperty(value="substitutions")
    public Map<String, String> getSubstitutions() {
        if (this.substitutions == null) {
            return Collections.emptyMap();
        }
        return this.substitutions;
    }

    public void addSubstitution(String key, String value) {
        if (this.substitutions == null) {
            this.substitutions = new HashMap<String, String>();
            this.substitutions.put(key, value);
        } else {
            this.substitutions.put(key, value);
        }
    }

    @JsonProperty(value="custom_args")
    public Map<String, String> getCustomArgs() {
        if (this.customArgs == null) {
            return Collections.emptyMap();
        }
        return this.customArgs;
    }

    public void addCustomArg(String key, String value) {
        if (this.customArgs == null) {
            this.customArgs = new HashMap<String, String>();
            this.customArgs.put(key, value);
        } else {
            this.customArgs.put(key, value);
        }
    }

    @JsonProperty(value="send_at")
    public long sendAt() {
        return this.sendAt;
    }

    public void setSendAt(long sendAt) {
        this.sendAt = sendAt;
    }

    @JsonProperty(value="dynamic_template_data")
    public Map<String, Object> getDynamicTemplateData() {
        return this.dynamicTemplateData == null ? Collections.emptyMap() : this.dynamicTemplateData;
    }

    public void addDynamicTemplateData(String key, Object value) {
        if (this.dynamicTemplateData == null) {
            this.dynamicTemplateData = new HashMap<String, Object>();
        }
        this.dynamicTemplateData.put(key, value);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bccs == null ? 0 : this.bccs.hashCode());
        result = 31 * result + (this.ccs == null ? 0 : this.ccs.hashCode());
        result = 31 * result + (this.customArgs == null ? 0 : this.customArgs.hashCode());
        result = 31 * result + (this.headers == null ? 0 : this.headers.hashCode());
        result = 31 * result + (int)(this.sendAt ^ this.sendAt >>> 32);
        result = 31 * result + (this.subject == null ? 0 : this.subject.hashCode());
        result = 31 * result + (this.substitutions == null ? 0 : this.substitutions.hashCode());
        result = 31 * result + (this.tos == null ? 0 : this.tos.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Personalization other = (Personalization)obj;
        if (this.bccs == null ? other.bccs != null : !this.bccs.equals(other.bccs)) {
            return false;
        }
        if (this.ccs == null ? other.ccs != null : !this.ccs.equals(other.ccs)) {
            return false;
        }
        if (this.customArgs == null ? other.customArgs != null : !this.customArgs.equals(other.customArgs)) {
            return false;
        }
        if (this.headers == null ? other.headers != null : !this.headers.equals(other.headers)) {
            return false;
        }
        if (this.sendAt != other.sendAt) {
            return false;
        }
        if (this.subject == null ? other.subject != null : !this.subject.equals(other.subject)) {
            return false;
        }
        if (this.substitutions == null ? other.substitutions != null : !this.substitutions.equals(other.substitutions)) {
            return false;
        }
        return !(this.tos == null ? other.tos != null : !this.tos.equals(other.tos));
    }
}

