/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid;

import com.sendgrid.Request;
import com.sendgrid.Response;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class Client {
    private CloseableHttpClient httpClient;

    public Client() {
        this.httpClient = HttpClients.createDefault();
    }

    public Client(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public URI buildUri(String baseUri, String endpoint, Map<String, String> queryParams) throws URISyntaxException {
        URIBuilder builder = new URIBuilder();
        builder.setScheme("https");
        builder.setHost(baseUri);
        builder.setPath(endpoint);
        if (queryParams != null) {
            for (Map.Entry<String, String> entry : queryParams.entrySet()) {
                builder.setParameter(entry.getKey(), entry.getValue());
            }
        }
        URI uri = builder.build();
        return uri;
    }

    public Response getResponse(CloseableHttpResponse response) throws IOException {
        BasicResponseHandler handler = new BasicResponseHandler();
        String responseBody = "";
        int statusCode = response.getStatusLine().getStatusCode();
        responseBody = (String)handler.handleResponse((HttpResponse)response);
        Header[] headers = response.getAllHeaders();
        HashMap<String, String> responseHeaders = new HashMap<String, String>();
        for (Header h : headers) {
            responseHeaders.put(h.getName(), h.getValue());
        }
        return new Response(statusCode, responseBody, responseHeaders);
    }

    public Response get(Request request) throws URISyntaxException, IOException {
        CloseableHttpResponse serverResponse = null;
        Response response = new Response();
        URI uri = null;
        HttpGet httpGet = null;
        uri = this.buildUri(request.baseUri, request.endpoint, request.queryParams);
        httpGet = new HttpGet(uri.toString());
        if (request.headers != null) {
            for (Map.Entry<String, String> entry : request.headers.entrySet()) {
                httpGet.setHeader(entry.getKey(), entry.getValue());
            }
        }
        try {
            serverResponse = this.httpClient.execute((HttpUriRequest)httpGet);
            response = this.getResponse(serverResponse);
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            if (serverResponse != null) {
                serverResponse.close();
            }
        }
        return response;
    }

    public Response post(Request request) throws URISyntaxException, IOException {
        CloseableHttpResponse serverResponse = null;
        Response response = new Response();
        URI uri = null;
        HttpPost httpPost = null;
        uri = this.buildUri(request.baseUri, request.endpoint, request.queryParams);
        httpPost = new HttpPost(uri.toString());
        if (request.headers != null) {
            for (Map.Entry<String, String> entry : request.headers.entrySet()) {
                httpPost.setHeader(entry.getKey(), entry.getValue());
            }
        }
        httpPost.setEntity((HttpEntity)new StringEntity(request.body));
        try {
            serverResponse = this.httpClient.execute((HttpUriRequest)httpPost);
            response = this.getResponse(serverResponse);
            serverResponse.close();
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            if (serverResponse != null) {
                serverResponse.close();
            }
        }
        return response;
    }

    public Response patch(Request request) throws URISyntaxException, IOException {
        CloseableHttpResponse serverResponse = null;
        Response response = new Response();
        URI uri = null;
        HttpPatch httpPatch = null;
        uri = this.buildUri(request.baseUri, request.endpoint, request.queryParams);
        httpPatch = new HttpPatch(uri.toString());
        if (request.headers != null) {
            for (Map.Entry<String, String> entry : request.headers.entrySet()) {
                httpPatch.setHeader(entry.getKey(), entry.getValue());
            }
        }
        httpPatch.setEntity((HttpEntity)new StringEntity(request.body));
        try {
            serverResponse = this.httpClient.execute((HttpUriRequest)httpPatch);
            response = this.getResponse(serverResponse);
            serverResponse.close();
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            if (serverResponse != null) {
                serverResponse.close();
            }
        }
        return response;
    }

    public Response put(Request request) throws URISyntaxException, IOException {
        CloseableHttpResponse serverResponse = null;
        Response response = new Response();
        URI uri = null;
        HttpPut httpPut = null;
        uri = this.buildUri(request.baseUri, request.endpoint, request.queryParams);
        httpPut = new HttpPut(uri.toString());
        if (request.headers != null) {
            for (Map.Entry<String, String> entry : request.headers.entrySet()) {
                httpPut.setHeader(entry.getKey(), entry.getValue());
            }
        }
        httpPut.setEntity((HttpEntity)new StringEntity(request.body));
        try {
            serverResponse = this.httpClient.execute((HttpUriRequest)httpPut);
            response = this.getResponse(serverResponse);
            serverResponse.close();
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            if (serverResponse != null) {
                serverResponse.close();
            }
        }
        return response;
    }

    public Response delete(Request request) throws URISyntaxException, IOException {
        CloseableHttpResponse serverResponse = null;
        Response response = new Response();
        URI uri = null;
        HttpDelete httpDelete = null;
        uri = this.buildUri(request.baseUri, request.endpoint, request.queryParams);
        httpDelete = new HttpDelete(uri.toString());
        if (request.headers != null) {
            for (Map.Entry<String, String> entry : request.headers.entrySet()) {
                httpDelete.setHeader(entry.getKey(), entry.getValue());
            }
        }
        try {
            serverResponse = this.httpClient.execute((HttpUriRequest)httpDelete);
            response = this.getResponse(serverResponse);
            serverResponse.close();
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            if (serverResponse != null) {
                serverResponse.close();
            }
        }
        return response;
    }

    public Response api(Request request) throws IOException {
        try {
            if (request.method == null) {
                throw new IOException("We only support GET, PUT, PATCH, POST and DELETE.");
            }
            switch (request.method) {
                case GET: {
                    return this.get(request);
                }
                case POST: {
                    return this.post(request);
                }
                case PUT: {
                    return this.put(request);
                }
                case PATCH: {
                    return this.patch(request);
                }
                case DELETE: {
                    return this.delete(request);
                }
            }
            throw new IOException("We only support GET, PUT, PATCH, POST and DELETE.");
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (URISyntaxException ex) {
            StringWriter errors = new StringWriter();
            ex.printStackTrace(new PrintWriter(errors));
            throw new IOException(errors.toString());
        }
    }
}

