/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.widgets;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatImageView;
import com.sendbird.uikit.R;

public class RoundCornerView
extends ViewGroup {
    private final Paint roundingPaint = new Paint();
    private final RectF canvasBounds = new RectF();
    private final Canvas tempCanvas = new Canvas();
    private Bitmap tempBitmap;
    private float radius;
    private final AppCompatImageView child;

    public RoundCornerView(Context context) {
        this(context, null);
    }

    public RoundCornerView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RoundCornerView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.roundingPaint.setAntiAlias(true);
        this.roundingPaint.setFilterBitmap(true);
        this.radius = this.getContext().getResources().getDimension(R.dimen.sb_size_16);
        this.child = new AppCompatImageView(this.getContext());
        this.child.setScaleType(ImageView.ScaleType.CENTER_CROP);
        this.child.setMinimumWidth((int)this.getContext().getResources().getDimension(R.dimen.sb_size_100));
        this.child.setMinimumHeight((int)this.getContext().getResources().getDimension(R.dimen.sb_size_100));
        this.child.setMaxWidth((int)this.getContext().getResources().getDimension(R.dimen.sb_message_max_width));
        this.child.setMaxHeight((int)this.getContext().getResources().getDimension(R.dimen.sb_message_max_height));
        this.addView((View)this.child);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        this.child.layout(0, 0, this.getMeasuredWidth(), this.getMeasuredHeight());
    }

    public void setRadius(float radius) {
        this.radius = radius;
    }

    protected void dispatchDraw(Canvas canvas) {
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.isInEditMode()) {
            Paint debugPaint = new Paint(1);
            debugPaint.setColor(this.getResources().getColor(R.color.background_400));
            canvas.drawRoundRect(new RectF(0.0f, 0.0f, (float)width, (float)height), 0.0f, 0.0f, debugPaint);
            return;
        }
        if (width <= 0 || height <= 0) {
            super.dispatchDraw(canvas);
            return;
        }
        if (this.tempBitmap == null || this.tempBitmap.isRecycled() || this.tempBitmap.getWidth() != this.getWidth() || this.tempBitmap.getHeight() != this.getHeight()) {
            if (this.tempBitmap != null) {
                this.tempBitmap.recycle();
            }
            try {
                this.tempBitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            }
            catch (OutOfMemoryError e) {
                this.tempBitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.RGB_565);
            }
        } else {
            this.tempBitmap.eraseColor(0);
        }
        this.tempCanvas.setBitmap(this.tempBitmap);
        super.dispatchDraw(this.tempCanvas);
        this.roundingPaint.setShader((Shader)new BitmapShader(this.tempBitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP));
        this.canvasBounds.set(0.0f, 0.0f, (float)width, (float)height);
        canvas.drawRoundRect(this.canvasBounds, this.radius, this.radius, this.roundingPaint);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int specWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int specHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        this.child.measure(View.MeasureSpec.makeMeasureSpec((int)specWidth, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)specHeight, (int)0x40000000));
        this.setMeasuredDimension(this.child.getMeasuredWidth(), this.child.getMeasuredHeight());
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.tempBitmap != null) {
            this.tempBitmap.recycle();
        }
    }

    public ImageView getContent() {
        return this.child;
    }
}

