/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.widgets;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.databinding.DataBindingUtil;
import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.OGMetaData;
import com.sendbird.android.OpenChannel;
import com.sendbird.android.User;
import com.sendbird.uikit.R;
import com.sendbird.uikit.consts.MessageGroupType;
import com.sendbird.uikit.databinding.SbViewOpenChannelUserMessageComponentBinding;
import com.sendbird.uikit.log.Logger;
import com.sendbird.uikit.utils.DateUtils;
import com.sendbird.uikit.utils.IntentUtils;
import com.sendbird.uikit.utils.ViewUtils;
import com.sendbird.uikit.widgets.OpenChannelMessageView;

public class OpenChannelUserMessageView
extends OpenChannelMessageView {
    private SbViewOpenChannelUserMessageComponentBinding binding;
    private int editedAppearance;
    private int operatorAppearance;
    private int nicknameAppearance;
    private int marginLeftEmpty;
    private int marginLeftNor;

    @Override
    public SbViewOpenChannelUserMessageComponentBinding getBinding() {
        return this.binding;
    }

    public OpenChannelUserMessageView(Context context) {
        this(context, null);
    }

    public OpenChannelUserMessageView(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.sb_open_channel_message_user_style);
    }

    public OpenChannelUserMessageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs, defStyle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs, int defStyle) {
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.MessageView, defStyle, 0);
        try {
            this.binding = (SbViewOpenChannelUserMessageComponentBinding)DataBindingUtil.inflate((LayoutInflater)LayoutInflater.from((Context)this.getContext()), (int)R.layout.sb_view_open_channel_user_message_component, (ViewGroup)this, (boolean)true);
            int timeAppearance = a.getResourceId(R.styleable.MessageView_sb_message_time_text_appearance, R.style.SendbirdCaption4OnLight03);
            int messageAppearance = a.getResourceId(R.styleable.MessageView_sb_message_text_appearance, R.style.SendbirdBody3OnLight01);
            int contentBackground = a.getResourceId(R.styleable.MessageView_sb_message_background, R.drawable.selector_rectangle_light);
            int linkTextColor = a.getResourceId(R.styleable.MessageView_sb_message_link_text_color, R.color.ondark_01);
            int ogtagBackground = a.getResourceId(R.styleable.MessageView_sb_message_ogtag_background, R.drawable.selector_open_channel_message_bg_light);
            this.nicknameAppearance = a.getResourceId(R.styleable.MessageView_sb_message_sender_name_text_appearance, R.style.SendbirdCaption1OnLight02);
            this.operatorAppearance = a.getResourceId(R.styleable.MessageView_sb_message_operator_name_text_appearance, R.style.SendbirdCaption1Secondary300);
            this.editedAppearance = a.getResourceId(R.styleable.MessageView_sb_message_edited_mark_text_appearance, R.style.SendbirdBody3OnLight02);
            this.binding.ogTag.setBackgroundResource(ogtagBackground);
            this.binding.tvMessage.setTextAppearance(context, messageAppearance);
            this.binding.tvMessage.setLinkTextColor(context.getResources().getColor(linkTextColor));
            this.binding.tvMessage.setClickedLinkTextColor(context.getResources().getColor(linkTextColor));
            this.binding.contentPanel.setBackgroundResource(contentBackground);
            this.binding.tvSentAt.setTextAppearance(context, timeAppearance);
            this.binding.tvMessage.setOnClickListener(v -> this.binding.contentPanel.performClick());
            this.binding.tvMessage.setOnLongClickListener(v -> this.binding.contentPanel.performLongClick());
            this.binding.tvMessage.setOnLinkLongClickListener((v, link) -> this.binding.contentPanel.performLongClick());
            this.binding.tvMessage.setClickedLinkBackgroundColor(context.getResources().getColor(R.color.primary_400));
            this.binding.ogTag.setOnLongClickListener(v -> this.binding.contentPanel.performLongClick());
            this.marginLeftEmpty = this.getResources().getDimensionPixelSize(R.dimen.sb_size_40);
            this.marginLeftNor = this.getResources().getDimensionPixelSize(R.dimen.sb_size_12);
        }
        finally {
            a.recycle();
        }
    }

    @Override
    public View getLayout() {
        return this.binding.getRoot();
    }

    @Override
    public void drawMessage(OpenChannel channel, BaseMessage message, MessageGroupType messageGroupType) {
        ViewUtils.drawTextMessage((TextView)this.binding.tvMessage, message, this.editedAppearance);
        this.binding.ogTag.drawOgtag(message.getOgMetaData());
        this.binding.ivStatus.drawStatus(message, (BaseChannel)channel);
        if (messageGroupType == MessageGroupType.GROUPING_TYPE_SINGLE || messageGroupType == MessageGroupType.GROUPING_TYPE_HEAD) {
            this.binding.ivProfileView.setVisibility(0);
            this.binding.tvNickname.setVisibility(0);
            this.binding.tvSentAt.setVisibility(0);
            this.binding.tvSentAt.setText((CharSequence)DateUtils.formatTime(this.getContext(), message.getCreatedAt()));
            if (channel.isOperator((User)message.getSender())) {
                this.binding.tvNickname.setTextAppearance(this.getContext(), this.operatorAppearance);
            } else {
                this.binding.tvNickname.setTextAppearance(this.getContext(), this.nicknameAppearance);
            }
            ViewUtils.drawNickname((TextView)this.binding.tvNickname, message);
            ViewUtils.drawProfile((ImageView)this.binding.ivProfileView, message);
            ConstraintLayout.LayoutParams params = (ConstraintLayout.LayoutParams)this.binding.tvMessage.getLayoutParams();
            params.leftMargin = this.marginLeftNor;
            this.binding.tvMessage.setLayoutParams((ViewGroup.LayoutParams)params);
        } else {
            this.binding.ivProfileView.setVisibility(8);
            this.binding.tvNickname.setVisibility(8);
            this.binding.tvSentAt.setVisibility(8);
            ConstraintLayout.LayoutParams params = (ConstraintLayout.LayoutParams)this.binding.tvMessage.getLayoutParams();
            params.leftMargin = this.marginLeftEmpty;
            this.binding.tvMessage.setLayoutParams((ViewGroup.LayoutParams)params);
        }
        this.binding.ogTag.setOnClickListener(v -> {
            OGMetaData ogMetaData = message.getOgMetaData();
            if (ogMetaData.getUrl() == null) {
                return;
            }
            Intent intent = IntentUtils.getWebViewerIntent(ogMetaData.getUrl());
            try {
                this.getContext().startActivity(intent);
            }
            catch (ActivityNotFoundException e) {
                Logger.e(e);
            }
        });
    }
}

