/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.widgets;

import android.content.Context;
import android.content.res.TypedArray;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.databinding.BindingAdapter;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.FileMessage;
import com.sendbird.uikit.R;
import com.sendbird.uikit.databinding.SbViewMessagePreviewBinding;
import com.sendbird.uikit.utils.DateUtils;
import com.sendbird.uikit.utils.DrawableUtils;
import com.sendbird.uikit.utils.ViewUtils;

public class MessagePreview
extends FrameLayout {
    private SbViewMessagePreviewBinding binding;
    private int metaPhorTintColor;
    private int messageTextAppearance;
    private int messageFileTextAppearance;

    public MessagePreview(Context context) {
        this(context, null);
    }

    public MessagePreview(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.sb_message_preview_style);
    }

    public MessagePreview(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs, defStyle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs, int defStyle) {
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.MessagePreview, defStyle, 0);
        try {
            this.binding = SbViewMessagePreviewBinding.inflate(LayoutInflater.from((Context)this.getContext()));
            this.addView(this.binding.getRoot(), -1, -2);
            int background = a.getResourceId(R.styleable.MessagePreview_sb_message_preview_background, R.drawable.selector_rectangle_light);
            int userNameAppearance = a.getResourceId(R.styleable.MessagePreview_sb_message_preview_username_text_appearance, R.style.SendbirdSubtitle1OnLight01);
            this.messageTextAppearance = a.getResourceId(R.styleable.MessagePreview_sb_message_preview_message_text_appearance, R.style.SendbirdBody3OnLight03);
            this.messageFileTextAppearance = a.getResourceId(R.styleable.MessagePreview_sb_message_preview_message_file_text_appearance, R.style.SendbirdBody3OnLight01);
            int sentAtTextAppearance = a.getResourceId(R.styleable.MessagePreview_sb_message_preview_sent_at_text_appearance, R.style.SendbirdCaption2OnLight02);
            int dividerColor = a.getResourceId(R.styleable.MessagePreview_sb_message_preview_divider_color, R.color.onlight_04);
            int metaphorBackgroundColor = a.getResourceId(R.styleable.MessagePreview_sb_message_preview_message_metaphor_background_color, R.color.background_100);
            this.metaPhorTintColor = a.getResourceId(R.styleable.MessagePreview_sb_message_preview_message_metaphor_icon_tint_color, R.color.primary_300);
            this.binding.root.setBackgroundResource(background);
            this.binding.tvUserName.setTextAppearance(context, userNameAppearance);
            this.binding.tvMessage.setTextAppearance(context, this.messageTextAppearance);
            this.binding.tvSentAt.setTextAppearance(context, sentAtTextAppearance);
            this.binding.ivDivider.setBackgroundResource(dividerColor);
            this.binding.ivIcon.setBackgroundDrawable(DrawableUtils.createRoundedRectrangle(this.getResources().getDimension(R.dimen.sb_size_8), ContextCompat.getColor((Context)context, (int)metaphorBackgroundColor)));
        }
        finally {
            a.recycle();
        }
    }

    public void drawMessage(@NonNull BaseMessage message) {
        Context context = this.binding.tvSentAt.getContext();
        ViewUtils.drawProfile((ImageView)this.binding.ivProfile, message);
        this.binding.tvUserName.setText((CharSequence)message.getSender().getNickname());
        this.binding.tvSentAt.setText((CharSequence)DateUtils.formatDateTime(context, message.getCreatedAt()));
        if (message instanceof FileMessage) {
            FileMessage fileMessage = (FileMessage)message;
            int icon = this.getIconDrawable(fileMessage.getType());
            this.binding.tvMessage.setSingleLine(true);
            this.binding.tvMessage.setMaxLines(1);
            this.binding.tvMessage.setEllipsize(TextUtils.TruncateAt.MIDDLE);
            this.binding.tvMessage.setTextAppearance(context, this.messageFileTextAppearance);
            this.binding.ivIcon.setImageDrawable(DrawableUtils.setTintList(this.binding.ivIcon.getContext(), icon, this.metaPhorTintColor));
            this.binding.ivIcon.setImageResource(icon);
            this.binding.ivIcon.setVisibility(0);
            this.binding.tvMessage.setText((CharSequence)fileMessage.getName());
        } else {
            this.binding.tvMessage.setSingleLine(false);
            this.binding.tvMessage.setMaxLines(2);
            this.binding.tvMessage.setEllipsize(TextUtils.TruncateAt.END);
            this.binding.tvMessage.setTextAppearance(context, this.messageTextAppearance);
            this.binding.tvMessage.setText((CharSequence)message.getMessage());
            this.binding.ivIcon.setVisibility(8);
        }
    }

    @BindingAdapter(value={"message"})
    public static void drawMessage(MessagePreview view, BaseMessage message) {
        view.drawMessage(message);
    }

    private int getIconDrawable(@NonNull String mimeType) {
        int icon = mimeType.toLowerCase().contains("image") ? (mimeType.endsWith("gif") ? R.drawable.icon_gif : R.drawable.icon_photo) : (mimeType.toLowerCase().contains("video") ? R.drawable.icon_play : (mimeType.toLowerCase().contains("audio") ? R.drawable.icon_file_audio : R.drawable.icon_file_document));
        return icon;
    }
}

