/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.utils;

import android.content.Context;
import android.view.View;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.StringRes;
import com.sendbird.uikit.widgets.ToastView;

public class ContextUtils {
    public static String getApplicationName(@NonNull Context context) {
        return context.getApplicationInfo().loadLabel(context.getPackageManager()).toString();
    }

    public static void toastSuccess(Context context, @StringRes int text) {
        if (context == null) {
            return;
        }
        ToastView toastView = new ToastView(context);
        toastView.setStauts(ToastView.ToastStatus.SUCCESS);
        toastView.setText(text);
        ContextUtils.showToast(context, (View)toastView);
    }

    public static void toastSuccess(Context context, CharSequence text) {
        if (context == null) {
            return;
        }
        ToastView toastView = new ToastView(context);
        toastView.setStauts(ToastView.ToastStatus.SUCCESS);
        toastView.setText(text);
        ContextUtils.showToast(context, (View)toastView);
    }

    public static void toastError(Context context, @StringRes int resId) {
        if (context == null) {
            return;
        }
        ToastView toastView = new ToastView(context);
        toastView.setStauts(ToastView.ToastStatus.ERROR);
        toastView.setText(resId);
        ContextUtils.showToast(context, (View)toastView);
    }

    public static void toastError(Context context, String message) {
        if (context == null) {
            return;
        }
        ToastView toastView = new ToastView(context);
        toastView.setStauts(ToastView.ToastStatus.ERROR);
        toastView.setText(message);
        ContextUtils.showToast(context, (View)toastView);
    }

    private static void showToast(Context context, View toastView) {
        Toast toast = new Toast(context);
        toast.setGravity(81, 0, 200);
        toast.setDuration(1);
        toast.setView(toastView);
        toast.show();
    }
}

