/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.fragments;

import android.content.res.ColorStateList;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.databinding.DataBindingUtil;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import com.sendbird.uikit.R;
import com.sendbird.uikit.SendBirdUIKit;
import com.sendbird.uikit.activities.adapter.UserListAdapter;
import com.sendbird.uikit.databinding.SbFragmentSelectUsersBinding;
import com.sendbird.uikit.fragments.BaseGroupChannelFragment;
import com.sendbird.uikit.interfaces.CustomUserListQueryHandler;
import com.sendbird.uikit.interfaces.UserInfo;
import com.sendbird.uikit.log.Logger;
import com.sendbird.uikit.utils.TextUtils;
import com.sendbird.uikit.vm.SelectableUserInfoListViewModel;
import com.sendbird.uikit.vm.ViewModelFactory;
import com.sendbird.uikit.widgets.StatusFrameView;
import java.util.Collections;
import java.util.List;

public abstract class SelectUserFragment
extends BaseGroupChannelFragment {
    private SbFragmentSelectUsersBinding binding;
    private SelectableUserInfoListViewModel viewModel;
    protected UserListAdapter adapter;
    protected View.OnClickListener headerLeftButtonListener;
    protected CustomUserListQueryHandler customUserListQueryHandler;
    protected String headerRightButtonText = "";

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Logger.i(">> SelectUserFragment::onCreate()", new Object[0]);
        Bundle args = this.getArguments();
        int themeResId = SendBirdUIKit.getDefaultThemeMode().getResId();
        if (args != null) {
            themeResId = args.getInt("KEY_THEME_RES_ID");
        }
        if (this.getActivity() != null) {
            this.getActivity().setTheme(themeResId);
        }
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.binding = (SbFragmentSelectUsersBinding)DataBindingUtil.inflate((LayoutInflater)inflater, (int)R.layout.sb_fragment_select_users, (ViewGroup)container, (boolean)false);
        return this.binding.getRoot();
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.binding.statusFrame.setStatus(StatusFrameView.Status.LOADING);
        this.initHeaderOnCreated();
    }

    @Override
    protected void onReadyFailure() {
        Logger.i(">> SelectUserFragment::onReadyFailure()", new Object[0]);
        this.setErrorFrame();
    }

    @Override
    protected void onConfigure() {
    }

    @Override
    protected void onDrawPage() {
        this.viewModel = (SelectableUserInfoListViewModel)new ViewModelProvider((ViewModelStoreOwner)this, (ViewModelProvider.Factory)new ViewModelFactory(this.customUserListQueryHandler)).get(SelectableUserInfoListViewModel.class);
        this.initHeaderOnReady();
        this.initUserList();
    }

    protected void setErrorFrame() {
        this.binding.statusFrame.setStatus(StatusFrameView.Status.CONNECTION_ERROR);
        this.binding.statusFrame.setOnActionEventListener(v -> {
            this.binding.statusFrame.setStatus(StatusFrameView.Status.LOADING);
            this.connect();
        });
    }

    private void initHeaderOnCreated() {
        Bundle args = this.getArguments();
        String headerTitle = this.getString(R.string.sb_text_header_select_members);
        this.headerRightButtonText = this.getString(R.string.sb_text_button_selected);
        boolean useHeader = false;
        boolean useHeaderLeftButton = true;
        boolean useHeaderRightButton = true;
        int headerLeftButtonIconResId = R.drawable.icon_arrow_left;
        ColorStateList headerLeftButtonIconTint = null;
        if (args != null) {
            headerTitle = args.getString("KEY_HEADER_TITLE", headerTitle);
            this.headerRightButtonText = args.getString("KEY_HEADER_LEFT_BUTTON_TEXT", this.headerRightButtonText);
            useHeader = args.getBoolean("KEY_USE_HEADER", false);
            useHeaderLeftButton = args.getBoolean("KEY_USE_HEADER_LEFT_BUTTON", true);
            useHeaderRightButton = args.getBoolean("KEY_USE_HEADER_RIGHT_BUTTON", true);
            headerLeftButtonIconResId = args.getInt("KEY_HEADER_LEFT_BUTTON_ICON_RES_ID", R.drawable.icon_arrow_left);
            headerLeftButtonIconTint = (ColorStateList)args.getParcelable("KEY_HEADER_LEFT_BUTTON_ICON_TINT");
        }
        this.setRightButtonText(this.headerRightButtonText);
        this.binding.abvSelectUsers.setVisibility(useHeader ? 0 : 8);
        this.binding.abvSelectUsers.getTitleTextView().setText((CharSequence)headerTitle);
        this.binding.abvSelectUsers.setUseRightButton(useHeaderRightButton);
        this.binding.abvSelectUsers.setUseLeftImageButton(useHeaderLeftButton);
        this.binding.abvSelectUsers.setLeftImageButtonResource(headerLeftButtonIconResId);
        if (args != null && args.containsKey("KEY_HEADER_LEFT_BUTTON_ICON_RES_ID")) {
            this.binding.abvSelectUsers.setLeftImageButtonTint(headerLeftButtonIconTint);
        }
        this.binding.abvSelectUsers.setLeftImageButtonClickListener(v -> this.finish());
    }

    private void initHeaderOnReady() {
        if (this.headerLeftButtonListener != null) {
            this.binding.abvSelectUsers.setLeftImageButtonClickListener(this.headerLeftButtonListener);
        }
        this.setRightButtonEnabled(false);
        this.binding.abvSelectUsers.getRightTextButton().setOnClickListener(v -> {
            if (this.adapter != null) {
                this.onUserSelectComplete(this.adapter.getSelectedUserList());
            }
        });
    }

    protected void onUserSelectComplete(List<String> selectedUsers) {
    }

    protected void setRightButtonText(CharSequence text) {
        if (this.binding != null && !TextUtils.isEmpty(text)) {
            this.binding.abvSelectUsers.setRightTextButtonString(text.toString());
        }
    }

    protected void setRightButtonEnabled(boolean enabled) {
        if (this.binding != null) {
            this.binding.abvSelectUsers.setRightTextButtonEnabled(enabled);
        }
    }

    protected List<String> getDisabledUserIds() {
        return Collections.emptyList();
    }

    private void initUserList() {
        if (this.adapter == null) {
            this.adapter = new UserListAdapter();
        }
        this.adapter.setDisabledUserList(this.getDisabledUserIds());
        this.adapter.setOnUserSelectChangedListener((selectedUsers, isChecked) -> {
            int count = selectedUsers == null ? 0 : selectedUsers.size();
            this.setRightButtonEnabled(selectedUsers != null && count > 0);
            this.setRightButtonText(count > 0 ? count + " " + this.headerRightButtonText : this.headerRightButtonText);
        });
        this.binding.rvSelectableUserList.setAdapter(this.adapter);
        this.binding.rvSelectableUserList.setHasFixedSize(true);
        this.binding.rvSelectableUserList.setPager(this.viewModel);
        this.binding.rvSelectableUserList.setThreshold(5);
        this.viewModel.getStatusFrame().observe((LifecycleOwner)this, this.binding.statusFrame::setStatus);
        this.viewModel.getUserList().observe((LifecycleOwner)this, users -> {
            Logger.dev("++ users size : %s", users.size());
            this.adapter.setItems((List<UserInfo>)users);
        });
    }

    protected <T extends UserListAdapter> void setUserListAdapter(T adapter) {
        this.adapter = adapter;
    }

    protected void setHeaderLeftButtonListener(View.OnClickListener listener) {
        this.headerLeftButtonListener = listener;
    }

    protected void setCustomUserListQueryHandler(CustomUserListQueryHandler handler) {
        this.customUserListQueryHandler = handler;
    }
}

