/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.fragments;

import android.content.res.ColorStateList;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.annotation.StyleRes;
import androidx.databinding.DataBindingUtil;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import com.sendbird.android.Member;
import com.sendbird.android.OpenChannel;
import com.sendbird.android.ParticipantListQuery;
import com.sendbird.android.SendBird;
import com.sendbird.android.User;
import com.sendbird.uikit.R;
import com.sendbird.uikit.SendBirdUIKit;
import com.sendbird.uikit.activities.adapter.UserTypeListAdapter;
import com.sendbird.uikit.databinding.SbFragmentUserTypeListBinding;
import com.sendbird.uikit.fragments.BaseOpenChannelFragment;
import com.sendbird.uikit.interfaces.CustomMemberListQueryHandler;
import com.sendbird.uikit.interfaces.OnItemClickListener;
import com.sendbird.uikit.interfaces.OnItemLongClickListener;
import com.sendbird.uikit.interfaces.OnListResultHandler;
import com.sendbird.uikit.log.Logger;
import com.sendbird.uikit.utils.DialogUtils;
import com.sendbird.uikit.vm.UserTypeListViewModel;
import com.sendbird.uikit.vm.ViewModelFactory;
import com.sendbird.uikit.widgets.StatusFrameView;
import java.util.List;

public class ParticipantsListFragment
extends BaseOpenChannelFragment {
    private SbFragmentUserTypeListBinding binding;
    protected View.OnClickListener headerLeftButtonListener;
    protected UserTypeListAdapter adapter;
    protected OnItemClickListener<User> itemClickListener;
    protected OnItemLongClickListener<User> itemLongClickListener;
    protected OnItemClickListener<User> profileClickListener;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Logger.i(">> ChannelUserListFragment::onCreate()", new Object[0]);
        Bundle args = this.getArguments();
        int themeResId = SendBirdUIKit.getDefaultThemeMode().getResId();
        if (args != null) {
            themeResId = args.getInt("KEY_THEME_RES_ID");
        }
        if (this.getActivity() != null) {
            this.getActivity().setTheme(themeResId);
        }
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.binding = (SbFragmentUserTypeListBinding)DataBindingUtil.inflate((LayoutInflater)inflater, (int)R.layout.sb_fragment_user_type_list, (ViewGroup)container, (boolean)false);
        return this.binding.getRoot();
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.binding.statusFrame.setStatus(StatusFrameView.Status.LOADING);
        this.initHeaderOnCreated();
    }

    @Override
    protected void onReadyFailure() {
        Logger.i(">> ParticipantsListFragment::onReadyFailure()", new Object[0]);
        this.setErrorFrame();
    }

    @Override
    protected void onDrawPage() {
        if (!this.containsExtra("KEY_CHANNEL_URL")) {
            this.setErrorFrame();
            return;
        }
        this.initHeaderOnReady();
        this.initParticipantsList(this.channel);
    }

    @Override
    protected void onConfigure() {
    }

    protected void setErrorFrame() {
        this.binding.statusFrame.setStatus(StatusFrameView.Status.CONNECTION_ERROR);
        this.binding.statusFrame.setOnActionEventListener(v -> {
            this.binding.statusFrame.setStatus(StatusFrameView.Status.LOADING);
            this.connect();
        });
    }

    private void initHeaderOnCreated() {
        Bundle args = this.getArguments();
        String headerTitle = this.getString(R.string.sb_text_header_member_list);
        boolean useHeader = false;
        boolean useHeaderLeftButton = true;
        int headerLeftButtonIconResId = R.drawable.icon_arrow_left;
        ColorStateList headerLeftButtonIconTint = null;
        int emptyIconId = R.drawable.icon_chat;
        ColorStateList emptyIconTint = null;
        int emptyTextId = R.string.sb_text_user_list_empty;
        if (args != null) {
            headerTitle = args.getString("KEY_HEADER_TITLE", headerTitle);
            useHeader = args.getBoolean("KEY_USE_HEADER", false);
            useHeaderLeftButton = args.getBoolean("KEY_USE_HEADER_LEFT_BUTTON", true);
            headerLeftButtonIconResId = args.getInt("KEY_HEADER_LEFT_BUTTON_ICON_RES_ID", R.drawable.icon_arrow_left);
            headerLeftButtonIconTint = (ColorStateList)args.getParcelable("KEY_HEADER_LEFT_BUTTON_ICON_TINT");
            emptyIconId = args.getInt("KEY_EMPTY_ICON_RES_ID", R.drawable.icon_chat);
            emptyIconTint = (ColorStateList)args.getParcelable("KEY_EMPTY_ICON_TINT");
            emptyTextId = args.getInt("KEY_EMPTY_TEXT_RES_ID", R.string.sb_text_user_list_empty);
        }
        this.binding.abvMemberList.setVisibility(useHeader ? 0 : 8);
        this.binding.abvMemberList.getTitleTextView().setText((CharSequence)headerTitle);
        this.binding.abvMemberList.setUseLeftImageButton(useHeaderLeftButton);
        this.binding.abvMemberList.setUseRightButton(false);
        this.binding.abvMemberList.setLeftImageButtonResource(headerLeftButtonIconResId);
        if (args != null && args.containsKey("KEY_HEADER_LEFT_BUTTON_ICON_RES_ID")) {
            this.binding.abvMemberList.setLeftImageButtonTint(headerLeftButtonIconTint);
        }
        this.binding.abvMemberList.setLeftImageButtonClickListener(v -> this.finish());
        this.binding.statusFrame.setEmptyIcon(emptyIconId);
        this.binding.statusFrame.setEmptyText(emptyTextId);
        if (args != null && args.containsKey("KEY_EMPTY_ICON_RES_ID")) {
            this.binding.statusFrame.setIconTint(emptyIconTint);
        }
    }

    private void initHeaderOnReady() {
        if (this.headerLeftButtonListener != null) {
            this.binding.abvMemberList.setLeftImageButtonClickListener(this.headerLeftButtonListener);
        }
    }

    private void initParticipantsList(@NonNull OpenChannel channel) {
        Bundle args;
        UserTypeListViewModel viewModel = (UserTypeListViewModel)new ViewModelProvider((ViewModelStoreOwner)this.getActivity(), (ViewModelProvider.Factory)new ViewModelFactory(channel, new ParticipantsListQuery(channel))).get(channel.getUrl(), UserTypeListViewModel.class);
        this.getLifecycle().addObserver((LifecycleObserver)viewModel);
        if (this.adapter == null) {
            this.adapter = new UserTypeListAdapter();
        }
        boolean useUserProfile = (args = this.getArguments()) == null || args.getBoolean("KEY_USE_USER_PROFILE", SendBirdUIKit.shouldUseDefaultUserProfile());
        this.adapter.setOnItemClickListener(this.itemClickListener != null ? this.itemClickListener : this::onItemClicked);
        this.adapter.setOnItemLongClickListener(this.itemLongClickListener != null ? this.itemLongClickListener : this::onItemLongClicked);
        this.adapter.setOnProfileClickListener(this.profileClickListener != null ? this.profileClickListener : (useUserProfile ? this::onProfileClicked : null));
        this.binding.rvMemberList.setAdapter(this.adapter);
        this.binding.rvMemberList.setHasFixedSize(true);
        this.binding.rvMemberList.setPager(viewModel);
        this.binding.rvMemberList.setThreshold(5);
        viewModel.getStatusFrame().observe((LifecycleOwner)this, this.binding.statusFrame::setStatus);
        viewModel.getMemberList().observe((LifecycleOwner)this, users -> {
            Logger.dev("++ observing result users size : %s", users.size());
            this.adapter.setItems((List)users, channel.isOperator(SendBird.getCurrentUser()) ? Member.Role.OPERATOR : Member.Role.NONE);
        });
        viewModel.loadInitial();
    }

    protected void onItemClicked(View view, int position, User user) {
        Logger.d(">> ParticipantsListFragment::onItemClicked()");
    }

    protected void onItemLongClicked(View view, int position, User user) {
        Logger.d(">> ParticipantsListFragment::onItemLongClicked()");
    }

    protected void onProfileClicked(View view, int position, User user) {
        if (this.getContext() == null || this.getFragmentManager() == null) {
            return;
        }
        DialogUtils.buildUserProfile(this.getContext(), user, false, null, null).showSingle(this.getFragmentManager());
    }

    protected void setHeaderLeftButtonListener(View.OnClickListener listener) {
        this.headerLeftButtonListener = listener;
    }

    protected void setItemClickListener(OnItemClickListener<User> itemClickListener) {
        this.itemClickListener = itemClickListener;
    }

    protected void setItemLongClickListener(OnItemLongClickListener<User> itemLongClickListener) {
        this.itemLongClickListener = itemLongClickListener;
    }

    protected <T extends UserTypeListAdapter> void setUserListAdapter(T adapter) {
        this.adapter = adapter;
    }

    void setOnProfileClickListener(OnItemClickListener<User> profileClickListener) {
        this.profileClickListener = profileClickListener;
    }

    public static class Builder {
        private final Bundle bundle = new Bundle();
        private ParticipantsListFragment customFragment;
        private View.OnClickListener headerLeftButtonListener;
        private UserTypeListAdapter adapter;
        private OnItemClickListener<User> itemClickListener;
        private OnItemLongClickListener<User> itemLongClickListener;
        private OnItemClickListener<User> profileClickListener;

        public Builder(@NonNull String channelUrl) {
            this(channelUrl, SendBirdUIKit.getDefaultThemeMode());
        }

        public Builder(@NonNull String channelUrl, SendBirdUIKit.ThemeMode themeMode) {
            this(channelUrl, themeMode.getResId());
        }

        public Builder(@NonNull String channelUrl, @StyleRes int customThemeResId) {
            this.bundle.putInt("KEY_THEME_RES_ID", customThemeResId);
            this.bundle.putString("KEY_CHANNEL_URL", channelUrl);
        }

        public <T extends ParticipantsListFragment> Builder setCustomParticipantsListFragment(T fragment) {
            this.customFragment = fragment;
            return this;
        }

        public Builder setHeaderTitle(String title) {
            this.bundle.putString("KEY_HEADER_TITLE", title);
            return this;
        }

        public Builder setUseHeader(boolean useHeader) {
            this.bundle.putBoolean("KEY_USE_HEADER", useHeader);
            return this;
        }

        public Builder setUseHeaderLeftButton(boolean useHeaderLeftButton) {
            this.bundle.putBoolean("KEY_USE_HEADER_LEFT_BUTTON", useHeaderLeftButton);
            return this;
        }

        public Builder setHeaderLeftButtonIconResId(@DrawableRes int resId) {
            return this.setHeaderLeftButtonIcon(resId, null);
        }

        public Builder setHeaderLeftButtonIcon(@DrawableRes int resId, @Nullable ColorStateList tint) {
            this.bundle.putInt("KEY_HEADER_LEFT_BUTTON_ICON_RES_ID", resId);
            this.bundle.putParcelable("KEY_HEADER_LEFT_BUTTON_ICON_TINT", (Parcelable)tint);
            return this;
        }

        public Builder setEmptyIcon(@DrawableRes int resId) {
            return this.setEmptyIcon(resId, null);
        }

        public Builder setEmptyIcon(@DrawableRes int resId, @Nullable ColorStateList tint) {
            this.bundle.putInt("KEY_EMPTY_ICON_RES_ID", resId);
            this.bundle.putParcelable("KEY_EMPTY_ICON_TINT", (Parcelable)tint);
            return this;
        }

        public Builder setEmptyText(@StringRes int resId) {
            this.bundle.putInt("KEY_EMPTY_TEXT_RES_ID", resId);
            return this;
        }

        public Builder setHeaderLeftButtonListener(View.OnClickListener listener) {
            this.headerLeftButtonListener = listener;
            return this;
        }

        public <T extends UserTypeListAdapter> Builder setParticipantsListAdapter(T adapter) {
            this.adapter = adapter;
            return this;
        }

        public Builder setItemClickListener(OnItemClickListener<User> itemClickListener) {
            this.itemClickListener = itemClickListener;
            return this;
        }

        public Builder setItemLongClickListener(OnItemLongClickListener<User> itemLongClickListener) {
            this.itemLongClickListener = itemLongClickListener;
            return this;
        }

        public Builder setOnProfileClickListener(OnItemClickListener<User> profileClickListener) {
            this.profileClickListener = profileClickListener;
            return this;
        }

        public Builder setUseUserProfile(boolean useUserProfile) {
            this.bundle.putBoolean("KEY_USE_USER_PROFILE", useUserProfile);
            return this;
        }

        public ParticipantsListFragment build() {
            ParticipantsListFragment fragment = this.customFragment != null ? this.customFragment : new ParticipantsListFragment();
            fragment.setArguments(this.bundle);
            fragment.setHeaderLeftButtonListener(this.headerLeftButtonListener);
            fragment.setItemClickListener(this.itemClickListener);
            fragment.setItemLongClickListener(this.itemLongClickListener);
            fragment.setUserListAdapter(this.adapter);
            fragment.setOnProfileClickListener(this.profileClickListener);
            return fragment;
        }
    }

    private static class ParticipantsListQuery
    implements CustomMemberListQueryHandler<User> {
        private final OpenChannel channel;
        private ParticipantListQuery query;

        ParticipantsListQuery(@NonNull OpenChannel channel) {
            this.channel = channel;
        }

        @Override
        public void loadInitial(OnListResultHandler<User> handler) {
            this.query = this.channel.createParticipantListQuery();
            this.query.setLimit(30);
            this.load(handler);
        }

        @Override
        public void load(OnListResultHandler<User> handler) {
            this.query.next(handler::onResult);
        }

        @Override
        public boolean hasMore() {
            return this.query.hasNext();
        }
    }
}

