/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.fragments;

import android.content.Intent;
import android.content.res.ColorStateList;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.annotation.StyleRes;
import androidx.databinding.DataBindingUtil;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.MessageSearchQuery;
import com.sendbird.uikit.R;
import com.sendbird.uikit.SendBirdUIKit;
import com.sendbird.uikit.activities.ChannelActivity;
import com.sendbird.uikit.activities.adapter.MessageSearchAdapter;
import com.sendbird.uikit.databinding.SbFragmentMessageSearchBinding;
import com.sendbird.uikit.fragments.BaseGroupChannelFragment;
import com.sendbird.uikit.interfaces.LoadingDialogHandler;
import com.sendbird.uikit.interfaces.OnItemClickListener;
import com.sendbird.uikit.interfaces.OnSearchEventListener;
import com.sendbird.uikit.log.Logger;
import com.sendbird.uikit.model.HighlightMessageInfo;
import com.sendbird.uikit.utils.SoftInputUtils;
import com.sendbird.uikit.utils.TextUtils;
import com.sendbird.uikit.vm.SearchViewModel;
import com.sendbird.uikit.vm.ViewModelFactory;
import com.sendbird.uikit.widgets.StatusFrameView;
import java.util.List;

public class MessageSearchFragment
extends BaseGroupChannelFragment
implements LoadingDialogHandler {
    private SbFragmentMessageSearchBinding binding;
    private MessageSearchAdapter adapter;
    private LoadingDialogHandler loadingDialogHandler;
    private OnSearchEventListener onSearchEventListener;
    private OnItemClickListener<BaseMessage> itemClickListener;
    private SearchViewModel viewModel;
    private MessageSearchQuery query;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Logger.i(">> MessageSearchFragment::onCreate()", new Object[0]);
        Bundle args = this.getArguments();
        int themeResId = SendBirdUIKit.getDefaultThemeMode().getResId();
        if (args != null) {
            themeResId = args.getInt("KEY_THEME_RES_ID");
        }
        if (this.getActivity() != null) {
            this.getActivity().setTheme(themeResId);
        }
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.binding = (SbFragmentMessageSearchBinding)DataBindingUtil.inflate((LayoutInflater)inflater, (int)R.layout.sb_fragment_message_search, (ViewGroup)container, (boolean)false);
        return this.binding.getRoot();
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
    }

    @Override
    public boolean shouldShowLoadingDialog() {
        this.showWaitingDialog();
        return true;
    }

    @Override
    public void shouldDismissLoadingDialog() {
        this.dismissWaitingDialog();
    }

    @Override
    protected void onReadyFailure() {
        Logger.i(">> MessageSearchFragment::onReadyFailure()", new Object[0]);
        this.setErrorFrame();
    }

    @Override
    protected void onConfigure() {
    }

    @Override
    protected void onDrawPage() {
        if (!this.containsExtra("KEY_CHANNEL_URL")) {
            this.setErrorFrame();
            return;
        }
        this.initSearchBar();
        this.initSearchResultList(this.channel);
    }

    private void initSearchBar() {
        this.binding.searchBar.setOnSearchEventListener(keyword -> {
            Logger.d("++ request search keyword : %s", keyword);
            if (TextUtils.isEmpty(keyword.trim())) {
                return;
            }
            if (this.onSearchEventListener != null) {
                this.onSearchEventListener.onSearchRequested(keyword);
                return;
            }
            this.hideKeyboard();
            this.search(keyword);
        });
        Bundle args = this.getArguments();
        boolean useSearchBar = args != null && args.getBoolean("KEY_USE_SEARCH_BAR", true);
        this.binding.searchBar.setVisibility(useSearchBar ? 0 : 8);
        if (useSearchBar) {
            String searchText = args != null && args.containsKey("KEY_SEARCH_BAR_BUTTON_TEXT") ? args.getString("KEY_SEARCH_BAR_BUTTON_TEXT") : this.getString(R.string.sb_text_button_search);
            this.binding.searchBar.getSearchButton().setText((CharSequence)searchText);
            this.binding.searchBar.getSearchButton().setEnabled(false);
            this.binding.searchBar.setOnInputTextChangedListener((s, start, before, count) -> this.binding.searchBar.getSearchButton().setEnabled(s.length() > 0));
        }
    }

    private void initSearchResultList(@NonNull GroupChannel channel) {
        this.viewModel = (SearchViewModel)new ViewModelProvider((ViewModelStoreOwner)this.getActivity(), (ViewModelProvider.Factory)new ViewModelFactory(channel, this.query)).get(channel.getUrl(), SearchViewModel.class);
        this.getLifecycle().addObserver((LifecycleObserver)this.viewModel);
        Bundle args = this.getArguments();
        if (args != null && args.containsKey("KEY_EMPTY_ICON_RES_ID")) {
            int emptyIconResId = args.getInt("KEY_EMPTY_ICON_RES_ID", R.drawable.icon_chat);
            this.binding.statusFrame.setEmptyIcon(emptyIconResId);
            ColorStateList emptyIconTint = (ColorStateList)args.getParcelable("KEY_EMPTY_ICON_TINT");
            this.binding.statusFrame.setIconTint(emptyIconTint);
        }
        if (args != null && args.containsKey("KEY_EMPTY_TEXT_RES_ID")) {
            int emptyTextResId = args.getInt("KEY_EMPTY_TEXT_RES_ID", R.string.sb_text_channel_message_empty);
            this.binding.statusFrame.setEmptyText(emptyTextResId);
        }
        if (this.adapter == null) {
            this.adapter = new MessageSearchAdapter();
        }
        if (this.loadingDialogHandler == null) {
            this.loadingDialogHandler = this;
        }
        this.adapter.setOnItemClickListener(this.itemClickListener != null ? this.itemClickListener : this::onItemClicked);
        this.binding.searchResultList.setAdapter(this.adapter);
        this.binding.searchResultList.setHasFixedSize(true);
        this.binding.searchResultList.setPager(this.viewModel);
        this.binding.searchResultList.setThreshold(5);
        this.binding.searchResultList.setUseDivider(false);
        this.viewModel.getSearchResultList().observe((LifecycleOwner)this, searchResults -> {
            Logger.dev("++ search result size : %s", searchResults.size());
            this.onSearchResultReceived((List<BaseMessage>)searchResults);
        });
        SoftInputUtils.showSoftKeyboard((EditText)this.binding.searchBar.getBinding().etInputText);
    }

    private void hideKeyboard() {
        if (this.getView() != null) {
            SoftInputUtils.hideSoftKeyboard(this.getView());
        }
    }

    protected void search(@NonNull String keyword) {
        if (this.viewModel != null) {
            this.loadingDialogHandler.shouldShowLoadingDialog();
            this.viewModel.search(keyword, (result, e) -> {
                this.loadingDialogHandler.shouldDismissLoadingDialog();
                if (e != null) {
                    this.binding.statusFrame.setVisibility(0);
                    this.binding.statusFrame.setStatus(StatusFrameView.Status.ERROR);
                }
            });
        }
    }

    protected void onSearchResultReceived(List<BaseMessage> searchResults) {
        this.loadingDialogHandler.shouldDismissLoadingDialog();
        this.binding.statusFrame.setVisibility(8);
        this.adapter.setItems(searchResults);
        if (searchResults.isEmpty()) {
            this.binding.statusFrame.setStatus(StatusFrameView.Status.EMPTY);
            this.binding.statusFrame.setVisibility(0);
        }
    }

    protected void onItemClicked(View view, int position, BaseMessage message) {
        Logger.d(">> MessageSearchFragment::onItemClicked(position=%s)", position);
        Intent intent = new ChannelActivity.IntentBuilder(this.getContext(), this.channel.getUrl()).setStartingPoint(message.getCreatedAt()).setHighlightMessageInfo(HighlightMessageInfo.fromMessage(message)).build();
        intent.putExtra("KEY_FROM_SEARCH_RESULT", false);
        this.startActivity(intent);
    }

    protected void setErrorFrame() {
        this.binding.statusFrame.setStatus(StatusFrameView.Status.CONNECTION_ERROR);
        this.binding.statusFrame.setOnActionEventListener(v -> {
            this.binding.statusFrame.setStatus(StatusFrameView.Status.LOADING);
            this.connect();
        });
    }

    private void setLoadingDialogHandler(LoadingDialogHandler loadingDialogHandler) {
        this.loadingDialogHandler = loadingDialogHandler;
    }

    private void setMessageSearchAdapter(MessageSearchAdapter adapter) {
        this.adapter = adapter;
    }

    private void setItemClickListener(OnItemClickListener<BaseMessage> itemClickListener) {
        this.itemClickListener = itemClickListener;
    }

    private void setOnSearchEventListener(OnSearchEventListener rightButtonListener) {
        this.onSearchEventListener = rightButtonListener;
    }

    private void setMessageSearchQuery(MessageSearchQuery customQueryHandler) {
        this.query = customQueryHandler;
    }

    public static class Builder {
        private final Bundle bundle = new Bundle();
        private MessageSearchFragment customFragment;
        private OnSearchEventListener onSearchEventListener;
        private MessageSearchAdapter adapter;
        private OnItemClickListener<BaseMessage> itemClickListener;
        private LoadingDialogHandler loadingDialogHandler;
        private MessageSearchQuery query;

        public Builder(@NonNull String channelUrl) {
            this(channelUrl, SendBirdUIKit.getDefaultThemeMode());
        }

        public Builder(@NonNull String channelUrl, SendBirdUIKit.ThemeMode themeMode) {
            this(channelUrl, themeMode.getResId());
        }

        public Builder(@NonNull String channelUrl, @StyleRes int customThemeResId) {
            this.bundle.putInt("KEY_THEME_RES_ID", customThemeResId);
            this.bundle.putString("KEY_CHANNEL_URL", channelUrl);
        }

        public <T extends MessageSearchFragment> Builder setCustomMessageSearchFragment(T fragment) {
            this.customFragment = fragment;
            return this;
        }

        public Builder setUseSearchBar(boolean useSearchBar) {
            this.bundle.putBoolean("KEY_USE_SEARCH_BAR", useSearchBar);
            return this;
        }

        public Builder setSearchBarButtonText(@NonNull String text) {
            this.bundle.putString("KEY_SEARCH_BAR_BUTTON_TEXT", text);
            return this;
        }

        public Builder setEmptyIcon(@DrawableRes int resId) {
            return this.setEmptyIcon(resId, null);
        }

        public Builder setEmptyIcon(@DrawableRes int resId, @Nullable ColorStateList tint) {
            this.bundle.putInt("KEY_EMPTY_ICON_RES_ID", resId);
            this.bundle.putParcelable("KEY_EMPTY_ICON_TINT", (Parcelable)tint);
            return this;
        }

        public Builder setEmptyText(@StringRes int resId) {
            this.bundle.putInt("KEY_EMPTY_TEXT_RES_ID", resId);
            return this;
        }

        public Builder setOnSearchEventListener(OnSearchEventListener listener) {
            this.onSearchEventListener = listener;
            return this;
        }

        public <T extends MessageSearchAdapter> Builder setMessageSearchAdapter(T adapter) {
            this.adapter = adapter;
            return this;
        }

        public Builder setItemClickListener(OnItemClickListener<BaseMessage> itemClickListener) {
            this.itemClickListener = itemClickListener;
            return this;
        }

        public Builder setLoadingDialogHandler(LoadingDialogHandler loadingDialogHandler) {
            this.loadingDialogHandler = loadingDialogHandler;
            return this;
        }

        public Builder setMessageSearchQuery(@NonNull MessageSearchQuery query) {
            this.query = query;
            return this;
        }

        public MessageSearchFragment build() {
            MessageSearchFragment fragment = this.customFragment != null ? this.customFragment : new MessageSearchFragment();
            fragment.setArguments(this.bundle);
            fragment.setOnSearchEventListener(this.onSearchEventListener);
            fragment.setItemClickListener(this.itemClickListener);
            fragment.setMessageSearchAdapter(this.adapter);
            fragment.setLoadingDialogHandler(this.loadingDialogHandler);
            fragment.setMessageSearchQuery(this.query);
            return fragment;
        }
    }
}

