/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.fragments;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.widget.PopupWindow;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import com.sendbird.uikit.R;
import com.sendbird.uikit.fragments.DialogView;
import com.sendbird.uikit.interfaces.OnItemClickListener;
import com.sendbird.uikit.log.Logger;
import com.sendbird.uikit.model.DialogListItem;

class MessageAnchorDialog {
    private static final Handler mainHandler = new Handler(Looper.getMainLooper());
    private final View anchorView;
    private final View parent;
    private DialogListItem[] items;
    private OnItemClickListener<Integer> itemClickListener;
    private final PopupWindow window;
    private final Context context;

    private MessageAnchorDialog(@NonNull View anchorView, @NonNull View parent, @NonNull DialogListItem[] items) {
        this.context = anchorView.getContext();
        this.anchorView = anchorView;
        this.parent = parent;
        this.items = items;
        int width = (int)this.context.getResources().getDimension(R.dimen.sb_dialog_width_212);
        this.window = new PopupWindow(width, -2);
    }

    public void show() {
        mainHandler.post(() -> {
            Logger.d(">> MessageAnchorDialog::show()");
            this.showAnchorList();
        });
    }

    public void dismiss() {
        mainHandler.post(() -> {
            try {
                Logger.d(">> MessageAnchorDialog::dismiss()");
                this.window.dismiss();
            }
            catch (Exception e) {
                Logger.d(e);
            }
        });
    }

    public boolean isShowing() {
        if (this.window == null) {
            return false;
        }
        return this.window.isShowing();
    }

    private void showAnchorList() {
        DialogView dialogView = new DialogView(this.context);
        dialogView.setItems(this.items, (view, position, key) -> {
            if (this.window != null) {
                this.window.dismiss();
            }
            if (this.itemClickListener != null) {
                this.itemClickListener.onItemClick(view, position, (Integer)key);
            }
        }, false, R.dimen.sb_size_16);
        dialogView.setBackgroundAnchor();
        this.window.setContentView((View)dialogView);
        this.window.setOutsideTouchable(true);
        this.window.setFocusable(true);
        this.window.setBackgroundDrawable(ContextCompat.getDrawable((Context)this.context, (int)17170445));
        int x = MessageAnchorDialog.getXoff(this.anchorView);
        int y = MessageAnchorDialog.getYoff(this.parent, this.anchorView, (View)dialogView);
        this.window.showAtLocation(this.anchorView, 0x800033, x, y);
    }

    private static int getXoff(View anchorView) {
        int[] loc = new int[2];
        anchorView.getLocationOnScreen(loc);
        return loc[0];
    }

    private static int getYoff(View parent, View anchorView, View contentView) {
        contentView.measure(0, 0);
        int contentViewMeasuredHeight = contentView.getMeasuredHeight();
        int[] loc = new int[2];
        anchorView.getLocationOnScreen(loc);
        if (MessageAnchorDialog.isDropDown(parent, anchorView)) {
            return loc[1] + anchorView.getMeasuredHeight();
        }
        return loc[1] - contentViewMeasuredHeight;
    }

    private static boolean isDropDown(View parent, View anchorView) {
        int[] loc = new int[2];
        int[] parentLoc = new int[2];
        anchorView.getLocationOnScreen(loc);
        parent.getLocationOnScreen(parentLoc);
        int parentHeight = parent.getMeasuredHeight();
        return parentHeight / 2 > loc[1] - parentLoc[1];
    }

    void setOnItemClickListener(OnItemClickListener<Integer> itemClickListener) {
        this.itemClickListener = itemClickListener;
    }

    void setOnDismissListener(PopupWindow.OnDismissListener dismissListener) {
        this.window.setOnDismissListener(dismissListener);
    }

    public static class Builder {
        private View anchorView;
        private View parent;
        private DialogListItem[] items;
        private OnItemClickListener<Integer> itemClickListener;
        private PopupWindow.OnDismissListener dismissListener;

        public Builder(View anchorView, View parent, DialogListItem[] items) {
            this.anchorView = anchorView;
            this.parent = parent;
            this.items = items;
        }

        public Builder setOnItemClickListener(OnItemClickListener<Integer> itemClickListener) {
            this.itemClickListener = itemClickListener;
            return this;
        }

        public Builder setOnDismissListener(PopupWindow.OnDismissListener dismissListener) {
            this.dismissListener = dismissListener;
            return this;
        }

        public MessageAnchorDialog build() {
            MessageAnchorDialog dialog = new MessageAnchorDialog(this.anchorView, this.parent, this.items);
            dialog.setOnItemClickListener(this.itemClickListener);
            dialog.setOnDismissListener(this.dismissListener);
            return dialog;
        }
    }
}

