/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.fragments;

import android.content.res.ColorStateList;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.databinding.DataBindingUtil;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.Member;
import com.sendbird.android.User;
import com.sendbird.uikit.R;
import com.sendbird.uikit.SendBirdUIKit;
import com.sendbird.uikit.activities.adapter.MemberListAdapter;
import com.sendbird.uikit.databinding.SbFragmentUserTypeListBinding;
import com.sendbird.uikit.fragments.BaseGroupChannelFragment;
import com.sendbird.uikit.interfaces.CustomMemberListQueryHandler;
import com.sendbird.uikit.interfaces.LoadingDialogHandler;
import com.sendbird.uikit.interfaces.OnItemClickListener;
import com.sendbird.uikit.interfaces.OnItemLongClickListener;
import com.sendbird.uikit.log.Logger;
import com.sendbird.uikit.utils.DialogUtils;
import com.sendbird.uikit.vm.UserTypeListViewModel;
import com.sendbird.uikit.vm.ViewModelFactory;
import com.sendbird.uikit.widgets.StatusFrameView;
import java.util.List;

public abstract class MemberTypeListFragment
extends BaseGroupChannelFragment
implements LoadingDialogHandler {
    private SbFragmentUserTypeListBinding binding;
    protected View.OnClickListener headerLeftButtonListener;
    protected View.OnClickListener headerRightButtonListener;
    protected MemberListAdapter adapter;
    protected OnItemClickListener<Member> itemClickListener;
    protected OnItemLongClickListener<Member> itemLongClickListener;
    protected OnItemClickListener<Member> actionItemClickListener;
    protected CustomMemberListQueryHandler<Member> customQueryHandler;
    protected OnItemClickListener<Member> profileClickListener;
    protected LoadingDialogHandler loadingDialogHandler;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Logger.i(">> MemberTypeListFragment::onCreate()", new Object[0]);
        Bundle args = this.getArguments();
        int themeResId = SendBirdUIKit.getDefaultThemeMode().getResId();
        if (args != null) {
            themeResId = args.getInt("KEY_THEME_RES_ID");
        }
        if (this.getActivity() != null) {
            this.getActivity().setTheme(themeResId);
        }
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.binding = (SbFragmentUserTypeListBinding)DataBindingUtil.inflate((LayoutInflater)inflater, (int)R.layout.sb_fragment_user_type_list, (ViewGroup)container, (boolean)false);
        return this.binding.getRoot();
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.binding.statusFrame.setStatus(StatusFrameView.Status.LOADING);
        this.initHeaderOnCreated();
    }

    @Override
    protected void onReadyFailure() {
        Logger.i(">> MemberTypeListFragment::onReadyFailure()", new Object[0]);
        this.setErrorFrame();
    }

    @Override
    protected void onConfigure() {
        if (this.loadingDialogHandler == null) {
            this.loadingDialogHandler = this;
        }
    }

    @Override
    protected void onDrawPage() {
        if (!this.containsExtra("KEY_CHANNEL_URL")) {
            this.setErrorFrame();
            return;
        }
        this.initHeaderOnReady();
        this.initMemberList(this.channel);
    }

    protected void setErrorFrame() {
        this.binding.statusFrame.setStatus(StatusFrameView.Status.CONNECTION_ERROR);
        this.binding.statusFrame.setOnActionEventListener(v -> {
            this.binding.statusFrame.setStatus(StatusFrameView.Status.LOADING);
            this.connect();
        });
    }

    private void initHeaderOnCreated() {
        Bundle args = this.getArguments();
        String headerTitle = this.getString(R.string.sb_text_header_member_list);
        boolean useHeader = false;
        boolean useHeaderLeftButton = true;
        boolean useHeaderRightButton = true;
        int headerLeftButtonIconResId = R.drawable.icon_arrow_left;
        int headerRightButtonIconResId = R.drawable.icon_plus;
        ColorStateList headerLeftButtonIconTint = null;
        ColorStateList headerRightButtonIconTint = null;
        int emptyIconId = R.drawable.icon_chat;
        ColorStateList emptyIconTint = null;
        int emptyTextId = R.string.sb_text_user_list_empty;
        if (args != null) {
            headerTitle = args.getString("KEY_HEADER_TITLE", headerTitle);
            useHeader = args.getBoolean("KEY_USE_HEADER", false);
            useHeaderLeftButton = args.getBoolean("KEY_USE_HEADER_LEFT_BUTTON", true);
            useHeaderRightButton = args.getBoolean("KEY_USE_HEADER_RIGHT_BUTTON", true);
            headerLeftButtonIconResId = args.getInt("KEY_HEADER_LEFT_BUTTON_ICON_RES_ID", R.drawable.icon_arrow_left);
            headerRightButtonIconResId = args.getInt("KEY_HEADER_RIGHT_BUTTON_ICON_RES_ID", R.drawable.icon_plus);
            headerLeftButtonIconTint = (ColorStateList)args.getParcelable("KEY_HEADER_LEFT_BUTTON_ICON_TINT");
            headerRightButtonIconTint = (ColorStateList)args.getParcelable("KEY_HEADER_RIGHT_BUTTON_ICON_TINT");
            emptyIconId = args.getInt("KEY_EMPTY_ICON_RES_ID", R.drawable.icon_chat);
            emptyIconTint = (ColorStateList)args.getParcelable("KEY_EMPTY_ICON_TINT");
            emptyTextId = args.getInt("KEY_EMPTY_TEXT_RES_ID", R.string.sb_text_user_list_empty);
        }
        this.binding.abvMemberList.setVisibility(useHeader ? 0 : 8);
        this.binding.abvMemberList.getTitleTextView().setText((CharSequence)headerTitle);
        this.binding.abvMemberList.setUseLeftImageButton(useHeaderLeftButton);
        this.binding.abvMemberList.setUseRightButton(useHeaderRightButton);
        this.binding.abvMemberList.setLeftImageButtonResource(headerLeftButtonIconResId);
        if (args != null && args.containsKey("KEY_HEADER_LEFT_BUTTON_ICON_RES_ID")) {
            this.binding.abvMemberList.setLeftImageButtonTint(headerLeftButtonIconTint);
        }
        this.binding.abvMemberList.setRightImageButtonResource(headerRightButtonIconResId);
        if (args != null && args.containsKey("KEY_HEADER_RIGHT_BUTTON_ICON_RES_ID")) {
            this.binding.abvMemberList.setRightImageButtonTint(headerRightButtonIconTint);
        }
        this.binding.abvMemberList.setLeftImageButtonClickListener(v -> this.finish());
        this.binding.statusFrame.setEmptyIcon(emptyIconId);
        this.binding.statusFrame.setEmptyText(emptyTextId);
        if (args != null && args.containsKey("KEY_EMPTY_ICON_RES_ID")) {
            this.binding.statusFrame.setIconTint(emptyIconTint);
        }
    }

    private void initHeaderOnReady() {
        if (this.headerLeftButtonListener != null) {
            this.binding.abvMemberList.setLeftImageButtonClickListener(this.headerLeftButtonListener);
        }
        if (this.headerRightButtonListener != null) {
            this.binding.abvMemberList.setRightImageButtonClickListener(this.headerRightButtonListener);
        }
    }

    private void initMemberList(@NonNull GroupChannel channel) {
        Bundle args;
        UserTypeListViewModel viewModel = (UserTypeListViewModel)new ViewModelProvider((ViewModelStoreOwner)this.getActivity(), (ViewModelProvider.Factory)new ViewModelFactory(channel, this.customQueryHandler)).get(channel.getUrl(), UserTypeListViewModel.class);
        this.getLifecycle().addObserver((LifecycleObserver)viewModel);
        if (this.adapter == null) {
            this.adapter = new MemberListAdapter();
        }
        boolean useUserProfile = (args = this.getArguments()) == null || args.getBoolean("KEY_USE_USER_PROFILE", SendBirdUIKit.shouldUseDefaultUserProfile());
        this.adapter.setOnItemClickListener(this.itemClickListener != null ? this.itemClickListener : this::onItemClicked);
        this.adapter.setOnItemLongClickListener(this.itemLongClickListener != null ? this.itemLongClickListener : this::onItemLongClicked);
        this.adapter.setOnActionItemClickListener(this.actionItemClickListener != null ? this.actionItemClickListener : this::onActionItemClicked);
        this.adapter.setOnProfileClickListener(this.profileClickListener != null ? this.profileClickListener : (useUserProfile ? this::onProfileClicked : null));
        this.binding.rvMemberList.setAdapter(this.adapter);
        this.binding.rvMemberList.setHasFixedSize(true);
        this.binding.rvMemberList.setPager(viewModel);
        this.binding.rvMemberList.setThreshold(5);
        viewModel.getStatusFrame().observe((LifecycleOwner)this, this.binding.statusFrame::setStatus);
        viewModel.getMemberList().observe((LifecycleOwner)this, members -> {
            Logger.dev("++ observing result members size : %s", members.size());
            this.adapter.setItems((List)members, channel.getMyRole());
        });
        viewModel.loadInitial();
    }

    protected void onItemClicked(View view, int position, Member member) {
    }

    protected void onItemLongClicked(View view, int position, Member member) {
    }

    protected void onActionItemClicked(View view, int position, Member member) {
    }

    protected void onProfileClicked(View view, int position, Member member) {
        if (this.getContext() == null || this.getFragmentManager() == null) {
            return;
        }
        DialogUtils.buildUserProfile(this.getContext(), (User)member, true, null, this.loadingDialogHandler).showSingle(this.getFragmentManager());
    }

    protected void setHeaderLeftButtonListener(View.OnClickListener listener) {
        this.headerLeftButtonListener = listener;
    }

    protected void setHeaderRightButtonListener(View.OnClickListener listener) {
        this.headerRightButtonListener = listener;
    }

    protected <T extends MemberListAdapter> void setMemberListAdapter(T adapter) {
        this.adapter = adapter;
    }

    protected void setItemClickListener(OnItemClickListener<Member> itemClickListener) {
        this.itemClickListener = itemClickListener;
    }

    protected void setItemLongClickListener(OnItemLongClickListener<Member> itemLongClickListener) {
        this.itemLongClickListener = itemLongClickListener;
    }

    protected void setActionItemClickListener(OnItemClickListener<Member> actionItemClickListener) {
        this.actionItemClickListener = actionItemClickListener;
    }

    void setCustomQueryHandler(CustomMemberListQueryHandler<Member> handler) {
        this.customQueryHandler = handler;
    }

    void setOnProfileClickListener(OnItemClickListener<Member> profileClickListener) {
        this.profileClickListener = profileClickListener;
    }

    void setLoadingDialogHandler(LoadingDialogHandler loadingDialogHandler) {
        this.loadingDialogHandler = loadingDialogHandler;
    }
}

