/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.fragments;

import android.content.Intent;
import android.content.res.ColorStateList;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import androidx.databinding.DataBindingUtil;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.GroupChannelParams;
import com.sendbird.android.Member;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.User;
import com.sendbird.uikit.R;
import com.sendbird.uikit.SendBirdUIKit;
import com.sendbird.uikit.activities.MemberListActivity;
import com.sendbird.uikit.activities.MessageSearchActivity;
import com.sendbird.uikit.activities.ModerationActivity;
import com.sendbird.uikit.consts.DialogEditTextParams;
import com.sendbird.uikit.databinding.SbFragmentChannelSettingsBinding;
import com.sendbird.uikit.fragments.BaseFragment;
import com.sendbird.uikit.fragments.PermissionFragment;
import com.sendbird.uikit.interfaces.CustomParamsHandler;
import com.sendbird.uikit.interfaces.LoadingDialogHandler;
import com.sendbird.uikit.interfaces.OnEditTextResultListener;
import com.sendbird.uikit.interfaces.OnMenuItemClickListener;
import com.sendbird.uikit.log.Logger;
import com.sendbird.uikit.model.DialogListItem;
import com.sendbird.uikit.model.ReadyStatus;
import com.sendbird.uikit.tasks.JobResultTask;
import com.sendbird.uikit.tasks.TaskQueue;
import com.sendbird.uikit.utils.DialogUtils;
import com.sendbird.uikit.utils.FileUtils;
import com.sendbird.uikit.utils.IntentUtils;
import com.sendbird.uikit.utils.TextUtils;
import com.sendbird.uikit.widgets.ChannelSettingsView;
import java.io.File;

public class ChannelSettingsFragment
extends BaseFragment
implements PermissionFragment.IPermissionHandler,
LoadingDialogHandler {
    private static final int CAPTURE_IMAGE_PERMISSIONS_REQUEST_CODE = 2001;
    private static final int PICK_IMAGE_PERMISSIONS_REQUEST_CODE = 2002;
    private final String[] REQUIRED_PERMISSIONS = new String[]{"android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.CAMERA"};
    private SbFragmentChannelSettingsBinding binding;
    private Uri mediaUri;
    private GroupChannel channel;
    private View.OnClickListener memberSettingClickListener;
    protected View.OnClickListener headerLeftButtonListener;
    protected OnMenuItemClickListener<ChannelSettingsView.ChannelSettingMenu, GroupChannel> menuItemClickListener;
    private LoadingDialogHandler loadingDialogHandler;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Logger.i(">> ChannelSettingsFragment::onCreate()", new Object[0]);
        Bundle args = this.getArguments();
        int themeResId = SendBirdUIKit.getDefaultThemeMode().getResId();
        if (args != null) {
            themeResId = args.getInt("KEY_THEME_RES_ID");
        }
        if (this.getActivity() != null) {
            this.getActivity().setTheme(themeResId);
        }
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.binding = (SbFragmentChannelSettingsBinding)DataBindingUtil.inflate((LayoutInflater)inflater, (int)R.layout.sb_fragment_channel_settings, (ViewGroup)container, (boolean)false);
        return this.binding.getRoot();
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.initHeaderOnCreated();
    }

    @Override
    public void onReady(User user, ReadyStatus status) {
        Logger.i(">> ChannelSettingsFragment::onReady( status : %s)", new Object[]{status});
        if (status == ReadyStatus.ERROR || !this.containsExtra("KEY_CHANNEL_URL")) {
            this.toastError(R.string.sb_text_error_get_channel);
            return;
        }
        this.initPage();
    }

    private void initPage() {
        String channelUrl = this.getStringExtra("KEY_CHANNEL_URL");
        if (TextUtils.isEmpty(channelUrl)) {
            this.toastError(R.string.sb_text_error_get_channel);
            this.finish();
            return;
        }
        GroupChannel.getChannel((String)channelUrl, (channel, e) -> {
            this.channel = channel;
            this.onConfigure();
            this.onDrawPage();
        });
    }

    protected void onConfigure() {
        Logger.i(">> ChannelSettingsFragment::doConfigure()", new Object[0]);
    }

    protected void onDrawPage() {
        Logger.i(">> ChannelSettingsFragment::onDrawPage()", new Object[0]);
        this.initHeaderOnReady(this.channel);
        this.initChannelSetting();
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        SendBird.setAutoBackgroundDetection((boolean)true);
    }

    public void onResume() {
        super.onResume();
        if (this.channel != null && this.binding != null) {
            this.binding.csvSettings.drawSettingsView(this.channel);
        }
    }

    @Override
    public String[] getPermissions(int requestCode) {
        return this.REQUIRED_PERMISSIONS;
    }

    @Override
    public void onPermissionGranted(int requestCode) {
        this.showMediaSelectDialog();
    }

    private void initHeaderOnCreated() {
        Bundle args = this.getArguments();
        String headerTitle = this.getString(R.string.sb_text_header_channel_settings);
        boolean useHeader = false;
        boolean useHeaderLeftButton = true;
        boolean useHeaderRightButton = true;
        int headerLeftButtonIconResId = R.drawable.icon_arrow_left;
        ColorStateList headerLeftButtonIconTint = null;
        if (args != null) {
            headerTitle = args.getString("KEY_HEADER_TITLE", this.getString(R.string.sb_text_header_channel_settings));
            useHeader = args.getBoolean("KEY_USE_HEADER", false);
            useHeaderLeftButton = args.getBoolean("KEY_USE_HEADER_LEFT_BUTTON", true);
            useHeaderRightButton = args.getBoolean("KEY_USE_HEADER_RIGHT_BUTTON", true);
            headerLeftButtonIconResId = args.getInt("KEY_HEADER_LEFT_BUTTON_ICON_RES_ID", R.drawable.icon_arrow_left);
            headerLeftButtonIconTint = (ColorStateList)args.getParcelable("KEY_HEADER_LEFT_BUTTON_ICON_TINT");
        }
        this.binding.abSettingsHeader.setVisibility(useHeader ? 0 : 8);
        this.binding.abSettingsHeader.getTitleTextView().setText((CharSequence)headerTitle);
        this.binding.abSettingsHeader.setUseLeftImageButton(useHeaderLeftButton);
        this.binding.abSettingsHeader.setUseRightButton(useHeaderRightButton);
        this.binding.abSettingsHeader.setLeftImageButtonResource(headerLeftButtonIconResId);
        if (args != null && args.containsKey("KEY_HEADER_LEFT_BUTTON_ICON_RES_ID")) {
            this.binding.abSettingsHeader.setLeftImageButtonTint(headerLeftButtonIconTint);
        }
        this.binding.abSettingsHeader.setLeftImageButtonClickListener(v -> this.finish());
    }

    private void initHeaderOnReady(GroupChannel channel) {
        if (this.headerLeftButtonListener != null) {
            this.binding.abSettingsHeader.setLeftImageButtonClickListener(this.headerLeftButtonListener);
        }
        if (channel.isBroadcast() && channel.getMyRole() != Member.Role.OPERATOR) {
            this.binding.abSettingsHeader.setRightTextButtonString("");
        } else {
            this.binding.abSettingsHeader.setRightTextButtonString(this.getString(R.string.sb_text_button_edit));
            this.binding.abSettingsHeader.setRightTextButtonClickListener(v -> {
                DialogListItem[] items = new DialogListItem[]{new DialogListItem(R.string.sb_text_channel_settings_change_channel_name), new DialogListItem(R.string.sb_text_channel_settings_change_channel_image)};
                if (this.getContext() == null || this.getFragmentManager() == null) {
                    return;
                }
                DialogUtils.buildItemsBottom(items, (view, p, key) -> {
                    if (key == R.string.sb_text_channel_settings_change_channel_name) {
                        if (this.getContext() == null || this.getFragmentManager() == null) {
                            return;
                        }
                        Logger.dev("change channel name");
                        OnEditTextResultListener listener = res -> {
                            GroupChannelParams params = new GroupChannelParams().setName(res);
                            this.updateGroupChannel(params);
                        };
                        DialogEditTextParams params = new DialogEditTextParams(this.getString(R.string.sb_text_channel_settings_change_channel_name_hint));
                        params.setEnableSingleLine(true);
                        DialogUtils.buildEditText(this.getString(R.string.sb_text_channel_settings_change_channel_name), (int)this.getResources().getDimension(R.dimen.sb_dialog_width_280), params, listener, this.getString(R.string.sb_text_button_save), null, this.getString(R.string.sb_text_button_cancel), null).showSingle(this.getFragmentManager());
                    } else if (key == R.string.sb_text_channel_settings_change_channel_image) {
                        Logger.dev("change channel image");
                        this.checkPermission(2002, this);
                    }
                }).showSingle(this.getFragmentManager());
            });
        }
    }

    private void initChannelSetting() {
        if (this.loadingDialogHandler == null) {
            this.loadingDialogHandler = this;
        }
        this.binding.csvSettings.setOnItemClickListener((v, position, menu) -> {
            Logger.d("OnSettingsItem clicked menu : " + (Object)menu);
            if (menu == ChannelSettingsView.ChannelSettingMenu.MEMBERS && this.memberSettingClickListener != null) {
                this.memberSettingClickListener.onClick(v);
                if (this.menuItemClickListener != null) {
                    this.menuItemClickListener.onMenuItemClicked(v, (ChannelSettingsView.ChannelSettingMenu)((Object)menu), this.channel);
                }
                return;
            }
            if (this.menuItemClickListener != null && this.menuItemClickListener.onMenuItemClicked(v, (ChannelSettingsView.ChannelSettingMenu)((Object)menu), this.channel)) {
                return;
            }
            switch (menu) {
                case MODERATIONS: {
                    this.startActivity(ModerationActivity.newIntent(this.getContext(), this.channel.getUrl()));
                    break;
                }
                case NOTIFICATIONS: {
                    this.loadingDialogHandler.shouldShowLoadingDialog();
                    GroupChannel.PushTriggerOption option = this.channel.getMyPushTriggerOption() == GroupChannel.PushTriggerOption.ALL ? GroupChannel.PushTriggerOption.OFF : GroupChannel.PushTriggerOption.ALL;
                    this.channel.setMyPushTriggerOption(option, e -> {
                        this.loadingDialogHandler.shouldDismissLoadingDialog();
                        this.binding.csvSettings.drawSettingsView(this.channel);
                        if (e != null) {
                            Logger.e((Throwable)e);
                            if (option == GroupChannel.PushTriggerOption.ALL) {
                                this.toastError(R.string.sb_text_error_push_notification_on);
                            } else {
                                this.toastError(R.string.sb_text_error_push_notification_off);
                            }
                            return;
                        }
                        Logger.i("++ push notifications : %s", option);
                    });
                    break;
                }
                case MEMBERS: {
                    Logger.dev("members");
                    Logger.i("++ members", new Object[0]);
                    this.startActivity(MemberListActivity.newIntent(this.getContext(), this.channel.getUrl()));
                    break;
                }
                case LEAVE_CHANNEL: {
                    this.leaveChannel();
                    break;
                }
                case SEARCH_IN_CHANNEL: {
                    Logger.dev("call message search");
                    Logger.i("++ call message search", new Object[0]);
                    this.startActivity(MessageSearchActivity.newIntent(this.getContext(), this.channel.getUrl()));
                }
            }
        });
        this.binding.csvSettings.drawSettingsView(this.channel);
    }

    private void showMediaSelectDialog() {
        if (this.getContext() == null || this.getFragmentManager() == null) {
            return;
        }
        DialogListItem[] items = new DialogListItem[]{new DialogListItem(R.string.sb_text_channel_settings_change_channel_image_camera), new DialogListItem(R.string.sb_text_channel_settings_change_channel_image_gallery)};
        DialogUtils.buildItems(this.getString(R.string.sb_text_channel_settings_change_channel_image), (int)this.getResources().getDimension(R.dimen.sb_dialog_width_280), items, (v, p, key) -> {
            try {
                SendBird.setAutoBackgroundDetection((boolean)false);
                if (key == R.string.sb_text_channel_settings_change_channel_image_camera) {
                    this.takeCamera();
                } else if (key == R.string.sb_text_channel_settings_change_channel_image_gallery) {
                    this.pickImage();
                }
            }
            catch (Exception e) {
                Logger.e(e);
                this.toastError(R.string.sb_text_error_open_camera);
            }
        }).showSingle(this.getFragmentManager());
    }

    private void takeCamera() {
        this.mediaUri = FileUtils.createPictureImageUri(this.getContext());
        Intent intent = IntentUtils.getCameraIntent(this.getContext(), this.mediaUri);
        if (IntentUtils.hasIntent(this.getContext(), intent)) {
            this.startActivityForResult(intent, 2001);
        }
    }

    private void pickImage() {
        Intent intent = IntentUtils.getGalleryIntent();
        this.startActivityForResult(intent, 2002);
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        SendBird.setAutoBackgroundDetection((boolean)true);
        if (resultCode == -1) {
            switch (requestCode) {
                case 2001: {
                    break;
                }
                case 2002: {
                    this.mediaUri = data.getData();
                }
            }
            if (this.mediaUri != null && this.channel != null) {
                TaskQueue.addTask(new JobResultTask<File>(){

                    @Override
                    public File call() {
                        return FileUtils.uriToFile(ChannelSettingsFragment.this.getContext().getApplicationContext(), ChannelSettingsFragment.this.mediaUri);
                    }

                    @Override
                    public void onResultForUiThread(File file, SendBirdException e) {
                        if (e != null) {
                            Logger.w((Throwable)e);
                            return;
                        }
                        GroupChannelParams params = new GroupChannelParams().setCoverImage(file);
                        ChannelSettingsFragment.this.toastSuccess(R.string.sb_text_toast_success_start_upload_file);
                        ChannelSettingsFragment.this.updateGroupChannel(params);
                    }
                });
            }
        }
    }

    protected void onBeforeUpdateGroupChannel(@NonNull GroupChannelParams params) {
    }

    protected void updateGroupChannel(@NonNull GroupChannelParams params) {
        if (this.channel != null) {
            CustomParamsHandler cutsomHandler = SendBirdUIKit.getCustomParamsHandler();
            if (cutsomHandler != null) {
                cutsomHandler.onBeforeUpdateGroupChannel(params);
            }
            this.onBeforeUpdateGroupChannel(params);
            this.channel.updateChannel(params, (updatedChannel, e) -> {
                if (e != null) {
                    Logger.e((Throwable)e);
                    this.toastError(R.string.sb_text_error_update_channel);
                    return;
                }
                Logger.i("++ updated channel name : %s", updatedChannel.getName());
                if (this.isActive()) {
                    this.binding.csvSettings.drawSettingsView(updatedChannel);
                }
            });
        }
    }

    protected void leaveChannel() {
        if (this.channel != null) {
            this.loadingDialogHandler.shouldShowLoadingDialog();
            this.channel.leave(e -> {
                this.loadingDialogHandler.shouldDismissLoadingDialog();
                if (e != null) {
                    Logger.e((Throwable)e);
                    this.toastError(R.string.sb_text_error_leave_channel);
                    return;
                }
                Logger.i("++ leave channel", new Object[0]);
                this.finish();
            });
        }
    }

    protected void setHeaderLeftButtonListener(View.OnClickListener listener) {
        this.headerLeftButtonListener = listener;
    }

    @Deprecated
    private void setMemberSettingClickListener(View.OnClickListener listener) {
        this.memberSettingClickListener = listener;
    }

    protected void setOnMenuItemClickListener(OnMenuItemClickListener<ChannelSettingsView.ChannelSettingMenu, GroupChannel> listener) {
        this.menuItemClickListener = listener;
    }

    private void setLoadingDialogHandler(LoadingDialogHandler loadingDialogHandler) {
        this.loadingDialogHandler = loadingDialogHandler;
    }

    @Override
    public boolean shouldShowLoadingDialog() {
        this.showWaitingDialog();
        return true;
    }

    @Override
    public void shouldDismissLoadingDialog() {
        this.dismissWaitingDialog();
    }

    public static class Builder {
        private final Bundle bundle = new Bundle();
        private ChannelSettingsFragment customFragment;
        private View.OnClickListener headerLeftButtonListener;
        private View.OnClickListener memberSettingClickListener;
        private OnMenuItemClickListener<ChannelSettingsView.ChannelSettingMenu, GroupChannel> menuItemClickListener;
        private LoadingDialogHandler loadingDialogHandler;

        public Builder(@NonNull String channelUrl) {
            this(channelUrl, SendBirdUIKit.getDefaultThemeMode());
        }

        public Builder(@NonNull String channelUrl, SendBirdUIKit.ThemeMode themeMode) {
            this.bundle.putInt("KEY_THEME_RES_ID", themeMode.getResId());
            this.bundle.putString("KEY_CHANNEL_URL", channelUrl);
        }

        public Builder(@NonNull String channelUrl, @StyleRes int customThemeResId) {
            this.bundle.putInt("KEY_THEME_RES_ID", customThemeResId);
            this.bundle.putString("KEY_CHANNEL_URL", channelUrl);
        }

        public <T extends ChannelSettingsFragment> Builder setCustomChannelSettingsFragment(T fragment) {
            this.customFragment = fragment;
            return this;
        }

        public Builder setHeaderTitle(String title) {
            this.bundle.putString("KEY_HEADER_TITLE", title);
            return this;
        }

        public Builder setUseHeader(boolean useHeader) {
            this.bundle.putBoolean("KEY_USE_HEADER", useHeader);
            return this;
        }

        public Builder setUseHeaderRightButton(boolean useHeaderRightButton) {
            this.bundle.putBoolean("KEY_USE_HEADER_RIGHT_BUTTON", useHeaderRightButton);
            return this;
        }

        public Builder setUseHeaderLeftButton(boolean useHeaderLeftButton) {
            this.bundle.putBoolean("KEY_USE_HEADER_LEFT_BUTTON", useHeaderLeftButton);
            return this;
        }

        public Builder setHeaderLeftButtonIconResId(@DrawableRes int resId) {
            return this.setHeaderLeftButtonIcon(resId, null);
        }

        public Builder setHeaderLeftButtonIcon(@DrawableRes int resId, @Nullable ColorStateList tint) {
            this.bundle.putInt("KEY_HEADER_LEFT_BUTTON_ICON_RES_ID", resId);
            this.bundle.putParcelable("KEY_HEADER_LEFT_BUTTON_ICON_TINT", (Parcelable)tint);
            return this;
        }

        public Builder setHeaderLeftButtonListener(View.OnClickListener listener) {
            this.headerLeftButtonListener = listener;
            return this;
        }

        @Deprecated
        public Builder setMemberSettingClickListener(View.OnClickListener listener) {
            this.memberSettingClickListener = listener;
            return this;
        }

        public Builder setOnSettingMenuClickListener(OnMenuItemClickListener<ChannelSettingsView.ChannelSettingMenu, GroupChannel> listener) {
            this.menuItemClickListener = listener;
            return this;
        }

        public Builder setLoadingDialogHandler(LoadingDialogHandler loadingDialogHandler) {
            this.loadingDialogHandler = loadingDialogHandler;
            return this;
        }

        public ChannelSettingsFragment build() {
            ChannelSettingsFragment fragment = this.customFragment != null ? this.customFragment : new ChannelSettingsFragment();
            fragment.setArguments(this.bundle);
            fragment.setHeaderLeftButtonListener(this.headerLeftButtonListener);
            fragment.setMemberSettingClickListener(this.memberSettingClickListener);
            fragment.setOnMenuItemClickListener(this.menuItemClickListener);
            fragment.setLoadingDialogHandler(this.loadingDialogHandler);
            return fragment;
        }
    }
}

