/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.activities.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.databinding.DataBindingUtil;
import com.sendbird.android.Emoji;
import com.sendbird.android.Reaction;
import com.sendbird.android.SendBird;
import com.sendbird.uikit.R;
import com.sendbird.uikit.activities.adapter.BaseAdapter;
import com.sendbird.uikit.activities.viewholder.BaseViewHolder;
import com.sendbird.uikit.activities.viewholder.EmojiMoreViewHolder;
import com.sendbird.uikit.activities.viewholder.EmojiViewHolder;
import com.sendbird.uikit.databinding.SbViewEmojiBinding;
import com.sendbird.uikit.interfaces.OnItemClickListener;
import com.sendbird.uikit.widgets.EmojiView;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EmojiListAdapter
extends BaseAdapter<Emoji, BaseViewHolder<Emoji>> {
    private static final int VIEW_EMOJI = 0;
    private static final int VIEW_EMOJI_MORE = 1;
    private List<Emoji> emojiList;
    private Map<String, List<String>> reactionUserMap = new HashMap<String, List<String>>();
    private OnItemClickListener<String> emojiClickListener;
    private View.OnClickListener moreButtonClickListener;
    private boolean showMoreButton;

    public EmojiListAdapter(List<Emoji> emojiList, List<Reaction> reactionList, boolean showMoreButton) {
        this.emojiList = emojiList;
        if (reactionList != null) {
            for (Reaction reaction : reactionList) {
                this.reactionUserMap.put(reaction.getKey(), reaction.getUserIds());
            }
        }
        this.showMoreButton = showMoreButton;
    }

    @NonNull
    public BaseViewHolder<Emoji> onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
        if (viewType == 1) {
            return new EmojiMoreViewHolder(new EmojiView(parent.getContext()));
        }
        return new EmojiViewHolder((SbViewEmojiBinding)DataBindingUtil.inflate((LayoutInflater)inflater, (int)R.layout.sb_view_emoji, (ViewGroup)parent, (boolean)false));
    }

    public void onBindViewHolder(@NonNull BaseViewHolder<Emoji> holder, int position) {
        Emoji current = this.getItem(position);
        int type = this.getItemViewType(position);
        if (type == 1) {
            holder.itemView.setOnClickListener(v -> {
                if (this.moreButtonClickListener != null) {
                    this.moreButtonClickListener.onClick(v);
                }
            });
        } else {
            if (this.reactionUserMap != null && !this.reactionUserMap.isEmpty() && current != null) {
                List<String> userIds = this.reactionUserMap.get(current.getKey());
                if (userIds != null && SendBird.getCurrentUser() != null && userIds.contains(SendBird.getCurrentUser().getUserId())) {
                    holder.itemView.setSelected(true);
                } else {
                    holder.itemView.setSelected(false);
                }
            }
            holder.itemView.setOnClickListener(v -> {
                Emoji emoji = this.getItem(holder.getAdapterPosition());
                if (this.emojiClickListener != null && emoji != null) {
                    this.emojiClickListener.onItemClick(v, holder.getAdapterPosition(), emoji.getKey());
                }
            });
        }
        holder.bind(current);
    }

    public int getItemCount() {
        if (this.emojiList == null) {
            return 0;
        }
        if (this.showMoreButton) {
            return this.emojiList.size() + 1;
        }
        return this.emojiList.size();
    }

    @Override
    public Emoji getItem(int position) {
        if (this.emojiList == null || position >= this.emojiList.size()) {
            return null;
        }
        return this.emojiList.get(position);
    }

    @Override
    public List<Emoji> getItems() {
        return this.emojiList;
    }

    public int getItemViewType(int position) {
        if (this.showMoreButton && position >= this.emojiList.size()) {
            return 1;
        }
        return 0;
    }

    public void setEmojiClickListener(@Nullable OnItemClickListener<String> emojiClickListener) {
        this.emojiClickListener = emojiClickListener;
    }

    public void setMoreButtonClickListener(@Nullable View.OnClickListener moreButtonClickListener) {
        this.moreButtonClickListener = moreButtonClickListener;
    }
}

