/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit;

import android.content.Context;
import android.content.res.ColorStateList;
import android.util.Pair;
import androidx.annotation.ColorRes;
import androidx.annotation.NonNull;
import androidx.annotation.StyleRes;
import androidx.appcompat.content.res.AppCompatResources;
import com.sendbird.android.AppInfo;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.User;
import com.sendbird.uikit.R;
import com.sendbird.uikit.adapter.SendBirdUIKitAdapter;
import com.sendbird.uikit.interfaces.CustomParamsHandler;
import com.sendbird.uikit.interfaces.CustomUserListQueryHandler;
import com.sendbird.uikit.interfaces.UserInfo;
import com.sendbird.uikit.log.Logger;
import com.sendbird.uikit.model.EmojiManager;
import com.sendbird.uikit.tasks.JobResultTask;
import com.sendbird.uikit.tasks.TaskQueue;
import com.sendbird.uikit.utils.FileUtils;
import com.sendbird.uikit.utils.TextUtils;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;

public class SendBirdUIKit {
    private static volatile SendBirdUIKitAdapter adapter;
    private static final int DEFAULT_RESIZING_WIDTH_SIZE = 1080;
    private static final int DEFAULT_RESIZING_HEIGHT_SIZE = 1920;
    private static volatile ThemeMode defaultThemeMode;
    private static volatile boolean useDefaultUserProfile;
    private static volatile boolean useCompression;
    private static CustomUserListQueryHandler customUserListQueryHandler;
    private static CustomParamsHandler customParamsHandler;
    private static int compressQuality;
    private static Pair<Integer, Integer> resizingSize;

    static void clearAll() {
        customUserListQueryHandler = null;
        defaultThemeMode = ThemeMode.Light;
    }

    public static synchronized void init(@NonNull SendBirdUIKitAdapter adapter, @NonNull Context context) {
        SendBirdUIKit.adapter = adapter;
        SendBirdUIKit.setResizingSize((Pair<Integer, Integer>)new Pair((Object)1080, (Object)1920));
        SendBird.init((String)adapter.getAppId(), (Context)context);
        FileUtils.removeDeletableDir(context.getApplicationContext());
        try {
            SendBird.addExtension((String)"sb_uikit", (String)"2.1.1");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setLogLevel(@NonNull LogLevel level) {
        Logger.setLogLevel(level.getLevel());
    }

    public static ThemeMode getDefaultThemeMode() {
        return defaultThemeMode;
    }

    public static void setDefaultThemeMode(ThemeMode themeMode) {
        defaultThemeMode = themeMode;
    }

    public static boolean isDarkMode() {
        return defaultThemeMode == ThemeMode.Dark;
    }

    public static SendBirdUIKitAdapter getAdapter() {
        return adapter;
    }

    public static CustomUserListQueryHandler getCustomUserListQueryHandler() {
        return customUserListQueryHandler;
    }

    public static CustomParamsHandler getCustomParamsHandler() {
        return customParamsHandler;
    }

    public static boolean shouldUseDefaultUserProfile() {
        return useDefaultUserProfile;
    }

    public static void setUseDefaultUserProfile(boolean useDefaultUserProfile) {
        SendBirdUIKit.useDefaultUserProfile = useDefaultUserProfile;
    }

    public static void connect(final SendBird.ConnectHandler handler) {
        TaskQueue.addTask(new JobResultTask<User>(){

            @Override
            public User call() throws Exception {
                String profileUrl;
                String nickname;
                User user = SendBirdUIKit.connect();
                UserInfo userInfo = adapter.getUserInfo();
                String userId = userInfo.getUserId();
                String string = nickname = TextUtils.isEmpty(userInfo.getNickname()) ? user.getNickname() : userInfo.getNickname();
                if (TextUtils.isEmpty(nickname)) {
                    nickname = userId;
                }
                String string2 = profileUrl = TextUtils.isEmpty(userInfo.getProfileUrl()) ? user.getProfileUrl() : userInfo.getProfileUrl();
                if (!nickname.equals(user.getNickname()) || !TextUtils.isEmpty(profileUrl) && !profileUrl.equals(user.getProfileUrl())) {
                    SendBirdUIKit.updateUserInfoBlocking(nickname, profileUrl);
                }
                Logger.dev("++ user nickname = %s, profileUrl = %s", user.getNickname(), user.getProfileUrl());
                AppInfo appInfo = SendBird.getAppInfo();
                if (appInfo != null && appInfo.useReaction() && appInfo.needUpdateEmoji(EmojiManager.getInstance().getEmojiHash())) {
                    SendBirdUIKit.updateEmojiList();
                }
                return user;
            }

            @Override
            public void onResultForUiThread(User user, SendBirdException e) {
                if (handler != null) {
                    handler.onConnected((User)(e == null ? user : null), e);
                }
            }
        });
    }

    private static User connect() throws InterruptedException, SendBirdException {
        AtomicReference result = new AtomicReference();
        AtomicReference error = new AtomicReference();
        CountDownLatch latch = new CountDownLatch(1);
        UserInfo userInfo = adapter.getUserInfo();
        String userId = userInfo.getUserId();
        String accessToken = adapter.getAccessToken();
        SendBird.connect((String)userId, (String)accessToken, (user, e) -> {
            if (e != null) {
                error.set(e);
                latch.countDown();
                return;
            }
            result.set(user);
            latch.countDown();
        });
        latch.await();
        if (error.get() != null) {
            throw (SendBirdException)error.get();
        }
        return (User)result.get();
    }

    public static void disconnect(SendBird.DisconnectHandler handler) {
        SendBird.disconnect(() -> {
            SendBirdUIKit.clearAll();
            if (handler != null) {
                handler.onDisconnected();
            }
        });
    }

    public static void updateUserInfo(String nickname, String profileUrl, SendBird.UserInfoUpdateHandler handler) {
        SendBird.updateCurrentUserInfo((String)nickname, (String)profileUrl, (SendBird.UserInfoUpdateHandler)handler);
    }

    private static void updateUserInfoBlocking(String nickname, String profileUrl) throws SendBirdException, InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference error = new AtomicReference();
        SendBird.updateCurrentUserInfo((String)nickname, (String)profileUrl, e -> {
            if (e != null) {
                error.set(e);
            }
            latch.countDown();
        });
        latch.await();
        if (error.get() != null) {
            throw (SendBirdException)error.get();
        }
    }

    public static void setCustomUserListQueryHandler(CustomUserListQueryHandler handler) {
        customUserListQueryHandler = handler;
    }

    public static void setCustomParamsHandler(CustomParamsHandler handler) {
        customParamsHandler = handler;
    }

    private static void updateEmojiList() {
        SendBird.getAllEmoji((emojiContainer, e) -> {
            if (e != null) {
                Logger.e((Throwable)e);
            } else {
                EmojiManager.getInstance().upsertEmojiContainer(emojiContainer);
            }
        });
    }

    public static void setUseImageCompression(boolean useCompression) {
        SendBirdUIKit.useCompression = useCompression;
    }

    public static boolean shouldUseImageCompression() {
        return useCompression;
    }

    public static void setCompressQuality(int compressQuality) {
        SendBirdUIKit.compressQuality = compressQuality;
    }

    public static int getCompressQuality() {
        return compressQuality;
    }

    public static void setResizingSize(@NonNull Pair<Integer, Integer> resizingSize) {
        SendBirdUIKit.resizingSize = resizingSize;
    }

    public static Pair<Integer, Integer> getResizingSize() {
        return resizingSize;
    }

    static {
        defaultThemeMode = ThemeMode.Light;
        useDefaultUserProfile = false;
        useCompression = false;
        compressQuality = 100;
    }

    public static enum ThemeMode {
        Light(R.style.SendBird, R.color.primary_300, R.color.secondary_300, R.color.onlight_03),
        Dark(R.style.SendBird_Dark, R.color.primary_200, R.color.secondary_200, R.color.ondark_03);

        @StyleRes
        int resId;
        @ColorRes
        int primaryTintColorResId;
        @ColorRes
        int secondaryTintColorResId;
        @ColorRes
        int monoTintColorResId;

        private ThemeMode(@ColorRes int resId, @ColorRes int primaryTintColorResId, int secondaryTintColorResId, int monoTintColorResId) {
            this.resId = resId;
            this.primaryTintColorResId = primaryTintColorResId;
            this.secondaryTintColorResId = secondaryTintColorResId;
            this.monoTintColorResId = monoTintColorResId;
        }

        @StyleRes
        public int getResId() {
            return this.resId;
        }

        @ColorRes
        public int getPrimaryTintResId() {
            return this.primaryTintColorResId;
        }

        @ColorRes
        public int getSecondaryTintResId() {
            return this.secondaryTintColorResId;
        }

        @ColorRes
        public int getMonoTintResId() {
            return this.monoTintColorResId;
        }

        public ColorStateList getPrimaryTintColorStateList(@NonNull Context context) {
            return AppCompatResources.getColorStateList((Context)context, (int)this.primaryTintColorResId);
        }

        public ColorStateList getSecondaryTintColorStateList(@NonNull Context context) {
            return AppCompatResources.getColorStateList((Context)context, (int)this.secondaryTintColorResId);
        }

        public ColorStateList getMonoTintColorStateList(@NonNull Context context) {
            return AppCompatResources.getColorStateList((Context)context, (int)this.monoTintColorResId);
        }
    }

    public static enum LogLevel {
        ALL(2),
        INFO(4),
        WARN(5),
        ERROR(6);

        int level;

        private LogLevel(int level) {
            this.level = level;
        }

        int getLevel() {
            return this.level;
        }
    }
}

