/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.widgets;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.core.content.ContextCompat;
import com.sendbird.uikit.R;
import com.sendbird.uikit.databinding.SbViewSearchBarBinding;
import com.sendbird.uikit.interfaces.OnInputTextChangedListener;
import com.sendbird.uikit.interfaces.OnSearchEventListener;
import com.sendbird.uikit.log.Logger;
import com.sendbird.uikit.utils.DrawableUtils;
import java.lang.reflect.Field;

public class SearchBarView
extends FrameLayout {
    private SbViewSearchBarBinding binding;
    private OnSearchEventListener searchEventListener;
    private OnInputTextChangedListener textChangedListener;

    public SearchBarView(Context context) {
        this(context, null);
    }

    public SearchBarView(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.sb_search_bar_style);
    }

    public SearchBarView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs, defStyle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs, int defStyle) {
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.SearchBar, defStyle, 0);
        try {
            this.binding = SbViewSearchBarBinding.inflate(LayoutInflater.from((Context)this.getContext()));
            this.addView(this.binding.getRoot(), -1, -2);
            int itemBackground = a.getResourceId(R.styleable.SearchBar_sb_search_bar_background, R.color.background_50);
            int dividerColor = a.getResourceId(R.styleable.SearchBar_sb_search_divider_color, R.color.onlight_04);
            int inputBackground = a.getResourceId(R.styleable.SearchBar_sb_search_bar_text_input_background, R.drawable.sb_shape_search_background);
            int textAppearance = a.getResourceId(R.styleable.SearchBar_sb_search_bar_text_appearance, R.style.SendbirdBody3OnLight01);
            int hintText = a.getResourceId(R.styleable.SearchBar_sb_search_bar_hint_text, R.string.sb_text_button_search);
            int hintTextColor = a.getResourceId(R.styleable.SearchBar_sb_search_bar_hint_text_color, R.color.onlight_03);
            int clearIcon = a.getResourceId(R.styleable.SearchBar_sb_search_bar_clear_icon, R.drawable.icon_remove);
            int clearIconTintColor = a.getResourceId(R.styleable.SearchBar_sb_search_bar_clear_icon_tint_color, R.color.onlight_03);
            int searchButtonText = a.getResourceId(R.styleable.SearchBar_sb_search_bar_search_text, R.string.sb_text_button_search);
            int searchTextAppearance = a.getResourceId(R.styleable.SearchBar_sb_search_bar_search_text_appearance, R.style.SendbirdButtonPrimary300);
            int searchTextColor = a.getResourceId(R.styleable.SearchBar_sb_search_bar_search_text_color, R.color.sb_button_uncontained_text_color_light);
            int searchTextBackground = a.getResourceId(R.styleable.SearchBar_sb_search_bar_search_text_background, R.drawable.sb_button_uncontained_background_light);
            int cursorDrawable = a.getResourceId(R.styleable.SearchBar_sb_search_bar_cursor_drawable, R.drawable.sb_message_input_cursor_light);
            int searchIcon = a.getResourceId(R.styleable.SearchBar_sb_search_bar_search_icon, R.drawable.icon_search);
            int searchIconTintColor = a.getResourceId(R.styleable.SearchBar_sb_search_bar_search_icon_tint_color, R.color.onlight_03);
            this.binding.searchBar.setBackgroundResource(itemBackground);
            this.binding.ivDivider.setBackgroundResource(dividerColor);
            this.binding.searchEditBox.setBackgroundResource(inputBackground);
            this.binding.etInputText.setTextAppearance(context, textAppearance);
            this.binding.etInputText.setHint(hintText);
            this.binding.etInputText.setHintTextColor(ContextCompat.getColor((Context)context, (int)hintTextColor));
            this.binding.ivClear.setImageDrawable(DrawableUtils.setTintList(context, clearIcon, clearIconTintColor));
            this.binding.tvSearch.setText(searchButtonText);
            this.binding.tvSearch.setTextAppearance(context, searchTextAppearance);
            this.binding.tvSearch.setTextColor(AppCompatResources.getColorStateList((Context)context, (int)searchTextColor));
            this.binding.tvSearch.setBackgroundResource(searchTextBackground);
            this.binding.ivSearchIcon.setImageDrawable(DrawableUtils.setTintList(context, searchIcon, searchIconTintColor));
            if (Build.VERSION.SDK_INT >= 29) {
                this.binding.etInputText.setTextCursorDrawable(cursorDrawable);
            } else {
                Field f = TextView.class.getDeclaredField("mCursorDrawableRes");
                f.setAccessible(true);
                f.set(this.binding.etInputText, cursorDrawable);
            }
            this.binding.etInputText.setOnEditorActionListener((v, actionId, event) -> {
                if (actionId == 3) {
                    if (this.searchEventListener != null) {
                        this.searchEventListener.onSearchRequested(this.binding.etInputText.getText().toString());
                    }
                    return true;
                }
                return false;
            });
            this.binding.etInputText.addTextChangedListener(new TextWatcher(){

                public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                }

                public void onTextChanged(CharSequence s, int start, int before, int count) {
                    ((SearchBarView)SearchBarView.this).binding.ivClear.setVisibility(count > 0 ? 0 : 8);
                    if (SearchBarView.this.textChangedListener != null) {
                        SearchBarView.this.textChangedListener.onInputTextChanged(s, start, before, count);
                    }
                }

                public void afterTextChanged(Editable s) {
                }
            });
            this.binding.ivClear.setOnClickListener(v -> this.binding.etInputText.setText((CharSequence)""));
            this.binding.tvSearch.setOnClickListener(v -> {
                if (this.searchEventListener != null) {
                    this.searchEventListener.onSearchRequested(this.binding.etInputText.getText().toString());
                }
            });
        }
        catch (Exception e) {
            Logger.e(e);
        }
        finally {
            a.recycle();
        }
    }

    public View getLayout() {
        return this;
    }

    public SbViewSearchBarBinding getBinding() {
        return this.binding;
    }

    public TextView getSearchButton() {
        return this.binding.tvSearch;
    }

    public void setText(CharSequence text) {
        this.binding.etInputText.setText(text);
    }

    public void setHintText(CharSequence hint) {
        this.binding.etInputText.setHint(hint);
    }

    public void setOnSearchEventListener(OnSearchEventListener listener) {
        this.searchEventListener = listener;
    }

    public void setOnInputTextChangedListener(OnInputTextChangedListener textChangedListener) {
        this.textChangedListener = textChangedListener;
    }
}

