/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.widgets;

import android.content.Context;
import android.content.res.TypedArray;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.TextAppearanceSpan;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;
import androidx.databinding.BindingAdapter;
import com.sendbird.android.SendBird;
import com.sendbird.android.User;
import com.sendbird.uikit.R;
import com.sendbird.uikit.SendBirdUIKit;
import com.sendbird.uikit.databinding.SbViewEmojiReactionUserComponentBinding;
import java.util.ArrayList;

public class EmoijReactionUserView
extends FrameLayout {
    private SbViewEmojiReactionUserComponentBinding binding;

    public EmoijReactionUserView(Context context) {
        this(context, null);
    }

    public EmoijReactionUserView(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.sb_emoji_reaction_style);
    }

    public EmoijReactionUserView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs, defStyle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs, int defStyle) {
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.EmojiReactionUser, defStyle, 0);
        try {
            this.binding = SbViewEmojiReactionUserComponentBinding.inflate(LayoutInflater.from((Context)this.getContext()));
            this.addView(this.binding.getRoot(), -1, -2);
            int nicknameAppearance = a.getResourceId(R.styleable.EmojiReactionUser_sb_emoji_reaction_user_nickname_appearance, R.style.SendbirdSubtitle2OnLight01);
            this.binding.tvNickname.setTextAppearance(context, nicknameAppearance);
            this.binding.tvNickname.setEllipsize(TextUtils.TruncateAt.END);
            this.binding.tvNickname.setMaxLines(1);
        }
        finally {
            a.recycle();
        }
    }

    public View getLayout() {
        return this;
    }

    public SbViewEmojiReactionUserComponentBinding getBinding() {
        return this.binding;
    }

    public void drawUser(User user) {
        Context context = this.binding.ivUserCover.getContext();
        String nickname = context.getString(R.string.sb_text_channel_list_title_unknown);
        ArrayList<String> urls = new ArrayList<String>();
        if (user != null) {
            nickname = TextUtils.isEmpty((CharSequence)user.getNickname()) ? context.getString(R.string.sb_text_channel_list_title_unknown) : user.getNickname();
            urls.add(user.getProfileUrl());
        }
        this.binding.tvNickname.setText((CharSequence)nickname);
        this.binding.ivUserCover.loadImages(urls);
        if (user != null && user.getUserId().equals(SendBird.getCurrentUser().getUserId())) {
            String meBadge = context.getResources().getString(R.string.sb_text_user_list_badge_me);
            SpannableString spannable = new SpannableString((CharSequence)meBadge);
            int badgeAppearance = SendBirdUIKit.isDarkMode() ? R.style.SendbirdSubtitle2OnDark02 : R.style.SendbirdSubtitle2OnLight02;
            spannable.setSpan((Object)new TextAppearanceSpan(context, badgeAppearance), 0, meBadge.length(), 33);
            this.binding.tvNickname.append((CharSequence)spannable);
        }
    }

    @BindingAdapter(value={"user"})
    public static void drawUser(EmoijReactionUserView userView, User user) {
        userView.drawUser(user);
    }
}

