/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.widgets;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.appcompat.content.res.AppCompatResources;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.sendbird.uikit.R;
import com.sendbird.uikit.SendBirdUIKit;
import com.sendbird.uikit.utils.DrawableUtils;
import com.sendbird.uikit.utils.TextUtils;
import com.sendbird.uikit.widgets.ImageWaffleView;
import java.util.List;

public class ChannelCoverView
extends ImageWaffleView {
    private int defaultImageResId;

    public ChannelCoverView(Context context) {
        super(context);
    }

    public ChannelCoverView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public ChannelCoverView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void setDefaultImageResId(int defaultImageResId) {
        this.defaultImageResId = defaultImageResId;
    }

    public void loadImage(String url) {
        ImageView imageView = this.prepareSingleImageView();
        if (imageView != null) {
            this.drawImageFromUrl(imageView, url);
        }
    }

    public void loadImages(@NonNull List<String> imageUrlList) {
        if (imageUrlList.size() <= 0) {
            this.drawImage(this.prepareSingleImageView(), this.getDefaultDrawable());
            return;
        }
        List<ImageView> profileIamges = this.prepareImageViews(imageUrlList.size());
        int size = Math.min(4, imageUrlList.size());
        for (int i = 0; i < size; ++i) {
            ImageView imageView = profileIamges.get(i);
            String url = imageUrlList.get(i);
            this.drawImageFromUrl(imageView, url);
        }
    }

    private void drawImageFromUrl(@NonNull ImageView imageView, @NonNull String url) {
        if (TextUtils.isEmpty(url)) {
            this.drawImage(imageView, this.getDefaultDrawable());
            return;
        }
        int overrideSize = this.getResources().getDimensionPixelSize(R.dimen.sb_size_64);
        ((RequestBuilder)((RequestBuilder)((RequestBuilder)((RequestBuilder)Glide.with((Context)imageView.getContext()).load(url).override(overrideSize, overrideSize)).centerCrop()).diskCacheStrategy(DiskCacheStrategy.ALL)).error(this.getDefaultDrawable())).into(imageView);
    }

    private Drawable getDefaultDrawable() {
        if (this.defaultImageResId > 0) {
            return AppCompatResources.getDrawable((Context)this.getContext(), (int)this.defaultImageResId);
        }
        int iconTint = SendBirdUIKit.isDarkMode() ? R.color.onlight_01 : R.color.ondark_01;
        int backgroundTint = R.color.background_300;
        return DrawableUtils.createOvalIcon(this.getContext(), backgroundTint, R.drawable.icon_user, iconTint);
    }

    private void drawImage(@NonNull ImageView imageView, Drawable drawable2) {
        imageView.setImageDrawable(drawable2);
    }

    public void drawBroadcastChannelCover() {
        ImageView imageView = this.prepareSingleImageView();
        int iconTint = SendBirdUIKit.isDarkMode() ? R.color.onlight_01 : R.color.ondark_01;
        int backgroundTint = SendBirdUIKit.getDefaultThemeMode().getSecondaryTintResId();
        imageView.setImageDrawable(DrawableUtils.createOvalIcon(this.getContext(), backgroundTint, R.drawable.icon_broadcast, iconTint));
    }
}

