/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.vm;

import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.OnLifecycleEvent;
import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.FileMessage;
import com.sendbird.android.FileMessageParams;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.Member;
import com.sendbird.android.MessageListParams;
import com.sendbird.android.Reaction;
import com.sendbird.android.ReactionEvent;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.User;
import com.sendbird.android.UserMessage;
import com.sendbird.android.UserMessageParams;
import com.sendbird.uikit.R;
import com.sendbird.uikit.consts.MessageLoadState;
import com.sendbird.uikit.log.Logger;
import com.sendbird.uikit.model.ChatMessageCollection;
import com.sendbird.uikit.model.FileInfo;
import com.sendbird.uikit.utils.ReactionUtils;
import com.sendbird.uikit.vm.BaseViewModel;
import com.sendbird.uikit.vm.MessageChangeLogsPager;
import com.sendbird.uikit.vm.PendingMessageRepository;
import com.sendbird.uikit.widgets.PagerRecyclerView;
import com.sendbird.uikit.widgets.StatusFrameView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;

public class ChannelViewModel
extends BaseViewModel
implements LifecycleObserver,
PagerRecyclerView.Pageable<List<BaseMessage>> {
    private static final int DEFAULT_MESSAGE_LOAD_SIZE = 40;
    private static final String CONNECTION_HANDLER_ID = "CONNECTION_HANDLER_GROUP_CHAT";
    private static final String CHANNEL_HANDLER_ID = "CHANNEL_HANDLER_GROUP_CHANNEL_CHAT";
    private final ExecutorService worker = Executors.newSingleThreadExecutor();
    private final ExecutorService cachedMessageChangeLogs = Executors.newSingleThreadExecutor();
    private final MutableLiveData<List<BaseMessage>> messageList = new MutableLiveData();
    private final ChatMessageCollection messageCollection = new ChatMessageCollection();
    private final MutableLiveData<List<User>> typingMembers = new MutableLiveData();
    private final MutableLiveData<GroupChannel> isChannelChanged = new MutableLiveData();
    private final MutableLiveData<Boolean> channelDeleted = new MutableLiveData();
    private final MutableLiveData<Long> messageDeleted = new MutableLiveData();
    private final MessageListParams messageListParams;
    private final MutableLiveData<MessageLoadState> messageLoadState = new MutableLiveData();
    private final MutableLiveData<StatusFrameView.Status> statusFrame = new MutableLiveData();
    private final MutableLiveData<BaseMessage> incomingMessage = new MutableLiveData();
    private final MutableLiveData<BaseMessage> newRequestedMessage = new MutableLiveData();
    private final List<BaseMessage> cachedMessageList = new ArrayList<BaseMessage>();
    private GroupChannel channel;
    private volatile boolean hasPrevious;
    private volatile boolean hasNext;
    private long startingPoint;

    ChannelViewModel(@NonNull GroupChannel groupChannel, @Nullable MessageListParams params) {
        this.channel = groupChannel;
        this.messageListParams = params != null ? params : new MessageListParams();
        this.messageListParams.setReverse(true);
        this.messageListParams.setIncludeReactions(ReactionUtils.useReaction((BaseChannel)groupChannel));
    }

    private boolean isCurrentChannel(@NonNull String channelUrl) {
        return channelUrl.equals(this.channel.getUrl());
    }

    public LiveData<GroupChannel> isChannelChanged() {
        return this.isChannelChanged;
    }

    public LiveData<Boolean> getChannelDeleted() {
        return this.channelDeleted;
    }

    public LiveData<Long> getMessageDeleted() {
        return this.messageDeleted;
    }

    public GroupChannel getChannel() {
        return this.channel;
    }

    public LiveData<List<BaseMessage>> getMessageList() {
        return this.messageList;
    }

    public LiveData<BaseMessage> getIncomingMessage() {
        return this.incomingMessage;
    }

    public LiveData<BaseMessage> getNewRequestedMessage() {
        return this.newRequestedMessage;
    }

    public LiveData<List<User>> getTypingMembers() {
        return this.typingMembers;
    }

    public LiveData<MessageLoadState> getMessageLoadState() {
        return this.messageLoadState;
    }

    public LiveData<StatusFrameView.Status> getStatusFrame() {
        return this.statusFrame;
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public boolean hasPrevious() {
        return this.hasPrevious;
    }

    public long getStartingPoint() {
        return this.startingPoint;
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_RESUME)
    private void onResume() {
        SendBird.addConnectionHandler((String)CONNECTION_HANDLER_ID, (SendBird.ConnectionHandler)new SendBird.ConnectionHandler(){

            public void onReconnectStarted() {
            }

            public void onReconnectSucceeded() {
                ChannelViewModel.this.channel.refresh(e -> {
                    if (e != null) {
                        Logger.dev(e);
                        if (e.getCode() == 400108) {
                            ChannelViewModel.this.channelDeleted.postValue((Object)true);
                            return;
                        }
                    } else {
                        ChannelViewModel.this.isChannelChanged.postValue((Object)ChannelViewModel.this.channel);
                    }
                    ChannelViewModel.this.requestChangeLogs((BaseChannel)ChannelViewModel.this.channel);
                    ChannelViewModel.this.cachedMessageChangeLogs();
                });
            }

            public void onReconnectFailed() {
            }
        });
        SendBird.addChannelHandler((String)CHANNEL_HANDLER_ID, (SendBird.ChannelHandler)new SendBird.ChannelHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onMessageReceived(BaseChannel baseChannel, BaseMessage baseMessage) {
                if (ChannelViewModel.this.isCurrentChannel(baseChannel.getUrl())) {
                    Logger.i(">> ChannelFragnemt::onMessageReceived(%s), hasNext=%s", baseMessage.getMessageId(), ChannelViewModel.this.hasNext);
                    ChannelViewModel.this.channel = (GroupChannel)baseChannel;
                    if (ChannelViewModel.this.hasNext) {
                        List list = ChannelViewModel.this.cachedMessageList;
                        synchronized (list) {
                            ChannelViewModel.this.cachedMessageList.add(baseMessage);
                        }
                    } else {
                        ChannelViewModel.this.messageCollection.add(baseMessage);
                        ChannelViewModel.this.notifyDataSetChanged();
                    }
                    ChannelViewModel.this.incomingMessage.postValue((Object)baseMessage);
                    ChannelViewModel.this.markAsRead();
                }
            }

            public void onUserJoined(GroupChannel channel, User user) {
                if (ChannelViewModel.this.isCurrentChannel(channel.getUrl())) {
                    Logger.i(">> ChannelFragnemt::onUserJoined()", new Object[0]);
                    Logger.d("++ joind user : " + user);
                    ChannelViewModel.this.channel = channel;
                    ChannelViewModel.this.isChannelChanged.postValue((Object)channel);
                    ChannelViewModel.this.notifyDataSetChanged();
                }
            }

            public void onUserLeft(GroupChannel channel, User user) {
                if (ChannelViewModel.this.isCurrentChannel(channel.getUrl())) {
                    Logger.i(">> ChannelFragnemt::onUserLeft()", new Object[0]);
                    Logger.d("++ left user : " + user);
                    if (channel.getMyMemberState() == Member.MemberState.NONE) {
                        ChannelViewModel.this.channelDeleted.postValue((Object)true);
                        return;
                    }
                    ChannelViewModel.this.channel = channel;
                    ChannelViewModel.this.isChannelChanged.postValue((Object)channel);
                    ChannelViewModel.this.notifyDataSetChanged();
                }
            }

            public void onMessageDeleted(BaseChannel baseChannel, long msgId) {
                if (ChannelViewModel.this.isCurrentChannel(baseChannel.getUrl())) {
                    Logger.i(">> ChannelFragnemt::onMessageDeleted()", new Object[0]);
                    Logger.d("++ deletedMessage : " + msgId);
                    ChannelViewModel.this.channel = (GroupChannel)baseChannel;
                    ChannelViewModel.this.messageDeleted.postValue((Object)msgId);
                    ChannelViewModel.this.messageCollection.removeByMessageId(msgId);
                    ChannelViewModel.this.notifyDataSetChanged();
                }
            }

            public void onMessageUpdated(BaseChannel baseChannel, BaseMessage updatedMessage) {
                if (ChannelViewModel.this.isCurrentChannel(baseChannel.getUrl())) {
                    Logger.i(">> ChannelFragnemt::onMessageUpdated()", new Object[0]);
                    Logger.d("++ updatedMessage : " + updatedMessage.getMessageId());
                    ChannelViewModel.this.channel = (GroupChannel)baseChannel;
                    ChannelViewModel.this.messageCollection.update(updatedMessage);
                    ChannelViewModel.this.notifyDataSetChanged();
                }
            }

            public void onReadReceiptUpdated(GroupChannel baseChannel) {
                if (ChannelViewModel.this.isCurrentChannel(baseChannel.getUrl())) {
                    Logger.i(">> ChannelFragnemt::onReadReceiptUpdated()", new Object[0]);
                    ChannelViewModel.this.channel = baseChannel;
                    ChannelViewModel.this.notifyDataSetChanged();
                }
            }

            public void onDeliveryReceiptUpdated(GroupChannel channel) {
                if (ChannelViewModel.this.isCurrentChannel(channel.getUrl())) {
                    Logger.i(">> ChannelFragnemt::onDeliveryReceiptUpdated()", new Object[0]);
                    ChannelViewModel.this.channel = channel;
                    ChannelViewModel.this.notifyDataSetChanged();
                }
            }

            public void onTypingStatusUpdated(GroupChannel channel) {
                if (ChannelViewModel.this.isCurrentChannel(channel.getUrl())) {
                    Logger.i(">> ChannelFragnemt::onTypingStatusUpdated()", new Object[0]);
                    List typingUsers = channel.getTypingUsers();
                    if (typingUsers.size() > 0) {
                        ChannelViewModel.this.typingMembers.postValue((Object)typingUsers);
                    } else {
                        ChannelViewModel.this.typingMembers.postValue(null);
                    }
                }
            }

            public void onChannelChanged(BaseChannel channel) {
                if (ChannelViewModel.this.isCurrentChannel(channel.getUrl())) {
                    Logger.i(">> ChannelFragnemt::onChannelChanged()", new Object[0]);
                    ChannelViewModel.this.channel = (GroupChannel)channel;
                    ChannelViewModel.this.isChannelChanged.postValue((Object)((GroupChannel)channel));
                }
            }

            public void onChannelDeleted(String channelUrl, BaseChannel.ChannelType channelType) {
                if (ChannelViewModel.this.isCurrentChannel(channelUrl)) {
                    Logger.i(">> ChannelFragnemt::onChannelDeleted()", new Object[0]);
                    Logger.d("++ deleted channel url : " + channelUrl);
                    ChannelViewModel.this.channelDeleted.postValue((Object)true);
                }
            }

            public void onChannelFrozen(BaseChannel channel) {
                if (ChannelViewModel.this.isCurrentChannel(channel.getUrl())) {
                    Logger.i(">> ChannelFragnemt::onChannelFrozen(%s)", channel.isFrozen());
                    ChannelViewModel.this.channel = (GroupChannel)channel;
                    ChannelViewModel.this.isChannelChanged.postValue((Object)((GroupChannel)channel));
                    ChannelViewModel.this.notifyDataSetChanged();
                }
            }

            public void onChannelUnfrozen(BaseChannel channel) {
                if (ChannelViewModel.this.isCurrentChannel(channel.getUrl())) {
                    Logger.i(">> ChannelFragnemt::onChannelUnfrozen(%s)", channel.isFrozen());
                    ChannelViewModel.this.channel = (GroupChannel)channel;
                    ChannelViewModel.this.isChannelChanged.postValue((Object)((GroupChannel)channel));
                    ChannelViewModel.this.notifyDataSetChanged();
                }
            }

            public void onReactionUpdated(BaseChannel channel, ReactionEvent reactionEvent) {
                if (ChannelViewModel.this.isCurrentChannel(channel.getUrl())) {
                    Logger.i(">> ChannelFragnemt::onReactionUpdated()", new Object[0]);
                    ChannelViewModel.this.channel = (GroupChannel)channel;
                    BaseMessage message = ChannelViewModel.this.messageCollection.get(reactionEvent.getMessageId());
                    if (message != null) {
                        message.applyReactionEvent(reactionEvent);
                        ChannelViewModel.this.notifyDataSetChanged();
                    }
                }
            }

            public void onOperatorUpdated(BaseChannel channel) {
                if (ChannelViewModel.this.isCurrentChannel(channel.getUrl())) {
                    Logger.i(">> ChannelFragnemt::onOperatorUpdated()", new Object[0]);
                    ChannelViewModel.this.channel = (GroupChannel)channel;
                    Logger.i("++ my role : " + ((GroupChannel)channel).getMyRole(), new Object[0]);
                    ChannelViewModel.this.isChannelChanged.postValue((Object)((GroupChannel)channel));
                    ChannelViewModel.this.notifyDataSetChanged();
                }
            }

            public void onUserBanned(BaseChannel channel, User user) {
                if (ChannelViewModel.this.isCurrentChannel(channel.getUrl()) && user.getUserId().equals(SendBird.getCurrentUser().getUserId())) {
                    Logger.i(">> ChannelFragnemt::onUserBanned()", new Object[0]);
                    ChannelViewModel.this.channelDeleted.postValue((Object)true);
                }
            }

            public void onUserMuted(BaseChannel channel, User user) {
                if (ChannelViewModel.this.isCurrentChannel(channel.getUrl())) {
                    Logger.i(">> ChannelFragnemt::onUserMuted()", new Object[0]);
                    ChannelViewModel.this.channel = (GroupChannel)channel;
                    ChannelViewModel.this.isChannelChanged.postValue((Object)((GroupChannel)channel));
                }
            }

            public void onUserUnmuted(BaseChannel channel, User user) {
                if (ChannelViewModel.this.isCurrentChannel(channel.getUrl())) {
                    Logger.i(">> ChannelFragnemt::onUserUnmuted()", new Object[0]);
                    ChannelViewModel.this.channel = (GroupChannel)channel;
                    ChannelViewModel.this.isChannelChanged.postValue((Object)((GroupChannel)channel));
                }
            }
        });
        Logger.i("++ channel.getMyMemberState() : " + this.channel.getMyMemberState(), new Object[0]);
        if (this.channel.getMyMemberState() == Member.MemberState.JOINED) {
            this.requestChangeLogs((BaseChannel)this.channel);
            this.cachedMessageChangeLogs();
        }
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
    private void onDestroy() {
        SendBird.removeConnectionHandler((String)CONNECTION_HANDLER_ID);
        SendBird.removeChannelHandler((String)CHANNEL_HANDLER_ID);
    }

    private List<BaseMessage> loadMessages(long ts, MessageListParams params) throws Exception {
        Logger.dev(">> ChannelViewModel::loadMessages()");
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference result = new AtomicReference();
        AtomicReference error = new AtomicReference();
        this.channel.getMessagesByTimestamp(ts, params, (messages, e) -> {
            try {
                if (e != null) {
                    error.set(e);
                    return;
                }
                result.set(messages);
            }
            finally {
                latch.countDown();
            }
        });
        latch.await();
        if (error.get() != null) {
            throw (Exception)error.get();
        }
        List newMessageList = (List)result.get();
        Logger.i("++ load messages result size : " + newMessageList.size(), new Object[0]);
        return newMessageList;
    }

    @Override
    protected void onCleared() {
        super.onCleared();
        Logger.dev("-- onCleared ChannelViewModel");
        this.worker.shutdownNow();
    }

    private void markAsRead() {
        Logger.dev("markAsRead");
        this.channel.markAsRead();
    }

    private void notifyDataSetChanged() {
        List<BaseMessage> currentList = this.messageCollection.copyToList();
        if (!this.hasNext) {
            currentList.addAll(0, PendingMessageRepository.getInstance().getPendingMessageList(this.channel.getUrl()));
        }
        if (currentList.size() == 0) {
            this.statusFrame.postValue((Object)StatusFrameView.Status.EMPTY);
        } else {
            this.statusFrame.postValue((Object)StatusFrameView.Status.NONE);
            this.messageList.postValue(currentList);
        }
    }

    private synchronized void cachedMessageChangeLogs() {
        if (!this.hasNext || this.cachedMessageList.isEmpty()) {
            return;
        }
        long firstTs = this.cachedMessageList.get(0).getCreatedAt();
        int size = this.cachedMessageList.size();
        this.cachedMessageChangeLogs.submit(() -> {
            List<BaseMessage> messages;
            boolean hasMore;
            long ts = this.cachedMessageList.get(0).getCreatedAt();
            ArrayList<BaseMessage> results = new ArrayList<BaseMessage>();
            if (firstTs == ts && this.cachedMessageList.size() != size) {
                return results;
            }
            MessageListParams params = this.messageListParams.clone();
            params.setPreviousResultSize(0);
            params.setNextResultSize(100);
            do {
                if (!results.isEmpty()) {
                    ts = ((BaseMessage)results.get(0)).getCreatedAt();
                }
                messages = this.loadMessages(ts, params);
                results.addAll(0, messages);
            } while (hasMore = messages.size() > 0);
            this.cachedMessageList.addAll(results);
            return results;
        });
    }

    private void requestChangeLogs(@NonNull BaseChannel channel) {
        String channelUrl = channel.getUrl();
        int cacheMessageSize = this.messageCollection.size();
        long lastSyncTs = cacheMessageSize > 0 ? this.messageCollection.last().getCreatedAt() : 0L;
        Logger.d("++ change logs channel url = %s, lastSyncTs = %s, hasNext=%s", channelUrl, lastSyncTs, this.hasNext);
        if (lastSyncTs > 0L) {
            MessageChangeLogsPager pager = new MessageChangeLogsPager(channel, lastSyncTs, this.messageListParams);
            pager.load(!this.hasNext, new MessageChangeLogsPager.MessageChangeLogsResultHandler(){

                @Override
                public void onError(SendBirdException e) {
                    Logger.e(e);
                }

                @Override
                public void onResult(List<BaseMessage> added, List<BaseMessage> updated, List<Long> deletedIds) {
                    Logger.i("++ channel message change logs result >> deleted message size : %s, current message size : %s, added message size : %s", deletedIds.size(), ChannelViewModel.this.messageCollection.size(), added.size());
                    for (long deletedId : deletedIds) {
                        BaseMessage deletedMessage = ChannelViewModel.this.messageCollection.get(deletedId);
                        if (deletedMessage == null) continue;
                        ChannelViewModel.this.messageCollection.remove(deletedMessage);
                    }
                    Logger.i("++ updated Message size : %s", updated.size());
                    ChannelViewModel.this.messageCollection.updateAll(updated);
                    if (added.size() > 0) {
                        ChannelViewModel.this.messageCollection.addAll(added);
                    }
                    Logger.i("++ merged message size : %s", ChannelViewModel.this.messageCollection.size());
                    boolean changed = added.size() > 0 || updated.size() > 0 || deletedIds.size() > 0;
                    Logger.dev("++ changeLogs updated : %s", changed);
                    if (changed) {
                        ChannelViewModel.this.notifyDataSetChanged();
                        ChannelViewModel.this.markAsRead();
                    }
                }
            });
        }
    }

    public void setTyping(boolean isTyping) {
        if (this.channel != null) {
            if (isTyping) {
                this.channel.startTyping();
            } else {
                this.channel.endTyping();
            }
        }
    }

    public void sendUserMessage(@NonNull UserMessageParams params) {
        Logger.i("++ request send message : %s", params);
        String channelUrl = this.channel.getUrl();
        UserMessage pendingUserMessage = this.channel.sendUserMessage(params, (message, e) -> {
            if (e != null) {
                Logger.e(e);
                PendingMessageRepository.getInstance().updatePendingMessage(channelUrl, (BaseMessage)message);
                this.notifyDataSetChanged();
                return;
            }
            Logger.i("++ sent message : %s", message);
            this.messageCollection.add((BaseMessage)message);
            PendingMessageRepository.getInstance().removePendingMessage(channelUrl, (BaseMessage)message);
            this.notifyDataSetChanged();
            this.newRequestedMessage.postValue((Object)message);
        });
        PendingMessageRepository.getInstance().addPendingMessage(channelUrl, (BaseMessage)pendingUserMessage);
        this.notifyDataSetChanged();
        this.newRequestedMessage.postValue((Object)pendingUserMessage);
    }

    public void sendFileMessage(@NonNull FileMessageParams params, @NonNull FileInfo fileInfo) {
        Logger.i("++ request send file message : %s", params);
        String channelUrl = this.channel.getUrl();
        FileMessage pendingFileMessage = this.channel.sendFileMessage(params, (message, ee) -> {
            if (ee != null) {
                Logger.e(ee);
                if (message != null) {
                    PendingMessageRepository.getInstance().updatePendingMessage(channelUrl, (BaseMessage)message);
                    this.notifyDataSetChanged();
                }
                if (ee.getMessage() != null) {
                    this.errorToast.postValue((Object)R.string.sb_text_error_send_message);
                }
                return;
            }
            Logger.i("++ sent message : %s", message);
            this.messageCollection.add((BaseMessage)message);
            PendingMessageRepository.getInstance().removePendingMessage(channelUrl, (BaseMessage)message);
            this.notifyDataSetChanged();
            this.newRequestedMessage.postValue((Object)message);
        });
        if (pendingFileMessage != null) {
            PendingMessageRepository.getInstance().addPendingMessage(channelUrl, (BaseMessage)pendingFileMessage);
            PendingMessageRepository.getInstance().addFileInfo(pendingFileMessage, fileInfo);
            this.notifyDataSetChanged();
            this.newRequestedMessage.postValue((Object)pendingFileMessage);
        }
    }

    public void resendMessage(@NonNull BaseMessage message) {
        String channelUrl = this.channel.getUrl();
        if (message instanceof UserMessage) {
            UserMessage pendingMessage = this.channel.resendMessage((UserMessage)message, (message12, e) -> {
                if (e != null) {
                    Logger.e(e);
                    this.errorToast.postValue((Object)R.string.sb_text_error_resend_message);
                    PendingMessageRepository.getInstance().updatePendingMessage(channelUrl, (BaseMessage)message12);
                    this.notifyDataSetChanged();
                    return;
                }
                Logger.i("__ resent message : %s", message12);
                this.messageCollection.add((BaseMessage)message12);
                PendingMessageRepository.getInstance().removePendingMessage(channelUrl, (BaseMessage)message12);
                this.notifyDataSetChanged();
                this.newRequestedMessage.postValue((Object)message);
            });
            PendingMessageRepository.getInstance().updatePendingMessage(channelUrl, (BaseMessage)pendingMessage);
            this.notifyDataSetChanged();
        } else if (message instanceof FileMessage) {
            FileInfo info = PendingMessageRepository.getInstance().getFileInfo(message);
            FileMessage pendingMessage = this.channel.resendMessage((FileMessage)message, info.getFile(), (message1, e1) -> {
                if (e1 != null) {
                    Logger.e(e1);
                    this.errorToast.postValue((Object)R.string.sb_text_error_resend_message);
                    PendingMessageRepository.getInstance().updatePendingMessage(channelUrl, (BaseMessage)message1);
                    this.notifyDataSetChanged();
                    return;
                }
                Logger.i("__ resent file message : %s", message1);
                this.messageCollection.add((BaseMessage)message1);
                PendingMessageRepository.getInstance().removePendingMessage(channelUrl, (BaseMessage)message1);
                this.notifyDataSetChanged();
                this.newRequestedMessage.postValue((Object)message);
            });
            PendingMessageRepository.getInstance().updatePendingMessage(channelUrl, (BaseMessage)pendingMessage);
            this.notifyDataSetChanged();
        }
    }

    public void updateUserMessage(long messageId, @NonNull UserMessageParams params) {
        this.channel.updateUserMessage(messageId, params, (message, e) -> {
            if (e != null) {
                this.errorToast.postValue((Object)R.string.sb_text_error_update_user_message);
                return;
            }
            Logger.i("++ updated message : %s", message);
            this.messageCollection.update((BaseMessage)message);
            this.notifyDataSetChanged();
        });
    }

    public void deleteMessage(@NonNull BaseMessage message) {
        if (message.getSendingStatus() == BaseMessage.SendingStatus.SUCCEEDED) {
            this.channel.deleteMessage(message, e -> {
                if (e != null) {
                    this.errorToast.postValue((Object)R.string.sb_text_error_delete_message);
                    return;
                }
                Logger.i("++ deleted message : %s", message);
                this.messageCollection.remove(message);
                this.messageDeleted.postValue((Object)message.getMessageId());
                this.notifyDataSetChanged();
            });
        } else {
            PendingMessageRepository.getInstance().removePendingMessage(message.getChannelUrl(), message);
            this.notifyDataSetChanged();
        }
    }

    public void toggleReaction(View view, BaseMessage message, String key) {
        if (!view.isSelected()) {
            Logger.i("__ add reaction : %s", key);
            this.channel.addReaction(message, key, (reactionEvent, e) -> {
                if (e != null) {
                    Logger.e(e);
                    this.errorToast.postValue((Object)R.string.sb_text_error_add_reaction);
                }
            });
        } else {
            Logger.i("__ delete reaction : %s", key);
            this.channel.deleteReaction(message, key, (reactionEvent, e) -> {
                if (e != null) {
                    Logger.e(e);
                    this.errorToast.postValue((Object)R.string.sb_text_error_delete_reaction);
                }
            });
        }
    }

    public Map<Reaction, List<User>> getReactionUserInfo(List<Reaction> reactionList) {
        HashMap<Reaction, List<User>> result = new HashMap<Reaction, List<User>>();
        HashMap<String, Member> userMap = new HashMap<String, Member>();
        for (Member member : this.channel.getMembers()) {
            userMap.put(member.getUserId(), member);
        }
        for (Reaction reaction : reactionList) {
            ArrayList<User> userList = new ArrayList<User>();
            List userIds = reaction.getUserIds();
            for (String userId : userIds) {
                User user = (User)userMap.get(userId);
                userList.add(user);
            }
            result.put(reaction, userList);
        }
        return result;
    }

    public void loadInitial(long ts) {
        this.worker.execute(() -> {
            try {
                Logger.i("____________ loadInitial()", new Object[0]);
                this.messageLoadState.postValue((Object)MessageLoadState.LOAD_STARTED);
                this.messageCollection.clear();
                Logger.i("____________ cachedMessageList size=%s,  hasNext=%s", this.cachedMessageList.size(), this.hasNext);
                if (this.hasNext && this.cachedMessageList.size() > 0 && this.cachedMessageList.get(0).getCreatedAt() < ts) {
                    this.hasNext = false;
                    this.hasPrevious = true;
                    this.messageCollection.addAll(this.cachedMessageList);
                    this.notifyDataSetChanged();
                }
                this.startingPoint = ts;
                MessageListParams params = this.messageListParams.clone();
                params.setPreviousResultSize(20);
                params.setNextResultSize(0);
                params.setInclusive(true);
                List<BaseMessage> prevList = this.loadMessages(ts, params);
                this.hasPrevious = prevList.size() >= params.getPreviousResultSize();
                Logger.i("____________ load initial prev message list : %s, hasPrevious=%s", prevList.size(), this.hasPrevious);
                params.setPreviousResultSize(0);
                params.setNextResultSize(20);
                params.setInclusive(false);
                List<BaseMessage> nextList = this.loadMessages(ts, params);
                prevList.addAll(nextList);
                this.hasNext = ts != Long.MAX_VALUE && nextList.size() >= params.getNextResultSize();
                Logger.i("____________ load initial nextList message list : %s, hasNext=%s", nextList.size(), this.hasNext);
                if (this.hasNext) {
                    params = this.messageListParams.clone();
                    params.setPreviousResultSize(40);
                    List<BaseMessage> lastestMessages = this.loadMessages(Long.MAX_VALUE, params);
                    List<BaseMessage> list = this.cachedMessageList;
                    synchronized (list) {
                        this.cachedMessageList.clear();
                        this.cachedMessageList.addAll(lastestMessages);
                    }
                }
                this.messageCollection.clear();
                this.messageCollection.addAll(prevList);
                this.markAsRead();
            }
            catch (Exception e) {
                Logger.w(e);
            }
            finally {
                this.notifyDataSetChanged();
                this.messageLoadState.postValue((Object)MessageLoadState.LOAD_ENDED);
            }
        });
    }

    @Override
    public List<BaseMessage> loadPrevious() throws Exception {
        List<BaseMessage> newMessageList;
        if (!this.hasPrevious) {
            return Collections.emptyList();
        }
        try {
            Logger.i("____________ loadPrevious()", new Object[0]);
            this.messageLoadState.postValue((Object)MessageLoadState.LOAD_STARTED);
            long ts = this.messageCollection.first().getCreatedAt();
            MessageListParams params = this.messageListParams.clone();
            params.setPreviousResultSize(40);
            params.setNextResultSize(0);
            newMessageList = this.loadMessages(ts, params);
            this.hasPrevious = newMessageList.size() >= params.getPreviousResultSize();
            Logger.i("____________ load previous message list : %s, hasPrevious=%s", newMessageList.size(), this.hasPrevious);
            this.messageCollection.addAll(newMessageList);
        }
        catch (Exception e) {
            Logger.w(e);
            throw e;
        }
        finally {
            this.notifyDataSetChanged();
            this.messageLoadState.postValue((Object)MessageLoadState.LOAD_ENDED);
        }
        return newMessageList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BaseMessage> loadNext() throws Exception {
        List<BaseMessage> newMessageList;
        if (!this.hasNext) {
            return Collections.emptyList();
        }
        try {
            Logger.i("____________ loadNext()", new Object[0]);
            this.messageLoadState.postValue((Object)MessageLoadState.LOAD_STARTED);
            long ts = this.messageCollection.last().getCreatedAt();
            MessageListParams params = this.messageListParams.clone();
            params.setPreviousResultSize(0);
            params.setNextResultSize(40);
            params.setReverse(false);
            newMessageList = this.loadMessages(ts, params);
            boolean bl = this.hasNext = newMessageList.size() >= params.getNextResultSize();
            if (newMessageList.size() > 0) {
                Logger.i("____________ load next message list : %s, hasNext= %s", newMessageList.size(), this.hasNext);
            }
            if (!this.hasNext) {
                List<BaseMessage> list = this.cachedMessageList;
                synchronized (list) {
                    newMessageList.addAll(this.cachedMessageList);
                    this.cachedMessageList.clear();
                }
            }
            this.messageCollection.addAll(newMessageList);
        }
        catch (Exception e) {
            Logger.w(e);
            throw e;
        }
        finally {
            this.notifyDataSetChanged();
            this.messageLoadState.postValue((Object)MessageLoadState.LOAD_ENDED);
        }
        return newMessageList;
    }
}

