/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.vm;

import com.sendbird.android.GroupChannel;
import com.sendbird.android.GroupChannelChangeLogsParams;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.uikit.log.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

class ChannelChangeLogsPager {
    private final AtomicLong lastSyncTs = new AtomicLong(0L);
    private final GroupChannelChangeLogsParams params;

    ChannelChangeLogsPager(long lastSyncTs, GroupChannelChangeLogsParams params) {
        this.lastSyncTs.set(lastSyncTs);
        this.params = params;
    }

    void load(ChannelChangeLogsResultHandler handler) {
        Executors.newSingleThreadExecutor().execute(() -> {
            block4: {
                ArrayList<GroupChannel> updatedChannels = new ArrayList<GroupChannel>();
                ArrayList<String> deletedChannelUrls = new ArrayList<String>();
                CountDownLatch lock = new CountDownLatch(1);
                AtomicReference tokenRef = new AtomicReference();
                AtomicBoolean hasMoreRef = new AtomicBoolean();
                try {
                    ChannelChangeLogsPager.load(this.lastSyncTs.get(), this.params, (updated, deleted, hasMore, token, e) -> {
                        if (e != null) {
                            if (handler != null) {
                                handler.onError(e);
                            }
                            return;
                        }
                        tokenRef.set(token);
                        hasMoreRef.set(hasMore);
                        updatedChannels.addAll(updated);
                        deletedChannelUrls.addAll(deleted);
                        lock.countDown();
                    });
                    lock.await();
                    while (hasMoreRef.get()) {
                        CountDownLatch moreLock = new CountDownLatch(1);
                        ChannelChangeLogsPager.more((String)tokenRef.get(), this.params, (updated, deleted, hasMore, token, e) -> {
                            if (e != null) {
                                if (handler != null) {
                                    handler.onError(e);
                                }
                                return;
                            }
                            tokenRef.set(token);
                            hasMoreRef.set(hasMore);
                            updatedChannels.addAll(updated);
                            deletedChannelUrls.addAll(deleted);
                            moreLock.countDown();
                        });
                        moreLock.await();
                    }
                    if (handler != null) {
                        handler.onResult(updatedChannels, deletedChannelUrls);
                    }
                }
                catch (InterruptedException e2) {
                    Logger.e(e2);
                    if (handler == null) break block4;
                    handler.onError(new SendBirdException("timeout", 800220));
                }
            }
        });
    }

    private static void load(long lastSyncTs, GroupChannelChangeLogsParams params, SendBird.GetMyGroupChannelChangeLogsHandler handler) {
        SendBird.getMyGroupChannelChangeLogsByTimestampWithParams((long)lastSyncTs, (GroupChannelChangeLogsParams)params, (SendBird.GetMyGroupChannelChangeLogsHandler)handler);
    }

    private static void more(String token, GroupChannelChangeLogsParams params, SendBird.GetMyGroupChannelChangeLogsHandler handler) {
        SendBird.getMyGroupChannelChangeLogsByTokenWithParams((String)token, (GroupChannelChangeLogsParams)params, (SendBird.GetMyGroupChannelChangeLogsHandler)handler);
    }

    static interface ChannelChangeLogsResultHandler {
        public void onError(SendBirdException var1);

        public void onResult(List<GroupChannel> var1, List<String> var2);
    }
}

