/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.fragments;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.os.Build;
import android.text.Editable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.ColorRes;
import androidx.annotation.DimenRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.databinding.DataBindingUtil;
import androidx.recyclerview.widget.RecyclerView;
import com.sendbird.uikit.R;
import com.sendbird.uikit.consts.DialogEditTextParams;
import com.sendbird.uikit.databinding.SbViewDialogBinding;
import com.sendbird.uikit.fragments.DialogListAdapter;
import com.sendbird.uikit.interfaces.OnEditTextResultListener;
import com.sendbird.uikit.interfaces.OnItemClickListener;
import com.sendbird.uikit.log.Logger;
import com.sendbird.uikit.model.DialogListItem;
import com.sendbird.uikit.utils.DrawableUtils;
import com.sendbird.uikit.utils.SoftInputUtils;
import com.sendbird.uikit.utils.TextUtils;
import java.lang.reflect.Field;

class DialogView
extends LinearLayout {
    private SbViewDialogBinding binding;
    private int backgroundBottomId;
    private int backgroundAnchorId;
    private OnEditTextResultListener editTextResultListener;

    DialogView(Context context) {
        this(context, null);
    }

    DialogView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.sb_dialog_view_style);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DialogView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.DialogView, defStyleAttr, 0);
        try {
            this.binding = (SbViewDialogBinding)DataBindingUtil.inflate((LayoutInflater)LayoutInflater.from((Context)context), (int)R.layout.sb_view_dialog, null, (boolean)false);
            this.addView(this.binding.getRoot(), -1, -2);
            int backgroundId = a.getResourceId(R.styleable.DialogView_sb_dialog_view_background, R.drawable.sb_rounded_rectangle_light);
            this.backgroundBottomId = a.getResourceId(R.styleable.DialogView_sb_dialog_view_background_bottom, R.drawable.sb_top_rounded_rectangle_light);
            this.backgroundAnchorId = a.getResourceId(R.styleable.DialogView_sb_dialog_view_background_anchor, R.drawable.layer_dialog_anchor_background_light);
            int titleAppearance = a.getResourceId(R.styleable.DialogView_sb_dialog_view_title_appearance, R.style.SendbirdH1OnLight01);
            int messageAppearance = a.getResourceId(R.styleable.DialogView_sb_dialog_view_message_appearance, R.style.SendbirdSubtitle2OnLight01);
            int editTextAppearance = a.getResourceId(R.styleable.DialogView_sb_dialog_view_edit_text_appearance, R.style.SendbirdSubtitle2OnLight01);
            ColorStateList editTextTint = a.getColorStateList(R.styleable.DialogView_sb_dialog_view_edit_text_tint);
            int editTextCussorDrawable = a.getResourceId(R.styleable.DialogView_sb_dialog_view_edit_text_cursor_drawable, R.drawable.sb_message_input_cursor_light);
            ColorStateList editTextHintColor = a.getColorStateList(R.styleable.DialogView_sb_dialog_view_edit_text_hint_color);
            int positiveButtonTextAppearance = a.getResourceId(R.styleable.DialogView_sb_dialog_view_positive_button_text_appearance, R.style.SendbirdButtonPrimary300);
            int positiveButtonTextColor = a.getResourceId(R.styleable.DialogView_sb_dialog_view_positive_button_text_color, R.color.sb_button_uncontained_text_color_light);
            int positiveButtonBackground = a.getResourceId(R.styleable.DialogView_sb_dialog_view_positive_button_background, R.drawable.sb_button_uncontained_background_light);
            int negativeButtonTextAppearance = a.getResourceId(R.styleable.DialogView_sb_dialog_view_negative_button_text_appearance, R.style.SendbirdButtonPrimary300);
            int negativeButtonTextColor = a.getResourceId(R.styleable.DialogView_sb_dialog_view_negative_button_text_color, R.color.sb_button_uncontained_text_color_light);
            int negativeButtonBackground = a.getResourceId(R.styleable.DialogView_sb_dialog_view_negative_button_background, R.drawable.sb_button_uncontained_background_light);
            int neutralButtonTextAppearance = a.getResourceId(R.styleable.DialogView_sb_dialog_view_neutral_button_text_appearance, R.style.SendbirdButtonPrimary300);
            int neutralButtonTextColor = a.getResourceId(R.styleable.DialogView_sb_dialog_view_neutral_button_text_color, R.color.sb_button_uncontained_text_color_light);
            int neutralButtonBackground = a.getResourceId(R.styleable.DialogView_sb_dialog_view_neutral_button_background, R.drawable.sb_button_uncontained_background_light);
            this.binding.sbParentPanel.setBackgroundResource(backgroundId);
            this.binding.tvDialogTitle.setTextAppearance(context, titleAppearance);
            this.binding.tvDialogMessage.setTextAppearance(context, messageAppearance);
            this.binding.etInputText.setTextAppearance(context, editTextAppearance);
            this.binding.etInputText.setBackground(DrawableUtils.setTintList(this.binding.etInputText.getBackground(), editTextTint));
            if (editTextHintColor != null) {
                this.binding.etInputText.setHintTextColor(editTextHintColor);
            }
            if (Build.VERSION.SDK_INT >= 29) {
                this.binding.etInputText.setTextCursorDrawable(editTextCussorDrawable);
            } else {
                Field f = TextView.class.getDeclaredField("mCursorDrawableRes");
                f.setAccessible(true);
                f.set(this.binding.etInputText, editTextCussorDrawable);
            }
            this.binding.btPositive.setTextAppearance(context, positiveButtonTextAppearance);
            this.binding.btPositive.setTextColor(AppCompatResources.getColorStateList((Context)context, (int)positiveButtonTextColor));
            this.binding.btPositive.setBackgroundResource(positiveButtonBackground);
            this.binding.btNegative.setTextAppearance(context, negativeButtonTextAppearance);
            this.binding.btNegative.setTextColor(AppCompatResources.getColorStateList((Context)context, (int)negativeButtonTextColor));
            this.binding.btNegative.setBackgroundResource(negativeButtonBackground);
            this.binding.btNeutral.setTextAppearance(context, neutralButtonTextAppearance);
            this.binding.btNeutral.setTextColor(AppCompatResources.getColorStateList((Context)context, (int)neutralButtonTextColor));
            this.binding.btNeutral.setBackgroundResource(neutralButtonBackground);
        }
        catch (Exception e) {
            Logger.e(e);
        }
        finally {
            a.recycle();
        }
    }

    void setTitle(int title) {
        if (title == 0) {
            return;
        }
        this.binding.tvDialogTitle.setText(title);
        this.binding.tvDialogTitle.setVisibility(0);
    }

    void setTitle(CharSequence title) {
        if (TextUtils.isEmpty(title)) {
            return;
        }
        this.binding.tvDialogTitle.setText(title);
        this.binding.tvDialogTitle.setVisibility(0);
    }

    void setMessage(int message) {
        if (message == 0) {
            return;
        }
        this.binding.tvDialogMessage.setText(message);
        this.binding.tvDialogMessage.setVisibility(0);
    }

    void setEditText(DialogEditTextParams params, OnEditTextResultListener editTextResultListener) {
        String text;
        if (params == null) {
            return;
        }
        this.binding.etInputText.setVisibility(0);
        String hintText = params.getHintText();
        if (!TextUtils.isEmpty(hintText)) {
            this.binding.etInputText.setHint((CharSequence)hintText);
        }
        if (!TextUtils.isEmpty(text = params.getText())) {
            this.binding.etInputText.setHint((CharSequence)text);
        }
        this.binding.etInputText.setSingleLine(params.enabledSingleLine());
        TextUtils.TruncateAt ellipsis = params.getEllipsis();
        if (ellipsis != null) {
            this.binding.etInputText.setEllipsize(ellipsis);
        }
        Editable data = this.binding.etInputText.getText();
        int selection = params.getSelection();
        if (selection > 0 && data != null && data.length() > selection) {
            this.binding.etInputText.setSelection(selection);
        }
        SoftInputUtils.showSoftKeyboard((EditText)this.binding.etInputText);
        this.editTextResultListener = editTextResultListener;
    }

    void setItems(DialogListItem[] items, @NonNull OnItemClickListener<Integer> itemClickListener, boolean isLeft) {
        if (items == null) {
            return;
        }
        this.binding.rvSelectView.setAdapter((RecyclerView.Adapter)new DialogListAdapter(items, itemClickListener, isLeft));
        this.binding.rvSelectView.setVisibility(0);
    }

    void setItems(DialogListItem[] items, @NonNull OnItemClickListener<Integer> itemClickListener, boolean isLeft, @DimenRes int nameMarginLeft) {
        if (items == null) {
            return;
        }
        DialogListAdapter adapter = new DialogListAdapter(items, itemClickListener, isLeft);
        adapter.setNameMarginLeft(nameMarginLeft);
        this.binding.rvSelectView.setAdapter((RecyclerView.Adapter)adapter);
        this.binding.rvSelectView.setVisibility(0);
    }

    void setPositiveButton(String text, @ColorRes int textColor, @NonNull View.OnClickListener clickListener) {
        if (TextUtils.isEmpty(text)) {
            return;
        }
        this.binding.btPositive.setText((CharSequence)text);
        if (textColor != 0) {
            this.binding.btPositive.setTextColor(AppCompatResources.getColorStateList((Context)this.getContext(), (int)textColor));
        }
        this.binding.btPositive.setOnClickListener(v -> {
            if (this.editTextResultListener != null) {
                this.editTextResultListener.onResult(this.getEditText());
            }
            clickListener.onClick(v);
        });
        this.binding.sbButtonPanel.setVisibility(0);
        this.binding.btPositive.setVisibility(0);
    }

    void setNegativeButton(String text, @ColorRes int textColor, @NonNull View.OnClickListener clickListener) {
        if (TextUtils.isEmpty(text)) {
            return;
        }
        this.binding.btNegative.setText((CharSequence)text);
        if (textColor != 0) {
            this.binding.btNegative.setTextColor(AppCompatResources.getColorStateList((Context)this.getContext(), (int)textColor));
        }
        this.binding.btNegative.setOnClickListener(clickListener);
        this.binding.sbButtonPanel.setVisibility(0);
        this.binding.btNegative.setVisibility(0);
    }

    void setNeutralButton(String text, @ColorRes int textColor, @NonNull View.OnClickListener clickListener) {
        if (TextUtils.isEmpty(text)) {
            return;
        }
        this.binding.btNeutral.setText((CharSequence)text);
        if (textColor != 0) {
            this.binding.btNeutral.setTextColor(AppCompatResources.getColorStateList((Context)this.getContext(), (int)textColor));
        }
        this.binding.btNeutral.setOnClickListener(clickListener);
        this.binding.sbButtonPanel.setVisibility(0);
        this.binding.btNeutral.setVisibility(0);
    }

    void setBackgroundBottom() {
        this.binding.sbParentPanel.setBackgroundResource(this.backgroundBottomId);
    }

    void setBackgroundAnchor() {
        this.binding.sbParentPanel.setBackgroundResource(this.backgroundAnchorId);
    }

    private String getEditText() {
        Editable text = this.binding.etInputText.getText();
        return text == null ? "" : text.toString();
    }

    void setContentView(View view) {
        if (view == null) {
            return;
        }
        this.binding.sbContentViewPanel.addView(view, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
    }
}

