/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.activities.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.RecyclerView;
import com.sendbird.android.GroupChannel;
import com.sendbird.uikit.activities.adapter.BaseAdapter;
import com.sendbird.uikit.activities.adapter.ChannelDiffCallback;
import com.sendbird.uikit.activities.viewholder.BaseViewHolder;
import com.sendbird.uikit.databinding.SbViewChannelPreviewBinding;
import com.sendbird.uikit.interfaces.OnItemClickListener;
import com.sendbird.uikit.interfaces.OnItemLongClickListener;
import com.sendbird.uikit.utils.ChannelUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ChannelListAdapter
extends BaseAdapter<GroupChannel, BaseViewHolder<GroupChannel>> {
    private List<GroupChannel> channelList = new ArrayList<GroupChannel>();
    private List<ChannelInfo> cachedChannelList = new ArrayList<ChannelInfo>();
    private OnItemClickListener<GroupChannel> listener;
    private OnItemLongClickListener<GroupChannel> longClickListener;

    public ChannelListAdapter() {
        this.setHasStableIds(true);
    }

    public ChannelListAdapter(OnItemClickListener<GroupChannel> listener) {
        this.setHasStableIds(true);
        this.setOnItemClickListener(listener);
    }

    @NonNull
    public BaseViewHolder<GroupChannel> onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new ChannelPreviewHolder(SbViewChannelPreviewBinding.inflate(LayoutInflater.from((Context)parent.getContext()), parent, false));
    }

    public void onBindViewHolder(@NonNull BaseViewHolder<GroupChannel> holder, int position) {
        GroupChannel channel = this.getItem(position);
        holder.bind(channel);
        holder.itemView.setOnClickListener(v -> {
            int channelPosition = holder.getAdapterPosition();
            if (channelPosition != -1 && this.listener != null) {
                this.listener.onItemClick(v, channelPosition, this.getItem(channelPosition));
            }
        });
        holder.itemView.setOnLongClickListener(v -> {
            int channelPosition = holder.getAdapterPosition();
            if (channelPosition != -1 && this.longClickListener != null) {
                this.longClickListener.onItemLongClick(v, channelPosition, this.getItem(channelPosition));
                return true;
            }
            return false;
        });
    }

    public void setOnItemClickListener(@Nullable OnItemClickListener<GroupChannel> listener) {
        this.listener = listener;
    }

    public void setOnItemLongClickListener(@Nullable OnItemLongClickListener<GroupChannel> listener) {
        this.longClickListener = listener;
    }

    @Override
    public List<GroupChannel> getItems() {
        return this.channelList != null ? Collections.unmodifiableList(this.channelList) : null;
    }

    @Override
    @NonNull
    public GroupChannel getItem(int position) {
        return this.channelList.get(position);
    }

    public int getItemCount() {
        return this.channelList == null ? 0 : this.channelList.size();
    }

    public long getItemId(int position) {
        return this.getItem(position).hashCode();
    }

    public void setItems(List<GroupChannel> channelList) {
        ChannelDiffCallback diffCallback = new ChannelDiffCallback(this.cachedChannelList, channelList);
        DiffUtil.DiffResult diffResult = DiffUtil.calculateDiff((DiffUtil.Callback)diffCallback);
        this.channelList.clear();
        this.channelList.addAll(channelList);
        this.cachedChannelList = ChannelInfo.toChannelInfoList(channelList);
        diffResult.dispatchUpdatesTo((RecyclerView.Adapter)this);
    }

    static class ChannelInfo {
        private final String channelUrl;
        private final long createdAt;
        private final int memberCount;
        private final String lastMessage;
        private final String channelName;
        private final String coverImageUrl;
        private final int coverImageHash;
        private final GroupChannel.PushTriggerOption pushTriggerOption;
        private final int unreadMessageCount;
        private final boolean isFrozen;

        ChannelInfo(@NonNull GroupChannel channel) {
            this.channelUrl = channel.getUrl();
            this.createdAt = channel.getCreatedAt();
            this.memberCount = channel.getMemberCount();
            this.lastMessage = channel.getLastMessage() != null ? channel.getLastMessage().getMessage() : "";
            this.channelName = channel.getName();
            this.coverImageUrl = channel.getCoverUrl();
            this.pushTriggerOption = channel.getMyPushTriggerOption();
            this.unreadMessageCount = channel.getUnreadMessageCount();
            this.coverImageHash = ChannelInfo.toUrlsHash(channel);
            this.isFrozen = channel.isFrozen();
        }

        public String getChannelUrl() {
            return this.channelUrl;
        }

        public long getCreatedAt() {
            return this.createdAt;
        }

        int getMemberCount() {
            return this.memberCount;
        }

        String getLastMessage() {
            return this.lastMessage;
        }

        GroupChannel.PushTriggerOption getPushTriggerOption() {
            return this.pushTriggerOption;
        }

        int getUnreadMessageCount() {
            return this.unreadMessageCount;
        }

        String getChannelName() {
            return this.channelName;
        }

        String getCoverImageUrl() {
            return this.coverImageUrl;
        }

        int getCoverImageHash() {
            return this.coverImageHash;
        }

        public boolean isFrozen() {
            return this.isFrozen;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChannelInfo that = (ChannelInfo)o;
            if (this.createdAt != that.createdAt) {
                return false;
            }
            if (this.memberCount != that.memberCount) {
                return false;
            }
            if (this.unreadMessageCount != that.unreadMessageCount) {
                return false;
            }
            if (this.coverImageHash != that.coverImageHash) {
                return false;
            }
            if (this.channelUrl != null && this.channelUrl.equals(that.channelUrl)) {
                return false;
            }
            if (this.lastMessage != null && this.lastMessage.equals(that.lastMessage)) {
                return false;
            }
            if (this.channelName != null && this.channelName.equals(that.channelName)) {
                return false;
            }
            if (this.coverImageUrl != null && this.coverImageUrl.equals(that.coverImageUrl)) {
                return false;
            }
            if (this.isFrozen != that.isFrozen) {
                return false;
            }
            return this.pushTriggerOption == that.pushTriggerOption;
        }

        public int hashCode() {
            int result = this.channelUrl != null ? this.channelUrl.hashCode() : 0;
            result = 31 * result + (int)(this.createdAt ^ this.createdAt >>> 32);
            result = 31 * result + this.memberCount;
            result = 31 * result + this.coverImageHash;
            result = 31 * result + (this.lastMessage != null ? this.lastMessage.hashCode() : 0);
            result = 31 * result + (this.channelName != null ? this.channelName.hashCode() : 0);
            result = 31 * result + (this.coverImageUrl != null ? this.coverImageUrl.hashCode() : 0);
            result = 31 * result + (this.pushTriggerOption != null ? this.pushTriggerOption.hashCode() : 0);
            result = 31 * result + this.unreadMessageCount;
            result = 31 * result + (this.isFrozen ? 1 : 0);
            return result;
        }

        public String toString() {
            return "ChannelInfo{channelUrl='" + this.channelUrl + '\'' + ", createdAt=" + this.createdAt + ", coverImageHash=" + this.coverImageHash + ", memberCount=" + this.memberCount + ", lastMessage='" + this.lastMessage + '\'' + ", channelName='" + this.channelName + '\'' + ", coverImageUrl='" + this.coverImageUrl + '\'' + ", pushTriggerOption=" + this.pushTriggerOption + ", unreadMessageCount=" + this.unreadMessageCount + ", isFrozen=" + this.isFrozen + '}';
        }

        static List<ChannelInfo> toChannelInfoList(@NonNull List<GroupChannel> channelList) {
            ArrayList<ChannelInfo> results = new ArrayList<ChannelInfo>();
            for (GroupChannel channel : channelList) {
                results.add(new ChannelInfo(channel));
            }
            return results;
        }

        static int toUrlsHash(@NonNull GroupChannel channel) {
            List<String> urls = ChannelUtils.makeProfileUrlsFromChannel(channel);
            StringBuilder imageUrlSum = new StringBuilder();
            for (String url : urls) {
                imageUrlSum.append(url);
            }
            return imageUrlSum.toString().hashCode();
        }
    }

    private static class ChannelPreviewHolder
    extends BaseViewHolder<GroupChannel> {
        private final SbViewChannelPreviewBinding binding;

        ChannelPreviewHolder(SbViewChannelPreviewBinding binding) {
            super(binding.getRoot());
            this.binding = binding;
        }

        @Override
        public void bind(GroupChannel channel) {
            this.binding.setChannel(channel);
            this.binding.executePendingBindings();
        }
    }
}

