/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.widgets;

import android.app.Dialog;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.os.Build;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.core.widget.ImageViewCompat;
import androidx.databinding.DataBindingUtil;
import androidx.fragment.app.FragmentManager;
import com.sendbird.uikit.R;
import com.sendbird.uikit.consts.KeyboardDisplayType;
import com.sendbird.uikit.databinding.SbViewMessageInputBinding;
import com.sendbird.uikit.fragments.SendBirdDialogFragment;
import com.sendbird.uikit.interfaces.OnInputTextChangedListener;
import com.sendbird.uikit.log.Logger;
import com.sendbird.uikit.utils.SoftInputUtils;
import com.sendbird.uikit.utils.TextUtils;
import java.lang.reflect.Field;

public class MessageInputView
extends FrameLayout {
    private SbViewMessageInputBinding binding;
    private FragmentManager fragmentManager;
    private KeyboardDisplayType displayType = KeyboardDisplayType.Plane;
    private View.OnClickListener sendClickListener;
    private View.OnClickListener addClickListener;
    private View.OnClickListener editCancelClickListener;
    private View.OnClickListener editSaveClickListener;
    private OnInputTextChangedListener inputTextChangedListener;
    private boolean isEditMode;
    private int addButtonVisibilityBeforeEditMode;

    public MessageInputView(@NonNull Context context) {
        this(context, null);
    }

    public MessageInputView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.sb_message_input_style);
    }

    public MessageInputView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.MessageInput, defStyleAttr, 0);
        try {
            this.binding = (SbViewMessageInputBinding)DataBindingUtil.inflate((LayoutInflater)LayoutInflater.from((Context)this.getContext()), (int)R.layout.sb_view_message_input, (ViewGroup)this, (boolean)true);
            int backgroundId = a.getResourceId(R.styleable.MessageInput_sb_message_input_background, R.color.background_100);
            int textBackgroundId = a.getResourceId(R.styleable.MessageInput_sb_message_input_text_background, R.drawable.sb_message_input_text_background_light);
            int textAppearance = a.getResourceId(R.styleable.MessageInput_sb_message_input_text_appearance, R.style.SendbirdBody2OnLight01);
            ColorStateList hintColor = a.getColorStateList(R.styleable.MessageInput_sb_message_input_text_hint_color);
            int textCursorDrawable = a.getResourceId(R.styleable.MessageInput_sb_message_input_text_cursor_drawable, R.drawable.sb_message_input_cursor_light);
            boolean isEnabled = a.getBoolean(R.styleable.MessageInput_sb_message_input_enable, true);
            int leftButtonTint = a.getResourceId(R.styleable.MessageInput_sb_message_input_left_button_tint, R.color.primary_300);
            int leftButtonBackground = a.getResourceId(R.styleable.MessageInput_sb_message_input_left_button_background, R.drawable.sb_button_uncontained_background_light);
            int rightButtonTint = a.getResourceId(R.styleable.MessageInput_sb_message_input_right_button_tint, R.color.primary_300);
            int rightButtonBackground = a.getResourceId(R.styleable.MessageInput_sb_message_input_right_button_background, R.drawable.sb_button_uncontained_background_light);
            int editSaveButtonTextAppearance = a.getResourceId(R.styleable.MessageInput_sb_message_input_edit_save_button_text_appearance, R.style.SendbirdButtonOnDark01);
            int editSaveButtonTextColor = a.getResourceId(R.styleable.MessageInput_sb_message_input_edit_save_button_text_color, R.color.sb_button_contained_text_color_light);
            int editSaveButtonBackground = a.getResourceId(R.styleable.MessageInput_sb_message_input_edit_save_button_background, R.drawable.sb_button_contained_background_light);
            int editCancelButtonTextAppearance = a.getResourceId(R.styleable.MessageInput_sb_message_input_edit_cancel_button_text_appearance, R.style.SendbirdButtonPrimary300);
            int editCancelButtonTextColor = a.getResourceId(R.styleable.MessageInput_sb_message_input_edit_cancel_button_text_color, R.color.sb_button_uncontained_text_color_light);
            int editCancelButtonBackground = a.getResourceId(R.styleable.MessageInput_sb_message_input_edit_cancel_button_background, R.drawable.sb_button_uncontained_background_light);
            this.binding.messageInputParent.setBackgroundResource(backgroundId);
            this.binding.etInputText.setBackgroundResource(textBackgroundId);
            this.binding.etInputText.setTextAppearance(context, textAppearance);
            if (hintColor != null) {
                this.binding.etInputText.setHintTextColor(hintColor);
            }
            if (Build.VERSION.SDK_INT >= 29) {
                this.binding.etInputText.setTextCursorDrawable(textCursorDrawable);
            } else {
                Field f = TextView.class.getDeclaredField("mCursorDrawableRes");
                f.setAccessible(true);
                f.set(this.binding.etInputText, textCursorDrawable);
            }
            this.setEnabled(isEnabled);
            this.binding.ibtnAdd.setBackgroundResource(leftButtonBackground);
            ImageViewCompat.setImageTintList((ImageView)this.binding.ibtnAdd, (ColorStateList)AppCompatResources.getColorStateList((Context)context, (int)leftButtonTint));
            this.binding.ibtnSend.setBackgroundResource(rightButtonBackground);
            ImageViewCompat.setImageTintList((ImageView)this.binding.ibtnSend, (ColorStateList)AppCompatResources.getColorStateList((Context)context, (int)rightButtonTint));
            this.binding.btnSave.setTextAppearance(context, editSaveButtonTextAppearance);
            this.binding.btnSave.setTextColor(AppCompatResources.getColorStateList((Context)context, (int)editSaveButtonTextColor));
            this.binding.btnSave.setBackgroundResource(editSaveButtonBackground);
            this.binding.btnCancel.setTextAppearance(context, editCancelButtonTextAppearance);
            this.binding.btnCancel.setTextColor(AppCompatResources.getColorStateList((Context)context, (int)editCancelButtonTextColor));
            this.binding.btnCancel.setBackgroundResource(editCancelButtonBackground);
            this.binding.etInputText.setOnClickListener(v -> {
                if (this.displayType == KeyboardDisplayType.Dialog) {
                    this.showInputDialog(this.getInputText());
                } else {
                    SoftInputUtils.showSoftKeyboard((EditText)this.binding.etInputText);
                }
            });
            this.binding.etInputText.addTextChangedListener(new TextWatcher(){

                public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                    if (!TextUtils.isEmpty(s) && !MessageInputView.this.isEditMode) {
                        MessageInputView.this.setSendButtonVisibility(0);
                    } else {
                        MessageInputView.this.setSendButtonVisibility(8);
                    }
                }

                public void onTextChanged(CharSequence s, int start, int before, int count) {
                    if (MessageInputView.this.inputTextChangedListener != null) {
                        MessageInputView.this.inputTextChangedListener.onInputTextChanged(s, start, before, count);
                    }
                }

                public void afterTextChanged(Editable s) {
                    if (!TextUtils.isEmpty((CharSequence)s) && !MessageInputView.this.isEditMode) {
                        MessageInputView.this.setSendButtonVisibility(0);
                    } else {
                        MessageInputView.this.setSendButtonVisibility(8);
                    }
                }
            });
        }
        catch (Exception e) {
            Logger.e(e);
        }
        finally {
            a.recycle();
        }
    }

    public void showEditMode(CharSequence text) {
        this.setIsEditMode(true);
        if (this.displayType == KeyboardDisplayType.Dialog) {
            this.showInputDialog(text);
            return;
        }
        this.setInputText(text.toString());
        this.addButtonVisibilityBeforeEditMode = this.binding.ibtnAdd.getVisibility();
        this.setAddButtonVisibility(8);
        this.setEditPanelVisibility(0);
        if (!TextUtils.isEmpty(text)) {
            this.binding.etInputText.setSelection(text.length());
        }
        SoftInputUtils.showSoftKeyboard((EditText)this.binding.etInputText);
    }

    public void hideEditMode() {
        this.setIsEditMode(false);
        this.setInputText("");
        this.setAddButtonVisibility(this.addButtonVisibilityBeforeEditMode);
        this.setEditPanelVisibility(8);
    }

    public SbViewMessageInputBinding getBinding() {
        return this.binding;
    }

    public View getLayout() {
        return this;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.binding.ibtnAdd.setEnabled(enabled);
        this.binding.etInputText.setEnabled(enabled);
        this.binding.ibtnSend.setEnabled(enabled);
    }

    public void setSendButtonVisibility(int visibility) {
        this.binding.ibtnSend.setVisibility(visibility);
    }

    public void setOnSendClickListener(View.OnClickListener sendClickListener) {
        this.sendClickListener = sendClickListener;
        this.binding.ibtnSend.setOnClickListener(sendClickListener);
    }

    public void setSendImageResource(@DrawableRes int sendImageResource) {
        this.binding.ibtnSend.setImageResource(sendImageResource);
    }

    public void setAddButtonVisibility(int visibility) {
        this.binding.ibtnAdd.setVisibility(visibility);
    }

    public void setOnAddClickListener(View.OnClickListener addClickListener) {
        this.addClickListener = addClickListener;
        this.binding.ibtnAdd.setOnClickListener(addClickListener);
    }

    public void setAddImageResource(@DrawableRes int addImageResource) {
        this.binding.ibtnAdd.setImageResource(addImageResource);
    }

    public void setEditPanelVisibility(int visibility) {
        this.binding.editPanel.setVisibility(visibility);
    }

    public void setOnEditCancelClickListener(View.OnClickListener editCancelClickListener) {
        this.editCancelClickListener = editCancelClickListener;
        this.binding.btnCancel.setOnClickListener(editCancelClickListener);
    }

    public void setOnEditSaveClickListener(View.OnClickListener editSaveClickListener) {
        this.editSaveClickListener = editSaveClickListener;
        this.binding.btnSave.setOnClickListener(editSaveClickListener);
    }

    public void setOnInputTextChangedListener(OnInputTextChangedListener inputTextChangedListener) {
        this.inputTextChangedListener = inputTextChangedListener;
    }

    public void setInputText(String text) {
        this.binding.etInputText.setText((CharSequence)text);
    }

    public String getInputText() {
        Editable editable = this.binding.etInputText.getText();
        return editable != null ? editable.toString().trim() : null;
    }

    public void setInputTextHint(String hint) {
        this.binding.etInputText.setHint((CharSequence)hint);
    }

    public EditText getInputEditText() {
        return this.binding.etInputText;
    }

    public void setKeyboardDisplayType(@NonNull FragmentManager fragmentManager, KeyboardDisplayType displayType) {
        this.fragmentManager = fragmentManager;
        this.displayType = displayType;
        this.binding.etInputText.setInputType(0);
    }

    public void setIsEditMode(boolean isEditMode) {
        this.isEditMode = isEditMode;
    }

    private void showInputDialog(CharSequence text) {
        SendBirdDialogFragment.Builder builder = new SendBirdDialogFragment.Builder();
        MessageInputView messageInputView = MessageInputView.generateDialogInputView(this, text, this.isEditMode);
        builder.setContentView((View)messageInputView).setDialogGravity(SendBirdDialogFragment.DialogGravity.BOTTOM);
        SendBirdDialogFragment dialogFragment = builder.create();
        Context context = messageInputView.getContext();
        int prevSoftInputMode = SoftInputUtils.getSoftInputMode(context);
        SoftInputUtils.setSoftInputMode(context, 48);
        if (this.sendClickListener != null) {
            messageInputView.setOnSendClickListener(v -> {
                this.setInputText(messageInputView.getInputText());
                dialogFragment.dismiss();
                this.binding.ibtnSend.postDelayed(() -> {
                    this.sendClickListener.onClick((View)this.binding.ibtnSend);
                    SoftInputUtils.setSoftInputMode(context, prevSoftInputMode);
                }, 200L);
            });
        }
        if (this.addClickListener != null) {
            messageInputView.setOnAddClickListener(v -> {
                dialogFragment.dismiss();
                this.binding.ibtnAdd.postDelayed(() -> {
                    this.addClickListener.onClick((View)this.binding.ibtnAdd);
                    SoftInputUtils.setSoftInputMode(context, prevSoftInputMode);
                }, 200L);
            });
        }
        if (this.editSaveClickListener != null) {
            messageInputView.setOnEditSaveClickListener(v -> {
                this.setInputText(messageInputView.getInputText());
                dialogFragment.dismiss();
                this.binding.btnSave.postDelayed(() -> {
                    this.editSaveClickListener.onClick((View)this.binding.btnSave);
                    SoftInputUtils.setSoftInputMode(context, prevSoftInputMode);
                }, 200L);
            });
        }
        if (this.editCancelClickListener != null) {
            messageInputView.setOnEditCancelClickListener(v -> {
                dialogFragment.dismiss();
                this.binding.btnCancel.postDelayed(() -> {
                    this.editCancelClickListener.onClick((View)this.binding.btnCancel);
                    SoftInputUtils.setSoftInputMode(context, prevSoftInputMode);
                }, 200L);
            });
        }
        if (this.inputTextChangedListener != null) {
            messageInputView.setOnInputTextChangedListener(this.inputTextChangedListener);
        }
        dialogFragment.showSingle(this.fragmentManager);
        SoftInputUtils.showSoftKeyboard(messageInputView.getInputEditText());
        Dialog dialog = dialogFragment.getDialog();
        if (dialog != null) {
            dialog.setOnDismissListener(d -> {
                if (!this.isEditMode) {
                    this.setInputText(messageInputView.getInputText());
                }
                dialogFragment.dismiss();
                this.setIsEditMode(false);
                this.binding.getRoot().postDelayed(() -> SoftInputUtils.setSoftInputMode(context, prevSoftInputMode), 200L);
            });
        }
    }

    private static MessageInputView generateDialogInputView(@NonNull MessageInputView currentView, CharSequence text, boolean isEditMode) {
        Context context = currentView.getContext();
        MessageInputView messageInputView = new MessageInputView(context);
        messageInputView.setIsEditMode(isEditMode);
        if (!TextUtils.isEmpty(text)) {
            messageInputView.setInputText(text.toString());
            messageInputView.getInputEditText().setSelection(text.length());
        }
        if (isEditMode) {
            messageInputView.setAddButtonVisibility(8);
            messageInputView.setEditPanelVisibility(0);
        }
        currentView.getBinding().ibtnSend.getDrawable();
        messageInputView.getBinding().ibtnSend.setImageDrawable(currentView.getBinding().ibtnSend.getDrawable());
        messageInputView.getBinding().ibtnAdd.setImageDrawable(currentView.getBinding().ibtnAdd.getDrawable());
        CharSequence currentHint = currentView.getInputEditText().getHint();
        if (!TextUtils.isEmpty(currentHint)) {
            messageInputView.setInputTextHint(currentHint.toString());
        }
        return messageInputView;
    }
}

