/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.activities;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import com.sendbird.uikit.R;
import com.sendbird.uikit.SendBirdUIKit;
import com.sendbird.uikit.fragments.ParticipantsListFragment;
import com.sendbird.uikit.utils.ContextUtils;
import com.sendbird.uikit.utils.TextUtils;

public class ParticipantsListActivity
extends AppCompatActivity {
    public static Intent newIntent(@NonNull Context context, @NonNull String channelUrl) {
        return ParticipantsListActivity.newIntentFromCustomActivity(context, ParticipantsListActivity.class, channelUrl);
    }

    public static Intent newIntentFromCustomActivity(@NonNull Context context, @NonNull Class<? extends ParticipantsListActivity> cls, @NonNull String channelUrl) {
        Intent intent = new Intent(context, cls);
        intent.putExtra("KEY_CHANNEL_URL", channelUrl);
        return intent;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setTheme(SendBirdUIKit.isDarkMode() ? R.style.SendBird_Dark : R.style.SendBird);
        this.setContentView(R.layout.sb_activity);
        String url = this.getIntent().getStringExtra("KEY_CHANNEL_URL");
        if (TextUtils.isEmpty(url)) {
            ContextUtils.toastError((Context)this, R.string.sb_text_error_get_channel);
        } else {
            ParticipantsListFragment fragment = this.createParticipantsListFragment(url);
            FragmentManager manager = this.getSupportFragmentManager();
            manager.popBackStack();
            manager.beginTransaction().replace(R.id.sb_fragment_container, (Fragment)fragment).commit();
        }
    }

    protected ParticipantsListFragment createParticipantsListFragment(@NonNull String channelUrl) {
        return new ParticipantsListFragment.Builder(channelUrl).setUseHeader(true).setHeaderTitle(this.getString(R.string.sb_text_header_participants)).setEmptyIcon(R.drawable.icon_chat).setEmptyText(R.string.sb_text_participants_list_empty).build();
    }
}

